/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.struct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs.utils.struct.LRUElementDescriptor;
import org.apache.commons.jcs.utils.struct.LRUMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLRUMap<K, V>
implements Map<K, V> {
    private static final Log log = LogFactory.getLog(AbstractLRUMap.class);
    private final DoubleLinkedList<LRUElementDescriptor<K, V>> list;
    private Map<K, LRUElementDescriptor<K, V>> map;
    int hitCnt = 0;
    int missCnt = 0;
    int putCnt = 0;
    private int chunkSize = 1;
    private final Lock lock = new ReentrantLock();

    public AbstractLRUMap() {
        this.list = new DoubleLinkedList();
        this.map = new ConcurrentHashMap<K, LRUElementDescriptor<K, V>>();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.map.clear();
            this.list.removeAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Collection<V> values() {
        ArrayList arrayList = new ArrayList(this.map.size());
        for (LRUElementDescriptor<K, V> lRUElementDescriptor : this.map.values()) {
            arrayList.add(lRUElementDescriptor.getPayload());
        }
        return arrayList;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public V get(Object object) {
        LRUElementDescriptor<K, V> lRUElementDescriptor;
        V v = null;
        if (log.isDebugEnabled()) {
            log.debug("getting item  for key " + object);
        }
        if ((lRUElementDescriptor = this.map.get(object)) != null) {
            ++this.hitCnt;
            if (log.isDebugEnabled()) {
                log.debug("LRUMap hit for " + object);
            }
            v = (V)lRUElementDescriptor.getPayload();
            this.list.makeFirst(lRUElementDescriptor);
        } else {
            ++this.missCnt;
            log.debug("LRUMap miss for " + object);
        }
        return v;
    }

    public V getQuiet(Object object) {
        V v = null;
        LRUElementDescriptor<K, V> lRUElementDescriptor = this.map.get(object);
        if (lRUElementDescriptor != null) {
            if (log.isDebugEnabled()) {
                log.debug("LRUMap quiet hit for " + object);
            }
            v = (V)lRUElementDescriptor.getPayload();
        } else if (log.isDebugEnabled()) {
            log.debug("LRUMap quiet miss for " + object);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        if (log.isDebugEnabled()) {
            log.debug("removing item for key: " + object);
        }
        this.lock.lock();
        try {
            LRUElementDescriptor<K, V> lRUElementDescriptor = this.map.remove(object);
            if (lRUElementDescriptor != null) {
                this.list.remove(lRUElementDescriptor);
                Object t = lRUElementDescriptor.getPayload();
                return (V)t;
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        LRUElementDescriptor<K, V> lRUElementDescriptor;
        ++this.putCnt;
        LRUElementDescriptor<K, V> lRUElementDescriptor2 = null;
        this.lock.lock();
        try {
            this.addFirst(k, v);
            lRUElementDescriptor = this.list.getFirst();
            lRUElementDescriptor2 = this.map.put(lRUElementDescriptor.getKey(), lRUElementDescriptor);
            if (lRUElementDescriptor2 != null && lRUElementDescriptor.getKey().equals(lRUElementDescriptor2.getKey())) {
                this.list.remove(lRUElementDescriptor2);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.shouldRemove()) {
            if (log.isDebugEnabled()) {
                log.debug("In memory limit reached, removing least recently used.");
            }
            while (this.shouldRemove()) {
                this.lock.lock();
                try {
                    lRUElementDescriptor = this.list.getLast();
                    if (lRUElementDescriptor != null) {
                        this.processRemovedLRU(lRUElementDescriptor.getKey(), lRUElementDescriptor.getPayload());
                        if (this.map.remove(lRUElementDescriptor.getKey()) == null) {
                            log.warn("update: remove failed for key: " + lRUElementDescriptor.getKey());
                            this.verifyCache();
                        }
                        this.list.removeLast();
                        continue;
                    }
                    this.verifyCache();
                    throw new Error("update: last is null!");
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("update: After spool map size: " + this.map.size());
            }
            if (this.map.size() != this.dumpCacheSize()) {
                log.error("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.dumpCacheSize());
            }
        }
        if (lRUElementDescriptor2 != null) {
            return (V)lRUElementDescriptor2.getPayload();
        }
        return null;
    }

    protected abstract boolean shouldRemove();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFirst(K k, V v) {
        this.lock.lock();
        try {
            LRUElementDescriptor<K, V> lRUElementDescriptor = new LRUElementDescriptor<K, V>(k, v);
            this.list.addFirst(lRUElementDescriptor);
        }
        finally {
            this.lock.unlock();
        }
    }

    private int dumpCacheSize() {
        return this.list.size();
    }

    public void dumpCacheEntries() {
        log.debug("dumpingCacheEntries");
        LRUElementDescriptor lRUElementDescriptor = this.list.getFirst();
        while (lRUElementDescriptor != null) {
            if (log.isDebugEnabled()) {
                log.debug("dumpCacheEntries> key=" + lRUElementDescriptor.getKey() + ", val=" + lRUElementDescriptor.getPayload());
            }
            lRUElementDescriptor = (LRUElementDescriptor)lRUElementDescriptor.next;
        }
    }

    public void dumpMap() {
        log.debug("dumpingMap");
        for (Map.Entry<K, LRUElementDescriptor<K, V>> entry : this.map.entrySet()) {
            LRUElementDescriptor<K, V> lRUElementDescriptor = entry.getValue();
            if (!log.isDebugEnabled()) continue;
            log.debug("dumpMap> key=" + entry.getKey() + ", val=" + lRUElementDescriptor.getPayload());
        }
    }

    protected void verifyCache() {
        Serializable serializable;
        Object object;
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean bl = false;
        log.debug("verifycache: mapContains " + this.map.size() + " elements, linked list contains " + this.dumpCacheSize() + " elements");
        log.debug("verifycache: checking linked list by key ");
        Object object2 = this.list.getFirst();
        while (object2 != null) {
            object = ((LRUElementDescriptor)object2).getKey();
            if (!this.map.containsKey(object)) {
                log.error("verifycache: map does not contain key : " + ((LRUElementDescriptor)object2).getKey());
                log.error("li.hashcode=" + ((LRUElementDescriptor)object2).getKey().hashCode());
                log.error("key class=" + object.getClass());
                log.error("key hashcode=" + object.hashCode());
                log.error("key toString=" + object.toString());
                if (object instanceof GroupAttrName) {
                    serializable = (GroupAttrName)object;
                    log.error("GroupID hashcode=" + ((GroupAttrName)serializable).groupId.hashCode());
                    log.error("GroupID.class=" + ((GroupAttrName)serializable).groupId.getClass());
                    log.error("AttrName hashcode=" + ((GroupAttrName)serializable).attrName.hashCode());
                    log.error("AttrName.class=" + ((GroupAttrName)serializable).attrName.getClass());
                }
                this.dumpMap();
            } else if (this.map.get(((LRUElementDescriptor)object2).getKey()) == null) {
                log.error("verifycache: linked list retrieval returned null for key: " + ((LRUElementDescriptor)object2).getKey());
            }
            object2 = (LRUElementDescriptor)((LRUElementDescriptor)object2).next;
        }
        log.debug("verifycache: checking linked list by value ");
        object2 = this.list.getFirst();
        while (object2 != null) {
            if (!this.map.containsValue(object2)) {
                log.error("verifycache: map does not contain value : " + object2);
                this.dumpMap();
            }
            object2 = (LRUElementDescriptor)((LRUElementDescriptor)object2).next;
        }
        log.debug("verifycache: checking via keysets!");
        object2 = this.map.keySet().iterator();
        while (object2.hasNext()) {
            bl = false;
            object = null;
            try {
                object = (Serializable)object2.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                log.error("verifycache: no such element exception");
                continue;
            }
            serializable = this.list.getFirst();
            while (serializable != null) {
                if (object.equals(serializable.getKey())) {
                    bl = true;
                    break;
                }
                serializable = (LRUElementDescriptor)serializable.next;
            }
            if (bl) continue;
            log.error("verifycache: key not found in list : " + object);
            this.dumpCacheEntries();
            if (this.map.containsKey(object)) {
                log.error("verifycache: map contains key");
                continue;
            }
            log.error("verifycache: map does NOT contain key, what the HECK!");
        }
    }

    protected void verifyCache(Object object) {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean bl = false;
        LRUElementDescriptor lRUElementDescriptor = this.list.getFirst();
        while (lRUElementDescriptor != null) {
            if (lRUElementDescriptor.getKey() == object) {
                bl = true;
                log.debug("verifycache(key) key match: " + object);
                break;
            }
            lRUElementDescriptor = (LRUElementDescriptor)lRUElementDescriptor.next;
        }
        if (!bl) {
            log.error("verifycache(key), couldn't find key! : " + object);
        }
    }

    protected void processRemovedLRU(K k, V v) {
        if (log.isDebugEnabled()) {
            log.debug("Removing key: [" + k + "] from LRUMap store, value = [" + v + "]");
            log.debug("LRUMap store size: '" + this.size() + "'.");
        }
    }

    public void setChunkSize(int n) {
        this.chunkSize = n;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("LRUMap");
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Integer>("List Size", this.list.size()));
        arrayList.add(new StatElement<Integer>("Map Size", this.map.size()));
        arrayList.add(new StatElement<Integer>("Put Count", this.putCnt));
        arrayList.add(new StatElement<Integer>("Hit Count", this.hitCnt));
        arrayList.add(new StatElement<Integer>("Miss Count", this.missCnt));
        stats.setStatElements(arrayList);
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.lock.lock();
        try {
            Set<Map.Entry<K, LRUElementDescriptor<K, V>>> set = this.map.entrySet();
            HashSet hashSet = new HashSet();
            for (Map.Entry<K, LRUElementDescriptor<K, V>> entry : set) {
                LRUMapEntry lRUMapEntry = new LRUMapEntry(entry.getKey(), entry.getValue().getPayload());
                hashSet.add(lRUMapEntry);
            }
            HashSet hashSet2 = hashSet;
            return hashSet2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }
}

