/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import org.glassfish.json.JsonMessages;
import org.glassfish.json.api.BufferPool;

class JsonGeneratorImpl
implements JsonGenerator {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final char[] INT_MIN_VALUE_CHARS = "-2147483648".toCharArray();
    private static final int[] INT_CHARS_SIZE_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final char[] DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private final BufferPool bufferPool;
    private final Writer writer;
    private Context currentContext = new Context(Scope.IN_NONE);
    private final Deque<Context> stack = new ArrayDeque<Context>();
    private final char[] buf;
    private int len = 0;

    JsonGeneratorImpl(Writer writer, BufferPool bufferPool) {
        this.writer = writer;
        this.bufferPool = bufferPool;
        this.buf = bufferPool.take();
    }

    JsonGeneratorImpl(OutputStream outputStream, BufferPool bufferPool) {
        this(outputStream, UTF_8, bufferPool);
    }

    JsonGeneratorImpl(OutputStream outputStream, Charset charset, BufferPool bufferPool) {
        this(new OutputStreamWriter(outputStream, charset), bufferPool);
    }

    @Override
    public void flush() {
        this.flushBuffer();
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new JsonException(JsonMessages.GENERATOR_FLUSH_IO_ERR(), iOException);
        }
    }

    @Override
    public JsonGenerator writeStartObject() {
        if (this.currentContext.scope == Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        if (this.currentContext.scope == Scope.IN_NONE && !this.currentContext.first) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_MULTIPLE_TEXT());
        }
        this.writeComma();
        this.writeChar('{');
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_OBJECT);
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String string) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeChar('{');
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_OBJECT);
        return this;
    }

    private JsonGenerator writeName(String string) {
        this.writeComma();
        this.writeEscapedString(string);
        this.writeChar(':');
        return this;
    }

    @Override
    public JsonGenerator write(String string, String string2) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeEscapedString(string2);
        return this;
    }

    @Override
    public JsonGenerator write(String string, int n) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeInt(n);
        return this;
    }

    @Override
    public JsonGenerator write(String string, long l) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeString(String.valueOf(l));
        return this;
    }

    @Override
    public JsonGenerator write(String string, double d) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException(JsonMessages.GENERATOR_DOUBLE_INFINITE_NAN());
        }
        this.writeName(string);
        this.writeString(String.valueOf(d));
        return this;
    }

    @Override
    public JsonGenerator write(String string, BigInteger bigInteger) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeString(String.valueOf(bigInteger));
        return this;
    }

    @Override
    public JsonGenerator write(String string, BigDecimal bigDecimal) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeString(String.valueOf(bigDecimal));
        return this;
    }

    @Override
    public JsonGenerator write(String string, boolean bl) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeString(bl ? "true" : "false");
        return this;
    }

    @Override
    public JsonGenerator writeNull(String string) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeString("null");
        return this;
    }

    @Override
    public JsonGenerator write(JsonValue jsonValue) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                JsonArray jsonArray = (JsonArray)jsonValue;
                this.writeStartArray();
                for (JsonValue jsonValue2 : jsonArray) {
                    this.write(jsonValue2);
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                JsonObject jsonObject = (JsonObject)jsonValue;
                this.writeStartObject();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    this.write((String)entry.getKey(), (JsonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString jsonString = (JsonString)jsonValue;
                this.write(jsonString.getString());
                break;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                this.writeValue(jsonNumber.toString());
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
            }
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        if (this.currentContext.scope == Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        if (this.currentContext.scope == Scope.IN_NONE && !this.currentContext.first) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_MULTIPLE_TEXT());
        }
        this.writeComma();
        this.writeChar('[');
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_ARRAY);
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String string) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeName(string);
        this.writeChar('[');
        this.stack.push(this.currentContext);
        this.currentContext = new Context(Scope.IN_ARRAY);
        return this;
    }

    @Override
    public JsonGenerator write(String string, JsonValue jsonValue) {
        if (this.currentContext.scope != Scope.IN_OBJECT) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                JsonArray jsonArray = (JsonArray)jsonValue;
                this.writeStartArray(string);
                for (JsonValue jsonValue2 : jsonArray) {
                    this.write(jsonValue2);
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                JsonObject jsonObject = (JsonObject)jsonValue;
                this.writeStartObject(string);
                for (Map.Entry entry : jsonObject.entrySet()) {
                    this.write((String)entry.getKey(), (JsonValue)entry.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                JsonString jsonString = (JsonString)jsonValue;
                this.write(string, jsonString.getString());
                break;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                this.writeValue(string, jsonNumber.toString());
                break;
            }
            case TRUE: {
                this.write(string, true);
                break;
            }
            case FALSE: {
                this.write(string, false);
                break;
            }
            case NULL: {
                this.writeNull(string);
            }
        }
        return this;
    }

    @Override
    public JsonGenerator write(String string) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeComma();
        this.writeEscapedString(string);
        return this;
    }

    @Override
    public JsonGenerator write(int n) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeComma();
        this.writeInt(n);
        return this;
    }

    @Override
    public JsonGenerator write(long l) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeValue(String.valueOf(l));
        return this;
    }

    @Override
    public JsonGenerator write(double d) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException(JsonMessages.GENERATOR_DOUBLE_INFINITE_NAN());
        }
        this.writeValue(String.valueOf(d));
        return this;
    }

    @Override
    public JsonGenerator write(BigInteger bigInteger) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeValue(bigInteger.toString());
        return this;
    }

    @Override
    public JsonGenerator write(BigDecimal bigDecimal) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeValue(bigDecimal.toString());
        return this;
    }

    @Override
    public JsonGenerator write(boolean bl) {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeComma();
        this.writeString(bl ? "true" : "false");
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        if (this.currentContext.scope != Scope.IN_ARRAY) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_ILLEGAL_METHOD((Object)this.currentContext.scope));
        }
        this.writeComma();
        this.writeString("null");
        return this;
    }

    private void writeValue(String string) {
        this.writeComma();
        this.writeString(string);
    }

    private void writeValue(String string, String string2) {
        this.writeComma();
        this.writeEscapedString(string);
        this.writeChar(':');
        this.writeString(string2);
    }

    @Override
    public JsonGenerator writeEnd() {
        if (this.currentContext.scope == Scope.IN_NONE) {
            throw new JsonGenerationException("writeEnd() cannot be called in no context");
        }
        this.writeChar(this.currentContext.scope == Scope.IN_ARRAY ? (char)']' : '}');
        this.currentContext = this.stack.pop();
        return this;
    }

    protected void writeComma() {
        if (!this.currentContext.first) {
            this.writeChar(',');
        }
        this.currentContext.first = false;
    }

    @Override
    public void close() {
        if (this.currentContext.scope != Scope.IN_NONE || this.currentContext.first) {
            throw new JsonGenerationException(JsonMessages.GENERATOR_INCOMPLETE_JSON());
        }
        this.flushBuffer();
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new JsonException(JsonMessages.GENERATOR_CLOSE_IO_ERR(), iOException);
        }
        this.bufferPool.recycle(this.buf);
    }

    void writeEscapedString(String string) {
        this.writeChar('\"');
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = i;
            char c = string.charAt(i);
            while (c >= ' ' && c <= '\u10ffff' && c != '\"' && c != '\\') {
                n3 = ++i;
                if (i >= n) break;
                c = string.charAt(i);
            }
            if (n2 < n3) {
                this.writeString(string, n2, n3);
                if (i == n) break;
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    this.writeChar('\\');
                    this.writeChar(c);
                    continue block8;
                }
                case '\b': {
                    this.writeChar('\\');
                    this.writeChar('b');
                    continue block8;
                }
                case '\f': {
                    this.writeChar('\\');
                    this.writeChar('f');
                    continue block8;
                }
                case '\n': {
                    this.writeChar('\\');
                    this.writeChar('n');
                    continue block8;
                }
                case '\r': {
                    this.writeChar('\\');
                    this.writeChar('r');
                    continue block8;
                }
                case '\t': {
                    this.writeChar('\\');
                    this.writeChar('t');
                    continue block8;
                }
                default: {
                    String string2 = "000" + Integer.toHexString(c);
                    this.writeString("\\u" + string2.substring(string2.length() - 4));
                }
            }
        }
        this.writeChar('\"');
    }

    void writeString(String string, int n, int n2) {
        while (n < n2) {
            int n3 = Math.min(this.buf.length - this.len, n2 - n);
            string.getChars(n, n + n3, this.buf, this.len);
            n += n3;
            this.len += n3;
            if (this.len < this.buf.length) continue;
            this.flushBuffer();
        }
    }

    void writeString(String string) {
        this.writeString(string, 0, string.length());
    }

    void writeChar(char c) {
        if (this.len >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.len++] = c;
    }

    void writeInt(int n) {
        int n2;
        if (n == Integer.MIN_VALUE) {
            n2 = INT_MIN_VALUE_CHARS.length;
        } else {
            int n3 = n2 = n < 0 ? JsonGeneratorImpl.stringSize(-n) + 1 : JsonGeneratorImpl.stringSize(n);
        }
        if (this.len + n2 >= this.buf.length) {
            this.flushBuffer();
        }
        if (n == Integer.MIN_VALUE) {
            System.arraycopy(INT_MIN_VALUE_CHARS, 0, this.buf, this.len, n2);
        } else {
            JsonGeneratorImpl.fillIntChars(n, this.buf, this.len + n2);
        }
        this.len += n2;
    }

    void flushBuffer() {
        try {
            if (this.len > 0) {
                this.writer.write(this.buf, 0, this.len);
                this.len = 0;
            }
        }
        catch (IOException iOException) {
            throw new JsonException(JsonMessages.GENERATOR_WRITE_IO_ERR(), iOException);
        }
    }

    private static int stringSize(int n) {
        int n2 = 0;
        while (n > INT_CHARS_SIZE_TABLE[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    private static void fillIntChars(int n, char[] cArray, int n2) {
        int n3;
        int n4;
        int n5 = n2;
        int n6 = 0;
        if (n < 0) {
            n6 = 45;
            n = -n;
        }
        while (n >= 65536) {
            n4 = n / 100;
            n3 = n - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n = n4;
            cArray[--n5] = DIGIT_ONES[n3];
            cArray[--n5] = DIGIT_TENS[n3];
        }
        do {
            n4 = n * 52429 >>> 19;
            n3 = n - ((n4 << 3) + (n4 << 1));
            cArray[--n5] = DIGITS[n3];
        } while ((n = n4) != 0);
        if (n6 != 0) {
            cArray[--n5] = n6;
        }
    }

    private static class Context {
        boolean first = true;
        final Scope scope;

        Context(Scope scope) {
            this.scope = scope;
        }
    }

    private static enum Scope {
        IN_NONE,
        IN_OBJECT,
        IN_ARRAY;

    }
}

