/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.Map;
import java.util.Set;

public class TileSourceInfo {
    protected String id;
    protected String url;
    protected String name;
    protected Map<String, Set<String>> noTileHeaders;
    protected Map<String, Set<String>> noTileChecksums;
    protected int minZoom;
    protected int maxZoom;
    protected String cookies = "";
    private int tileSize = -1;
    protected Map<String, String> metadataHeaders;

    public TileSourceInfo(String string, String string2, String string3) {
        this.name = string;
        this.url = string2;
        this.id = string3;
    }

    public TileSourceInfo(String string) {
        this(string, null, null);
    }

    public TileSourceInfo() {
        this(null, null, null);
    }

    public final String getName() {
        return this.name;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getId() {
        return this.id;
    }

    public Map<String, Set<String>> getNoTileHeaders() {
        return this.noTileHeaders;
    }

    public Map<String, Set<String>> getNoTileChecksums() {
        return this.noTileChecksums;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public String getCookies() {
        return this.cookies;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public Map<String, String> getMetadataHeaders() {
        return this.metadataHeaders;
    }

    public final void setTileSize(int n) {
        if (n == 0 || n < -1) {
            throw new AssertionError((Object)("Invalid tile size: " + n));
        }
        this.tileSize = n;
    }

    public final void setUrl(String string) {
        this.url = string;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final void setId(String string) {
        this.id = string;
    }
}

