/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadNotesTask;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class SearchNotesDownloadAction
extends JosmAction {
    private static final String HISTORY_KEY = "osm.notes.searchHistory";

    public SearchNotesDownloadAction() {
        super(I18n.tr("Search Notes...", new Object[0]), "note_search", I18n.tr("Download notes from the note search API", new Object[0]), null, false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        HistoryComboBox historyComboBox = new HistoryComboBox();
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(HISTORY_KEY, new LinkedList<String>()));
        Collections.reverse(linkedList);
        historyComboBox.setPossibleItems(linkedList);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)new JLabel(I18n.tr("Search the OSM API for notes containing words:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)historyComboBox, gridBagConstraints);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Search for notes", new Object[0]), I18n.tr("Search for notes", new Object[0]), I18n.tr("Cancel", new Object[0]));
        extendedDialog.setContent(jPanel);
        extendedDialog.setButtonIcons("note_search", "cancel");
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return;
        }
        String string = historyComboBox.getText();
        if (string == null || string.trim().isEmpty()) {
            Notification notification = new Notification(I18n.tr("You must enter a search term", new Object[0]));
            notification.setIcon(2);
            notification.show();
            return;
        }
        historyComboBox.addCurrentItemToHistory();
        Main.pref.putCollection(HISTORY_KEY, historyComboBox.getHistory());
        this.performSearch(string);
    }

    public void performSearch(String string) {
        String string2 = string.trim();
        try {
            long l = Long.parseLong(string2);
            new DownloadNotesTask().download(l, null);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            Main.trace(numberFormatException);
            int n = Main.pref.getInteger("osm.notes.downloadLimit", 1000);
            int n2 = Main.pref.getInteger("osm.notes.daysCloased", 7);
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append(OsmApi.getOsmApi().getBaseUrl()).append("notes/search?limit=").append(n).append("&closed=").append(n2).append("&q=").append(Utils.encodeUrl(string2));
            new DownloadNotesTask().loadUrl(false, stringBuilder.toString(), null);
            return;
        }
    }
}

