/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.io.Serializable;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.BBox;

abstract class Coordinate
implements Serializable {
    protected final double x;
    protected final double y;

    Coordinate(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    protected final double distance(Coordinate coordinate) {
        return this.distance(coordinate.x, coordinate.y);
    }

    public final double distance(double d, double d2) {
        double d3 = this.x - d;
        double d4 = this.y - d2;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    protected final double distanceSq(Coordinate coordinate) {
        return this.distanceSq(coordinate.x, coordinate.y);
    }

    public final double distanceSq(double d, double d2) {
        double d3 = this.x - d;
        double d4 = this.y - d2;
        return d3 * d3 + d4 * d4;
    }

    public BBox toBBox(double d) {
        return new BBox(this.x - d, this.y - d, this.x + d, this.y + d);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Coordinate coordinate = (Coordinate)object;
        return Double.compare(coordinate.x, this.x) == 0 && Double.compare(coordinate.y, this.y) == 0;
    }
}

