/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class TransverseMercator
extends AbstractProj {
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;
    private static final double EPSILON = 1.0E-6;
    private double eb2;
    protected double latitudeOfOrigin;
    private double ml0;

    @Override
    public String getName() {
        return I18n.tr("Transverse Mercator", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "tmerc";
    }

    @Override
    public void initialize(ProjParameters projParameters) throws ProjectionConfigurationException {
        super.initialize(projParameters);
        CheckParameterUtil.ensureParameterNotNull(projParameters, "params");
        CheckParameterUtil.ensureParameterNotNull(projParameters.ellps, "params.ellps");
        this.eb2 = projParameters.ellps.eb2;
        this.latitudeOfOrigin = projParameters.lat0 == null ? 0.0 : Math.toRadians(projParameters.lat0);
        this.ml0 = this.mlfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin), Math.cos(this.latitudeOfOrigin));
    }

    @Override
    public double[] project(double d, double d2) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        double d5 = Math.abs(d4) > 1.0E-6 ? d3 / d4 : 0.0;
        d5 *= d5;
        double d6 = d4 * d2;
        double d7 = d6 * d6;
        double d8 = this.eb2 * d4 * d4;
        d = this.mlfn(d, d3, d4) - this.ml0 + d3 * (d6 /= Math.sqrt(1.0 - this.e2 * d3 * d3)) * d2 * 0.5 * (1.0 + 0.08333333333333333 * d7 * (5.0 - d5 + d8 * (9.0 + 4.0 * d8) + 0.03333333333333333 * d7 * (61.0 + d5 * (d5 - 58.0) + d8 * (270.0 - 330.0 * d5) + 0.017857142857142856 * d7 * (1385.0 + d5 * (d5 * (543.0 - d5) - 3111.0)))));
        d2 = d6 * (1.0 + 0.16666666666666666 * d7 * (1.0 - d5 + d8 + 0.05 * d7 * (5.0 + d5 * (d5 - 18.0) + d8 * (14.0 - 58.0 * d5) + 0.023809523809523808 * d7 * (61.0 + d5 * (d5 * (179.0 - d5) - 479.0)))));
        return new double[]{d2, d};
    }

    @Override
    public double[] invproject(double d, double d2) {
        double d3 = this.invMlfn(this.ml0 + d2);
        if (Math.abs(d3) >= 1.5707963267948966) {
            d2 = d2 < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            d = 0.0;
        } else {
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = Math.abs(d5) > 1.0E-6 ? d4 / d5 : 0.0;
            double d7 = this.eb2 * d5 * d5;
            double d8 = 1.0 - this.e2 * d4 * d4;
            double d9 = d * Math.sqrt(d8);
            d8 *= d6;
            d6 *= d6;
            double d10 = d9 * d9;
            d2 = d3 - d8 * d10 / (1.0 - this.e2) * 0.5 * (1.0 - d10 * 0.08333333333333333 * (5.0 + d6 * (3.0 - 9.0 * d7) + d7 * (1.0 - 4.0 * d7) - d10 * 0.03333333333333333 * (61.0 + d6 * (90.0 - 252.0 * d7 + 45.0 * d6) + 46.0 * d7 - d10 * 0.017857142857142856 * (1385.0 + d6 * (3633.0 + d6 * (4095.0 + 1574.0 * d6))))));
            d = d9 * (1.0 - d10 * 0.16666666666666666 * (1.0 + 2.0 * d6 + d7 - d10 * 0.05 * (5.0 + d6 * (28.0 + 24.0 * d6 + 8.0 * d7) + 6.0 * d7 - d10 * 0.023809523809523808 * (61.0 + d6 * (662.0 + d6 * (1320.0 + 720.0 * d6)))))) / d5;
        }
        return new double[]{d2, d};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -7.0, 89.0, 7.0, false);
    }
}

