/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;
import org.xml.sax.SAXException;

public abstract class PleaseWaitRunnable
implements Runnable,
ProgressMonitor.CancelListener {
    private boolean ignoreException;
    private final String title;
    protected final ProgressMonitor progressMonitor;

    public PleaseWaitRunnable(String string) {
        this(string, false);
    }

    public PleaseWaitRunnable(String string, boolean bl) {
        this(string, new PleaseWaitProgressMonitor(string), bl);
    }

    public PleaseWaitRunnable(Component component, String string, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(component, "parent");
        this.title = string;
        this.progressMonitor = new PleaseWaitProgressMonitor(component, string);
        this.ignoreException = bl;
    }

    public PleaseWaitRunnable(String string, ProgressMonitor progressMonitor, boolean bl) {
        this.title = string;
        this.progressMonitor = progressMonitor == null ? new PleaseWaitProgressMonitor(string) : progressMonitor;
        this.ignoreException = bl;
    }

    private void doRealRun() {
        block13: {
            try {
                ProgressTaskId progressTaskId = null;
                try {
                    this.progressMonitor.addCancelListener(this);
                    this.progressMonitor.beginTask(this.title);
                    progressTaskId = this.progressMonitor.getProgressTaskId();
                    this.progressMonitor.setProgressTaskId(this.canRunInBackground());
                    try {
                        this.realRun();
                    }
                    finally {
                        if (EventQueue.isDispatchThread()) {
                            this.finish();
                        } else {
                            EventQueue.invokeAndWait(this::finish);
                        }
                    }
                }
                finally {
                    this.progressMonitor.finishTask();
                    this.progressMonitor.removeCancelListener(this);
                    this.progressMonitor.setProgressTaskId(progressTaskId);
                    if (this.progressMonitor instanceof PleaseWaitProgressMonitor) {
                        ((PleaseWaitProgressMonitor)this.progressMonitor).close();
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.afterFinish();
                    } else {
                        EventQueue.invokeAndWait(this::afterFinish);
                    }
                }
            }
            catch (IOException | InterruptedException | RuntimeException | InvocationTargetException | OsmTransferException | SAXException exception) {
                if (this.ignoreException) break block13;
                SwingUtilities.invokeLater(() -> {
                    if (exception instanceof RuntimeException) {
                        BugReportExceptionHandler.handleException(exception);
                    } else {
                        ExceptionDialogUtil.explainException(exception);
                    }
                });
            }
        }
    }

    protected void afterFinish() {
    }

    @Override
    public final void run() {
        if (EventQueue.isDispatchThread()) {
            new Thread(this::doRealRun, this.getClass().getName()).start();
        } else {
            this.doRealRun();
        }
    }

    @Override
    public void operationCanceled() {
        this.cancel();
    }

    protected abstract void cancel();

    protected abstract void realRun() throws SAXException, IOException, OsmTransferException;

    protected abstract void finish();

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public ProgressTaskId canRunInBackground() {
        return null;
    }
}

