/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MultiValueCellRenderer
extends JLabel
implements TableCellRenderer {
    private final ImageIcon iconDecided;
    private final ImageIcon iconUndecided;
    private final DefaultComboBoxModel<Object> model;
    private final JosmComboBox<Object> cbDecisionRenderer;

    public MultiValueCellRenderer() {
        this.setOpaque(true);
        this.iconDecided = ImageProvider.get("dialogs/conflict", "tagconflictresolved");
        this.iconUndecided = ImageProvider.get("dialogs/conflict", "tagconflictunresolved");
        this.model = new DefaultComboBoxModel();
        this.cbDecisionRenderer = new JosmComboBox<Object>(this.model);
    }

    protected void renderColors(MultiValueResolutionDecision multiValueResolutionDecision, boolean bl, boolean bl2) {
        if (bl) {
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
        } else {
            block0 : switch (multiValueResolutionDecision.getDecisionType()) {
                case UNDECIDED: {
                    this.setForeground(ConflictColors.FGCOLOR_UNDECIDED.get());
                    this.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
                    break;
                }
                case KEEP_NONE: {
                    this.setForeground(ConflictColors.FGCOLOR_TAG_KEEP_NONE.get());
                    this.setBackground(ConflictColors.BGCOLOR_TAG_KEEP_NONE.get());
                    break;
                }
                default: {
                    if (bl2) {
                        switch (multiValueResolutionDecision.getDecisionType()) {
                            case KEEP_ONE: {
                                this.setForeground(ConflictColors.FGCOLOR_TAG_KEEP_ONE.get());
                                this.setBackground(ConflictColors.BGCOLOR_TAG_KEEP_ONE.get());
                                break block0;
                            }
                            case KEEP_ALL: {
                                this.setForeground(ConflictColors.FGCOLOR_TAG_KEEP_ALL.get());
                                this.setBackground(ConflictColors.BGCOLOR_TAG_KEEP_ALL.get());
                                break block0;
                            }
                            case SUM_ALL_NUMERIC: {
                                this.setForeground(ConflictColors.FGCOLOR_TAG_SUM_ALL_NUM.get());
                                this.setBackground(ConflictColors.BGCOLOR_TAG_SUM_ALL_NUM.get());
                                break block0;
                            }
                        }
                        Main.error("Unknown decision type in renderColors(): " + (Object)((Object)multiValueResolutionDecision.getDecisionType()));
                        break;
                    }
                    this.setForeground(UIManager.getColor("Table.foreground"));
                    this.setBackground(UIManager.getColor("Table.background"));
                }
            }
        }
    }

    protected void renderValue(MultiValueResolutionDecision multiValueResolutionDecision) {
        this.model.removeAllElements();
        switch (multiValueResolutionDecision.getDecisionType()) {
            case UNDECIDED: {
                this.model.addElement(I18n.tr("Choose a value", new Object[0]));
                this.cbDecisionRenderer.setFont(this.getFont().deriveFont(2));
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            case KEEP_NONE: {
                this.model.addElement(I18n.tr("deleted", new Object[0]));
                this.cbDecisionRenderer.setFont(this.getFont().deriveFont(2));
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            case KEEP_ONE: 
            case KEEP_ALL: 
            case SUM_ALL_NUMERIC: {
                this.model.addElement(multiValueResolutionDecision.getChosenValue());
                this.cbDecisionRenderer.setFont(this.getFont());
                this.cbDecisionRenderer.setSelectedIndex(0);
                break;
            }
            default: {
                Main.error("Unknown decision type in renderValue(): " + (Object)((Object)multiValueResolutionDecision.getDecisionType()));
            }
        }
    }

    protected void renderToolTipText(MultiValueResolutionDecision multiValueResolutionDecision) {
        String string = null;
        switch (multiValueResolutionDecision.getDecisionType()) {
            case UNDECIDED: {
                string = I18n.tr("Please decide which values to keep", new Object[0]);
                break;
            }
            case KEEP_ONE: {
                string = I18n.tr("Value ''{0}'' is going to be applied for key ''{1}''", multiValueResolutionDecision.getChosenValue(), multiValueResolutionDecision.getKey());
                break;
            }
            case SUM_ALL_NUMERIC: {
                string = I18n.tr("All numeric values sumed as ''{0}'' are going to be applied for key ''{1}''", multiValueResolutionDecision.getChosenValue(), multiValueResolutionDecision.getKey());
                break;
            }
            case KEEP_NONE: {
                string = I18n.tr("The key ''{0}'' and all its values are going to be removed", multiValueResolutionDecision.getKey());
                break;
            }
            case KEEP_ALL: {
                string = I18n.tr("All values joined as ''{0}'' are going to be applied for key ''{1}''", multiValueResolutionDecision.getChosenValue(), multiValueResolutionDecision.getKey());
            }
        }
        this.setToolTipText(string);
        this.cbDecisionRenderer.setToolTipText(string);
    }

    protected void reset() {
        this.setFont(UIManager.getFont("Table.font"));
        this.setIcon(null);
        this.setText("");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.reset();
        if (object == null) {
            return this;
        }
        MultiValueResolutionDecision multiValueResolutionDecision = (MultiValueResolutionDecision)object;
        TagConflictResolverModel tagConflictResolverModel = (TagConflictResolverModel)jTable.getModel();
        boolean bl3 = tagConflictResolverModel.getKeysWithConflicts().contains(tagConflictResolverModel.getKey(n));
        this.renderColors(multiValueResolutionDecision, bl, bl3);
        this.renderToolTipText(multiValueResolutionDecision);
        switch (n2) {
            case 0: {
                if (multiValueResolutionDecision.isDecided()) {
                    this.setIcon(this.iconDecided);
                } else {
                    this.setIcon(this.iconUndecided);
                }
                return this;
            }
            case 1: {
                this.setText(multiValueResolutionDecision.getKey());
                return this;
            }
            case 2: {
                this.renderValue(multiValueResolutionDecision);
                return this.cbDecisionRenderer;
            }
        }
        return this;
    }
}

