/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ApiUrlTestTask
extends PleaseWaitRunnable {
    private final String url;
    private boolean canceled;
    private boolean success;
    private final Component parent;
    private HttpClient connection;

    public ApiUrlTestTask(Component component, String string) {
        super(component, I18n.tr("Testing OSM API URL ''{0}''", string), false);
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        this.parent = component;
        this.url = string;
    }

    protected void alertInvalidUrl(String string) {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>''{0}'' is not a valid OSM API URL.<br>Please check the spelling and validate again.</html>", string), I18n.tr("Invalid API URL", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidAPIUrl"));
    }

    protected void alertInvalidCapabilitiesUrl(String string) {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to build URL ''{0}'' for validating the OSM API server.<br>Please check the spelling of ''{1}'' and validate again.</html>", string, this.getNormalizedApiUrl()), I18n.tr("Invalid API URL", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidAPIGetChangesetsUrl"));
    }

    protected void alertConnectionFailed() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to connect to the URL ''{0}''.<br>Please check the spelling of ''{1}'' and your Internet connection and validate again.</html>", this.url, this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#ConnectionToAPIFailed"));
    }

    protected void alertInvalidServerResult(int n) {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to retrieve a list of changesets from the OSM API server at<br>''{1}''. The server responded with the return code {0} instead of 200.<br>Please check the spelling of ''{1}'' and validate again.</html>", n, this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidServerResult"));
    }

    protected void alertInvalidCapabilities() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>The OSM API server at ''{0}'' did not return a valid response.<br>It is likely that ''{0}'' is not an OSM API server.<br>Please check the spelling of ''{0}'' and validate again.</html>", this.getNormalizedApiUrl()), I18n.tr("Connection to API failed", new Object[0]), 0, HelpUtil.ht("/Preferences/Connection#InvalidSettings"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ApiUrlTestTask apiUrlTestTask = this;
        synchronized (apiUrlTestTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected String getNormalizedApiUrl() {
        String string = this.url.trim();
        while (string.endsWith("/")) {
            string = string.substring(0, string.lastIndexOf(47));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            URL uRL;
            try {
                new URL(this.getNormalizedApiUrl());
            }
            catch (MalformedURLException malformedURLException) {
                this.alertInvalidUrl(this.getNormalizedApiUrl());
                return;
            }
            String string = this.getNormalizedApiUrl() + "/0.6/capabilities";
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                this.alertInvalidCapabilitiesUrl(string);
                return;
            }
            ApiUrlTestTask apiUrlTestTask = this;
            synchronized (apiUrlTestTask) {
                this.connection = HttpClient.create(uRL);
                this.connection.connect();
            }
            if (this.connection.getResponse().getResponseCode() != 200) {
                this.alertInvalidServerResult(this.connection.getResponse().getResponseCode());
                return;
            }
            try {
                Capabilities.CapabilitiesParser.parse(new InputSource(this.connection.getResponse().getContent()));
            }
            catch (ParserConfigurationException | SAXException exception) {
                Main.warn(exception);
                this.alertInvalidCapabilities();
                return;
            }
            this.success = true;
        }
        catch (IOException iOException) {
            if (this.canceled) {
                return;
            }
            Main.error(iOException);
            this.alertConnectionFailed();
            return;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

