/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.MultipolygonBuilder;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.tools.Pair;

public class GeoJSONWriter {
    private final OsmDataLayer layer;
    private final Projection projection;
    private static final boolean skipEmptyNodes = true;

    public GeoJSONWriter(OsmDataLayer osmDataLayer) {
        this.layer = osmDataLayer;
        this.projection = ProjectionPreference.wgs84.getProjection();
    }

    public String write() {
        return this.write(true);
    }

    public String write(boolean bl) {
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(1);
        hashMap.put("javax.json.stream.JsonGenerator.prettyPrinting", bl);
        try (JsonWriter jsonWriter = Json.createWriterFactory(hashMap).createWriter(stringWriter);){
            JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder().add("type", "FeatureCollection").add("generator", "JOSM");
            this.appendLayerBounds(this.layer.data, jsonObjectBuilder);
            this.appendLayerFeatures(this.layer.data, jsonObjectBuilder);
            jsonWriter.writeObject(jsonObjectBuilder.build());
            String string = stringWriter.toString();
            return string;
        }
    }

    private JsonArrayBuilder getCoorArray(JsonArrayBuilder jsonArrayBuilder, LatLon latLon) {
        return GeoJSONWriter.getCoorArray(jsonArrayBuilder, this.projection.latlon2eastNorth(latLon));
    }

    private static JsonArrayBuilder getCoorArray(JsonArrayBuilder jsonArrayBuilder, EastNorth eastNorth) {
        return jsonArrayBuilder != null ? jsonArrayBuilder : Json.createArrayBuilder().add(BigDecimal.valueOf(eastNorth.getX()).setScale(11, RoundingMode.HALF_UP)).add(BigDecimal.valueOf(eastNorth.getY()).setScale(11, RoundingMode.HALF_UP));
    }

    private JsonArrayBuilder getCoorsArray(Iterable<Node> iterable) {
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (Node node : iterable) {
            LatLon latLon = node.getCoor();
            if (latLon == null) continue;
            jsonArrayBuilder.add(this.getCoorArray(null, latLon));
        }
        return jsonArrayBuilder;
    }

    protected void appendPrimitive(OsmPrimitive osmPrimitive, JsonArrayBuilder jsonArrayBuilder) {
        if (osmPrimitive.isIncomplete()) {
            return;
        }
        if (osmPrimitive instanceof Node && osmPrimitive.getKeys().isEmpty()) {
            return;
        }
        JsonObjectBuilder jsonObjectBuilder = Json.createObjectBuilder();
        for (Map.Entry<String, String> entry : osmPrimitive.getKeys().entrySet()) {
            jsonObjectBuilder.add(entry.getKey(), entry.getValue());
        }
        JsonObjectBuilder jsonObjectBuilder2 = Json.createObjectBuilder();
        osmPrimitive.accept(new GeometryPrimitiveVisitor(jsonObjectBuilder2));
        jsonArrayBuilder.add(Json.createObjectBuilder().add("type", "Feature").add("properties", jsonObjectBuilder).add("geometry", jsonObjectBuilder2));
    }

    protected void appendLayerBounds(DataSet dataSet, JsonObjectBuilder jsonObjectBuilder) {
        Iterator<Bounds> iterator;
        if (dataSet != null && (iterator = dataSet.getDataSourceBounds().iterator()).hasNext()) {
            Bounds bounds = new Bounds(iterator.next());
            while (iterator.hasNext()) {
                bounds.extend(iterator.next());
            }
            this.appendBounds(bounds, jsonObjectBuilder);
        }
    }

    protected void appendBounds(Bounds bounds, JsonObjectBuilder jsonObjectBuilder) {
        if (bounds != null) {
            JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
            this.getCoorArray(jsonArrayBuilder, bounds.getMin());
            this.getCoorArray(jsonArrayBuilder, bounds.getMax());
            jsonObjectBuilder.add("bbox", jsonArrayBuilder);
        }
    }

    protected void appendLayerFeatures(DataSet dataSet, JsonObjectBuilder jsonObjectBuilder) {
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        if (dataSet != null) {
            dataSet.allPrimitives().forEach(osmPrimitive -> this.appendPrimitive((OsmPrimitive)osmPrimitive, jsonArrayBuilder));
        }
        jsonObjectBuilder.add("features", jsonArrayBuilder);
    }

    private class GeometryPrimitiveVisitor
    extends AbstractVisitor {
        private final JsonObjectBuilder geomObj;

        GeometryPrimitiveVisitor(JsonObjectBuilder jsonObjectBuilder) {
            this.geomObj = jsonObjectBuilder;
        }

        @Override
        public void visit(Node node) {
            this.geomObj.add("type", "Point");
            LatLon latLon = node.getCoor();
            if (latLon != null) {
                this.geomObj.add("coordinates", GeoJSONWriter.this.getCoorArray(null, node.getCoor()));
            }
        }

        @Override
        public void visit(Way way) {
            if (way != null) {
                JsonArrayBuilder jsonArrayBuilder = GeoJSONWriter.this.getCoorsArray(way.getNodes());
                if (ElemStyles.hasAreaElemStyle(way, false)) {
                    JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder().add(jsonArrayBuilder);
                    this.geomObj.add("type", "Polygon");
                    this.geomObj.add("coordinates", jsonArrayBuilder2);
                } else {
                    this.geomObj.add("type", "LineString");
                    this.geomObj.add("coordinates", jsonArrayBuilder);
                }
            }
        }

        @Override
        public void visit(Relation relation) {
            if (relation != null && relation.isMultipolygon() && !relation.hasIncompleteMembers()) {
                Pair<List<MultipolygonBuilder.JoinedPolygon>, List<MultipolygonBuilder.JoinedPolygon>> pair = MultipolygonBuilder.joinWays(relation);
                JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
                Stream.concat(((List)pair.a).stream(), ((List)pair.b).stream()).map(joinedPolygon -> GeoJSONWriter.this.getCoorsArray(joinedPolygon.getNodes()).add(GeoJSONWriter.this.getCoorArray(null, joinedPolygon.getNodes().get(0).getCoor()))).forEach(jsonArrayBuilder::add);
                this.geomObj.add("type", "MultiPolygon");
                JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder().add(jsonArrayBuilder);
                this.geomObj.add("coordinates", jsonArrayBuilder2);
            }
        }
    }
}

