/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.EnumSet;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.rest.RestStatus;

public class DiscoverySettings
extends AbstractComponent {
    public static final String PUBLISH_TIMEOUT = "discovery.zen.publish_timeout";
    public static final String NO_MASTER_BLOCK = "discovery.zen.no_master_block";
    public static final String PUBLISH_DIFF_ENABLE = "discovery.zen.publish_diff.enable";
    public static final TimeValue DEFAULT_PUBLISH_TIMEOUT = TimeValue.timeValueSeconds(30L);
    public static final String DEFAULT_NO_MASTER_BLOCK = "write";
    public static final int NO_MASTER_BLOCK_ID = 2;
    public static final boolean DEFAULT_PUBLISH_DIFF_ENABLE = true;
    public static final ClusterBlock NO_MASTER_BLOCK_ALL = new ClusterBlock(2, "no master", true, true, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    public static final ClusterBlock NO_MASTER_BLOCK_WRITES = new ClusterBlock(2, "no master", true, false, RestStatus.SERVICE_UNAVAILABLE, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    private volatile ClusterBlock noMasterBlock;
    private volatile TimeValue publishTimeout = DEFAULT_PUBLISH_TIMEOUT;
    private volatile boolean publishDiff = true;

    @Inject
    public DiscoverySettings(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        nodeSettingsService.addListener(new ApplySettings());
        this.noMasterBlock = this.parseNoMasterBlock(settings.get(NO_MASTER_BLOCK, DEFAULT_NO_MASTER_BLOCK));
        this.publishTimeout = settings.getAsTime(PUBLISH_TIMEOUT, this.publishTimeout);
        this.publishDiff = settings.getAsBoolean(PUBLISH_DIFF_ENABLE, (Boolean)true);
    }

    public TimeValue getPublishTimeout() {
        return this.publishTimeout;
    }

    public ClusterBlock getNoMasterBlock() {
        return this.noMasterBlock;
    }

    public boolean getPublishDiff() {
        return this.publishDiff;
    }

    private ClusterBlock parseNoMasterBlock(String value) {
        switch (value) {
            case "all": {
                return NO_MASTER_BLOCK_ALL;
            }
            case "write": {
                return NO_MASTER_BLOCK_WRITES;
            }
        }
        throw new IllegalArgumentException("invalid master block [" + value + "]");
    }

    private class ApplySettings
    implements NodeSettingsService.Listener {
        private ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            Boolean newPublishDiff;
            ClusterBlock newNoMasterBlock;
            String newNoMasterBlockValue;
            TimeValue newPublishTimeout = settings.getAsTime(DiscoverySettings.PUBLISH_TIMEOUT, null);
            if (newPublishTimeout != null && newPublishTimeout.millis() != DiscoverySettings.this.publishTimeout.millis()) {
                DiscoverySettings.this.logger.info("updating [{}] from [{}] to [{}]", DiscoverySettings.PUBLISH_TIMEOUT, DiscoverySettings.this.publishTimeout, newPublishTimeout);
                DiscoverySettings.this.publishTimeout = newPublishTimeout;
            }
            if ((newNoMasterBlockValue = settings.get(DiscoverySettings.NO_MASTER_BLOCK)) != null && (newNoMasterBlock = DiscoverySettings.this.parseNoMasterBlock(newNoMasterBlockValue)) != DiscoverySettings.this.noMasterBlock) {
                DiscoverySettings.this.noMasterBlock = newNoMasterBlock;
            }
            if ((newPublishDiff = settings.getAsBoolean(DiscoverySettings.PUBLISH_DIFF_ENABLE, null)) != null && newPublishDiff != DiscoverySettings.this.publishDiff) {
                DiscoverySettings.this.logger.info("updating [{}] from [{}] to [{}]", DiscoverySettings.PUBLISH_DIFF_ENABLE, DiscoverySettings.this.publishDiff, newPublishDiff);
                DiscoverySettings.this.publishDiff = newPublishDiff;
            }
        }
    }
}

