/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.diagnostics.analyzer;

import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class NoUniqueBeanDefinitionFailureAnalyzer
extends AbstractFailureAnalyzer<NoUniqueBeanDefinitionException>
implements BeanFactoryAware {
    private ConfigurableBeanFactory beanFactory;

    NoUniqueBeanDefinitionFailureAnalyzer() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableBeanFactory.class, (Object)beanFactory);
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    @Override
    protected FailureAnalysis analyze(Throwable rootFailure, NoUniqueBeanDefinitionException cause) {
        String consumerDescription = this.getConsumerDescription(rootFailure);
        if (consumerDescription == null) {
            return null;
        }
        String[] beanNames = this.extractBeanNames(cause);
        if (beanNames == null) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format("%s required a single bean, but %d were found:%n", consumerDescription, beanNames.length));
        for (String beanName : beanNames) {
            try {
                BeanDefinition beanDefinition = this.beanFactory.getMergedBeanDefinition(beanName);
                if (StringUtils.hasText((String)beanDefinition.getFactoryMethodName())) {
                    message.append(String.format("\t- %s: defined by method '%s' in %s%n", beanName, beanDefinition.getFactoryMethodName(), beanDefinition.getResourceDescription()));
                    continue;
                }
                message.append(String.format("\t- %s: defined in %s%n", beanName, beanDefinition.getResourceDescription()));
            }
            catch (NoSuchBeanDefinitionException ex) {
                message.append(String.format("\t- %s: a programmatically registered singleton", beanName));
            }
        }
        return new FailureAnalysis(message.toString(), "Consider marking one of the beans as @Primary, updating the consumer to accept multiple beans, or using @Qualifier to identify the bean that should be consumed", (Throwable)cause);
    }

    private String getConsumerDescription(Throwable ex) {
        UnsatisfiedDependencyException unsatisfiedDependency = this.findUnsatisfiedDependencyException(ex);
        if (unsatisfiedDependency != null) {
            return this.getConsumerDescription(unsatisfiedDependency);
        }
        BeanInstantiationException beanInstantiationException = this.findBeanInstantiationException(ex);
        if (beanInstantiationException != null) {
            return this.getConsumerDescription(beanInstantiationException);
        }
        return null;
    }

    private UnsatisfiedDependencyException findUnsatisfiedDependencyException(Throwable root) {
        return this.findMostNestedCause(root, UnsatisfiedDependencyException.class);
    }

    private BeanInstantiationException findBeanInstantiationException(Throwable root) {
        return this.findMostNestedCause(root, BeanInstantiationException.class);
    }

    private <T extends Exception> T findMostNestedCause(Throwable root, Class<T> causeType) {
        Exception mostNestedMatch = null;
        for (Throwable candidate = root; candidate != null; candidate = candidate.getCause()) {
            if (!causeType.isAssignableFrom(candidate.getClass())) continue;
            mostNestedMatch = (Exception)candidate;
        }
        return (T)mostNestedMatch;
    }

    private String getConsumerDescription(UnsatisfiedDependencyException ex) {
        InjectionPoint injectionPoint = ex.getInjectionPoint();
        if (injectionPoint != null) {
            if (injectionPoint.getField() != null) {
                return String.format("Field %s in %s", injectionPoint.getField().getName(), injectionPoint.getField().getDeclaringClass().getName());
            }
            if (injectionPoint.getMethodParameter() != null) {
                if (injectionPoint.getMethodParameter().getConstructor() != null) {
                    return String.format("Parameter %d of constructor in %s", injectionPoint.getMethodParameter().getParameterIndex(), injectionPoint.getMethodParameter().getDeclaringClass().getName());
                }
                return String.format("Parameter %d of method %s in %s", injectionPoint.getMethodParameter().getParameterIndex(), injectionPoint.getMethodParameter().getMethod().getName(), injectionPoint.getMethodParameter().getDeclaringClass().getName());
            }
        }
        return ex.getResourceDescription();
    }

    private String getConsumerDescription(BeanInstantiationException ex) {
        if (ex.getConstructingMethod() != null) {
            return String.format("Method %s in %s", ex.getConstructingMethod().getName(), ex.getConstructingMethod().getDeclaringClass().getName());
        }
        if (ex.getConstructor() != null) {
            return String.format("Constructor in %s", ClassUtils.getUserClass(ex.getConstructor().getDeclaringClass()).getName());
        }
        return ex.getBeanClass().getName();
    }

    private String[] extractBeanNames(NoUniqueBeanDefinitionException cause) {
        if (cause.getMessage().indexOf("but found") > -1) {
            return StringUtils.commaDelimitedListToStringArray((String)cause.getMessage().substring(cause.getMessage().lastIndexOf(":") + 1).trim());
        }
        return null;
    }
}

