/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QMAtom;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public abstract class QuantumCalculation {
    protected boolean doDebug = false;
    protected BS bsExcluded;
    protected static final float bohr_per_angstrom = 1.8897161f;
    protected float[][][] voxelData;
    protected float[][][] voxelDataTemp;
    protected float[] vd;
    protected int[] countsXYZ;
    protected T3[] points;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected int zMin;
    protected int zMax;
    protected QMAtom[] qmAtoms;
    protected int atomIndex;
    protected QMAtom thisAtom;
    protected int firstAtomOffset;
    protected float[] xBohr;
    protected float[] yBohr;
    protected float[] zBohr;
    protected float[] originBohr = new float[3];
    protected float[] stepBohr = new float[3];
    protected int nX;
    protected int nY;
    protected int nZ;
    protected float[] X;
    protected float[] Y;
    protected float[] Z;
    protected float[] X2;
    protected float[] Y2;
    protected float[] Z2;
    protected float rangeBohrOrAngstroms = 10.0f;
    protected float unitFactor = 1.8897161f;
    protected float volume = 1.0f;

    protected void initialize(int nX, int nY, int nZ, T3[] points) {
        this.initialize0(nX, nY, nZ, points);
    }

    protected void initialize0(int nX, int nY, int nZ, T3[] points) {
        if (points != null) {
            this.points = points;
            nY = nZ = points.length;
            nX = nZ;
        }
        this.nX = this.xMax = nX;
        this.nY = this.yMax = nY;
        this.nZ = this.zMax = nZ;
        if (this.xBohr != null && this.xBohr.length >= nX) {
            return;
        }
        this.xBohr = new float[nX];
        this.yBohr = new float[nY];
        this.zBohr = new float[nZ];
        this.X = new float[nX];
        this.Y = new float[nY];
        this.Z = new float[nZ];
        this.X2 = new float[nX];
        this.Y2 = new float[nY];
        this.Z2 = new float[nZ];
    }

    protected void setupCoordinates(float[] originXYZ, float[] stepsXYZ, BS bsSelected, T3[] xyz, Atom[] atoms, T3[] points, boolean renumber) {
        int i0;
        if (atoms == null) {
            atoms = (Atom[])xyz;
        }
        if (points == null) {
            this.volume = 1.0f;
            int i = 3;
            while (--i >= 0) {
                this.originBohr[i] = originXYZ[i] * this.unitFactor;
                this.stepBohr[i] = stepsXYZ[i] * this.unitFactor;
                this.volume *= this.stepBohr[i];
            }
            Logger.info("QuantumCalculation:\n origin = " + Escape.eAF(originXYZ) + "\n steps = " + Escape.eAF(stepsXYZ) + "\n origin(Bohr)= " + Escape.eAF(this.originBohr) + "\n steps(Bohr)= " + Escape.eAF(this.stepBohr) + "\n counts= " + this.nX + " " + this.nY + " " + this.nZ);
        }
        this.qmAtoms = new QMAtom[renumber ? bsSelected.cardinality() : xyz.length];
        boolean isAll = bsSelected == null;
        int i = i0 = isAll ? this.qmAtoms.length - 1 : bsSelected.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            this.qmAtoms[renumber ? j++ : i] = new QMAtom(i, xyz[i], atoms[i], this.X, this.Y, this.Z, this.X2, this.Y2, this.Z2, this.unitFactor);
            i = isAll ? i - 1 : bsSelected.nextSetBit(i + 1);
        }
    }

    public float processPt(T3 pt) {
        this.doDebug = false;
        if (this.points == null || this.nX != 1) {
            this.initializeOnePoint();
        }
        this.points[0].setT(pt);
        this.voxelDataTemp[0][0][0] = 0.0f;
        this.setXYZBohr(this.points);
        this.processPoints();
        return this.voxelData[0][0][0];
    }

    protected void processPoints() {
        this.process();
    }

    protected void initializeOnePoint() {
        this.initializeOnePointQC();
    }

    protected void initializeOnePointQC() {
        this.points = new P3[1];
        this.points[0] = new P3();
        if (this.voxelData == null || this.voxelData == this.voxelDataTemp) {
            this.voxelDataTemp = new float[1][1][1];
            this.voxelData = this.voxelDataTemp;
        } else {
            this.voxelData = new float[1][1][1];
            this.voxelDataTemp = new float[1][1][1];
        }
        this.zMin = 0;
        this.yMin = 0;
        this.xMin = 0;
        this.initialize(1, 1, 1, this.points);
    }

    protected abstract void process();

    protected void setXYZBohr(T3[] points) {
        this.setXYZBohrI(this.xBohr, 0, this.nX, points);
        this.setXYZBohrI(this.yBohr, 1, this.nY, points);
        this.setXYZBohrI(this.zBohr, 2, this.nZ, points);
    }

    private void setXYZBohrI(float[] bohr, int i, int n, T3[] points) {
        if (points != null) {
            float x = 0.0f;
            for (int j = 0; j < n; ++j) {
                switch (i) {
                    case 0: {
                        x = points[j].x;
                        break;
                    }
                    case 1: {
                        x = points[j].y;
                        break;
                    }
                    case 2: {
                        x = points[j].z;
                    }
                }
                bohr[j] = x * this.unitFactor;
            }
            return;
        }
        bohr[0] = this.originBohr[i];
        float inc = this.stepBohr[i];
        int j = 0;
        while (++j < n) {
            bohr[j] = bohr[j - 1] + inc;
        }
    }

    protected void setMinMax(int ix) {
        this.zMax = ix < 0 ? this.xMax : ix + 1;
        this.yMax = this.zMax;
        this.zMin = ix < 0 ? 0 : ix;
        this.yMin = this.zMin;
    }

    public abstract void createCube();
}

