/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jcodings.Encoding;
import org.jruby.EvalType;
import org.jruby.Finalizable;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Constants;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InstanceVariables;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.component.VariableEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.ivars.VariableAccessor;
import org.jruby.runtime.marshal.CoreObjectType;
import org.jruby.util.ArraySupport;
import org.jruby.util.IdUtil;
import org.jruby.util.TypeConverter;
import org.jruby.util.unsafe.UnsafeHolder;

public class RubyBasicObject
implements Cloneable,
IRubyObject,
Serializable,
Comparable<IRubyObject>,
CoreObjectType,
InstanceVariables,
InternalVariables {
    protected transient RubyClass metaClass;
    protected int flags;
    public transient Object[] varTable;
    public volatile transient int varTableStamp;
    public static final long VAR_TABLE_OFFSET = UnsafeHolder.fieldOffset(RubyBasicObject.class, "varTable");
    public static final long STAMP_OFFSET = UnsafeHolder.fieldOffset(RubyBasicObject.class, "varTableStamp");
    public static final String ERR_INSECURE_SET_INST_VAR = "Insecure: can't modify instance variable";
    public static final int ALL_F = -1;
    public static final int FALSE_F = Constants.FALSE_F;
    public static final int NIL_F = Constants.NIL_F;
    public static final int FROZEN_F = Constants.FROZEN_F;
    public static final int TAINTED_F = Constants.TAINTED_F;
    public static final IRubyObject NEVER = new RubyBasicObject();
    public static final IRubyObject UNDEF = new RubyBasicObject();
    public static final ObjectAllocator BASICOBJECT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyBasicObject(runtime, klass);
        }
    };
    @Deprecated
    public static final int UNTRUST_F = 8;
    @Deprecated
    public static final int FL_USHIFT = 4;
    @Deprecated
    public static final int USER0_F = 16;
    @Deprecated
    public static final int USER1_F = 32;
    @Deprecated
    public static final int USER2_F = 64;
    @Deprecated
    public static final int USER3_F = 128;
    @Deprecated
    public static final int USER4_F = 256;
    @Deprecated
    public static final int USER5_F = 512;
    @Deprecated
    public static final int USER6_F = 1024;
    @Deprecated
    public static final int USER7_F = 2048;
    @Deprecated
    public static final int USER8_F = 4096;
    @Deprecated
    public static final int USER9_F = 8192;
    @Deprecated
    public static final int USERA_F = 16384;
    @Deprecated
    public static final int REFINED_MODULE_F = 8192;
    @Deprecated
    public static final int IS_OVERLAID_F = 16384;
    @Deprecated
    public static final int COMPARE_BY_IDENTITY_F = 4096;

    private RubyBasicObject() {
    }

    public static RubyClass createBasicObjectClass(Ruby runtime, RubyClass objectClass) {
        objectClass.setClassIndex(ClassIndex.OBJECT);
        objectClass.defineAnnotatedMethods(RubyBasicObject.class);
        RubyBasicObject.recacheBuiltinMethods(runtime);
        return objectClass;
    }

    static void recacheBuiltinMethods(Ruby runtime) {
        RubyClass objectClass = runtime.getBasicObject();
        runtime.setDefaultMethodMissing(objectClass.searchMethod("method_missing"), objectClass.getMetaClass().searchMethod("method_missing"));
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return context.nil;
    }

    @Deprecated
    public IRubyObject initialize19(ThreadContext context) {
        return this.initialize(context);
    }

    public RubyBasicObject(Ruby runtime, RubyClass metaClass) {
        this.metaClass = metaClass;
        runtime.addToObjectSpace(true, this);
    }

    public RubyBasicObject(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    protected RubyBasicObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace) {
        this.metaClass = metaClass;
        runtime.addToObjectSpace(useObjectSpace, this);
    }

    protected void taint(Ruby runtime) {
        if (!this.isTaint()) {
            this.testFrozen();
            this.setTaint(true);
        }
    }

    protected final void testFrozen(String message2) {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(message2);
        }
    }

    protected final void testFrozen() {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError("object");
        }
    }

    public final void setFlag(int flag, boolean set) {
        this.flags = set ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    @Override
    public final IRubyObject checkCallMethod(ThreadContext context, String name2) {
        return Helpers.invokeChecked(context, (IRubyObject)this, name2);
    }

    @Override
    public final IRubyObject checkCallMethod(ThreadContext context, JavaSites.CheckedSites sites) {
        return Helpers.invokeChecked(context, (IRubyObject)this, sites);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2) {
        return Helpers.invoke(context, this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject arg2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, arg2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, args2);
    }

    public final IRubyObject callMethod(String name2, IRubyObject ... args2) {
        return Helpers.invoke(this.getRuntime().getCurrentContext(), (IRubyObject)this, name2, args2);
    }

    public final IRubyObject callMethod(String name2) {
        return Helpers.invoke(this.getRuntime().getCurrentContext(), this, name2);
    }

    @Override
    public final IRubyObject callMethod(ThreadContext context, String name2, IRubyObject[] args2, Block block) {
        return Helpers.invoke(context, (IRubyObject)this, name2, args2, block);
    }

    @Override
    public final boolean isNil() {
        return (this.flags & NIL_F) != 0;
    }

    @Override
    public final boolean isTrue() {
        return (this.flags & FALSE_F) == 0;
    }

    public final boolean isFalse() {
        return (this.flags & FALSE_F) != 0;
    }

    @Override
    public boolean isTaint() {
        return (this.flags & TAINTED_F) != 0;
    }

    @Override
    public void setTaint(boolean taint2) {
        if (this.isImmediate()) {
            return;
        }
        this.flags = taint2 ? (this.flags |= TAINTED_F) : (this.flags &= ~TAINTED_F);
    }

    @Override
    public IRubyObject infectBy(IRubyObject obj) {
        if (obj.isTaint()) {
            this.setTaint(true);
        }
        return this;
    }

    final RubyBasicObject infectBy(RubyBasicObject obj) {
        this.flags |= obj.flags & TAINTED_F;
        return this;
    }

    final RubyBasicObject infectBy(int tuFlags) {
        this.flags |= tuFlags & TAINTED_F;
        return this;
    }

    @Override
    public boolean isFrozen() {
        return (this.flags & FROZEN_F) != 0;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.flags = frozen ? (this.flags |= FROZEN_F) : (this.flags &= ~FROZEN_F);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public boolean isSpecialConst() {
        return this.isImmediate() || !this.isTrue();
    }

    @Override
    public final RubyClass getMetaClass() {
        return this.metaClass;
    }

    @Override
    public RubyClass getSingletonClass() {
        RubyClass klass = this.getMetaClass().isSingleton() && ((MetaClass)this.getMetaClass()).getAttached() == this ? this.getMetaClass() : this.makeMetaClass(this.getMetaClass());
        klass.setTaint(this.isTaint());
        if (this.isFrozen()) {
            klass.setFrozen(true);
        }
        return klass;
    }

    public RubyClass makeMetaClass(RubyClass superClass) {
        MetaClass klass = new MetaClass(this.getRuntime(), superClass, this);
        this.setMetaClass(klass);
        klass.setMetaClass(superClass.getRealClass().getMetaClass());
        superClass.addSubclass(klass);
        return klass;
    }

    public void setMetaClass(RubyClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    public RubyClass getType() {
        return this.getMetaClass().getRealClass();
    }

    @Override
    public final boolean respondsTo(String name2) {
        Ruby runtime = this.getRuntime();
        DynamicMethod respondTo = this.getMetaClass().searchMethod("respond_to?");
        if (respondTo.equals(runtime.getRespondToMethod()) && this.getMetaClass().searchMethod("respond_to_missing?").equals(runtime.getRespondToMissingMethod())) {
            return this.getMetaClass().isMethodBound(name2, false);
        }
        ThreadContext context = runtime.getCurrentContext();
        RubySymbol mname = runtime.newSymbol(name2);
        boolean respondToUndefined = respondTo.isUndefined();
        if (respondToUndefined) {
            return RubyBasicObject.sites((ThreadContext)context).respond_to.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)mname).isTrue();
        }
        String respondName = "respond_to?";
        Arity arity2 = respondTo.getArity();
        if (arity2.isFixed()) {
            if (arity2.required() == 1) {
                return respondTo.call(context, (IRubyObject)this, (RubyModule)this.metaClass, "respond_to?", mname).isTrue();
            }
            if (arity2.required() != 2) {
                throw runtime.newArgumentError("respond_to? must accept 1 or 2 arguments (requires " + arity2.getValue() + ")");
            }
        }
        return respondTo.call(context, (IRubyObject)this, (RubyModule)this.metaClass, "respond_to?", (IRubyObject)mname, runtime.getTrue()).isTrue();
    }

    @Override
    public final boolean respondsToMissing(String name2) {
        return this.respondsToMissing(name2, true);
    }

    @Override
    public final boolean respondsToMissing(String name2, boolean incPrivate) {
        DynamicMethod method = this.getMetaClass().searchMethod("respond_to_missing?");
        if (method.isUndefined()) {
            return false;
        }
        Ruby runtime = this.getRuntime();
        return method.call(runtime.getCurrentContext(), (IRubyObject)this, (RubyModule)this.getMetaClass(), "respond_to_missing?", (IRubyObject)runtime.newSymbol(name2), runtime.newBoolean(incPrivate)).isTrue();
    }

    @Override
    public final Ruby getRuntime() {
        return this.getMetaClass().getClassRuntime();
    }

    @Override
    public Class getJavaClass() {
        Object obj = this.dataGetStruct();
        if (obj instanceof JavaObject) {
            return ((JavaObject)obj).getValue().getClass();
        }
        return this.getClass();
    }

    @Override
    public String asJavaString() {
        IRubyObject asString = this.checkStringType();
        if (!asString.isNil()) {
            return ((RubyString)asString).asJavaString();
        }
        throw this.getRuntime().newTypeError(this.inspect().toString() + " is not a string");
    }

    @Override
    public RubyString asString() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        IRubyObject str = sites.to_s.call(context, this, this);
        if (!(str instanceof RubyString)) {
            return (RubyString)this.anyToString();
        }
        if (this.isTaint()) {
            str.setTaint(true);
        }
        return (RubyString)str;
    }

    @Override
    public RubyArray convertToArray() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyArray)TypeConverter.convertToType(context, this, runtime.getArray(), sites.to_ary_checked);
    }

    @Override
    public RubyHash convertToHash() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyHash)TypeConverter.convertToType(context, this, runtime.getHash(), sites.to_hash_checked);
    }

    @Override
    public RubyFloat convertToFloat() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyFloat)TypeConverter.convertToType(context, this, runtime.getFloat(), sites.to_f_checked);
    }

    @Override
    public RubyInteger convertToInteger() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        IRubyObject result2 = TypeConverter.convertToType(context, this, runtime.getInteger(), sites.to_int_checked, true);
        if (!(result2 instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#to_int should return Integer");
        }
        return (RubyInteger)result2;
    }

    @Override
    public RubyInteger convertToInteger(String convertMethod) {
        IRubyObject result2;
        if (convertMethod.equals("to_int")) {
            return this.convertToInteger();
        }
        if (convertMethod.equals("to_i")) {
            Ruby runtime = this.getRuntime();
            ThreadContext context = runtime.getCurrentContext();
            JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
            result2 = TypeConverter.convertToType(context, this, runtime.getInteger(), sites.to_i_checked, true);
        } else {
            result2 = TypeConverter.convertToType((IRubyObject)this, this.getRuntime().getInteger(), convertMethod, true);
        }
        if (!(result2 instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(this.getMetaClass().getName() + "#to_int should return Integer");
        }
        return (RubyInteger)result2;
    }

    @Override
    public RubyString convertToString() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return (RubyString)TypeConverter.convertToType(context, this, this.getRuntime().getString(), sites.to_str_checked);
    }

    @Override
    public IRubyObject anyToString() {
        String cname = this.getMetaClass().getRealClass().getName();
        String hex2 = Integer.toHexString(System.identityHashCode(this));
        RubyString str = RubyString.newString(this.getRuntime(), new StringBuilder(2 + cname.length() + 3 + hex2.length() + 1).append("#<").append(cname).append(":0x").append(hex2).append('>'));
        str.setTaint(this.isTaint());
        return str;
    }

    @Override
    public IRubyObject checkStringType() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return TypeConverter.checkStringType(context, sites.to_str_checked, this);
    }

    @Override
    public IRubyObject checkStringType19() {
        return this.checkStringType();
    }

    @Override
    public IRubyObject checkArrayType() {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
        return TypeConverter.checkArrayType(context, sites.to_ary_checked, this);
    }

    @Override
    public Object toJava(Class target) {
        return this.defaultToJava(target);
    }

    final <T> T defaultToJava(Class<T> target) {
        if (target == Void.TYPE) {
            return null;
        }
        Object innerWrapper = this.dataGetStruct();
        if (innerWrapper instanceof JavaObject) {
            Object value2 = ((JavaObject)innerWrapper).getValue();
            if (target.isAssignableFrom(value2.getClass())) {
                this.getRuntime().getJavaSupport().getObjectProxyCache().put(value2, this);
                return (T)value2;
            }
        } else if (JavaUtil.isDuckTypeConvertable(this.getClass(), target)) {
            if (!this.respondsTo("java_object")) {
                return JavaUtil.convertProcToInterface(this.getRuntime().getCurrentContext(), this, target);
            }
        } else if (target.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw this.getRuntime().newTypeError("cannot convert instance of " + this.getClass() + " to " + target);
    }

    @Override
    public IRubyObject dup() {
        Ruby runtime = this.getRuntime();
        if (this.isImmediate()) {
            throw runtime.newTypeError("can't dup " + this.getMetaClass().getName());
        }
        IRubyObject dup2 = this.getMetaClass().getRealClass().allocate();
        if (this.isTaint()) {
            dup2.setTaint(true);
        }
        RubyBasicObject.initCopy(runtime.getCurrentContext(), dup2, this, false);
        return dup2;
    }

    private static IRubyObject initCopy(ThreadContext context, IRubyObject clone2, IRubyObject original, boolean doClone) {
        assert (!clone2.isFrozen()) : "frozen object (" + clone2.getMetaClass().getName() + ") allocated";
        original.copySpecialInstanceVariables(clone2);
        if (original.hasVariables()) {
            clone2.syncVariables(original);
        }
        if (original instanceof RubyModule) {
            RubyModule cloneMod = (RubyModule)clone2;
            cloneMod.syncConstants((RubyModule)original);
            cloneMod.syncClassVariables((RubyModule)original);
        }
        return doClone ? RubyBasicObject.sites((ThreadContext)context).initialize_clone.call(context, clone2, clone2, original) : RubyBasicObject.sites((ThreadContext)context).initialize_dup.call(context, clone2, clone2, original);
    }

    protected static boolean OBJ_INIT_COPY(IRubyObject obj, IRubyObject orig) {
        if (obj == orig) {
            return false;
        }
        RubyBasicObject.objInitCopy(obj, orig);
        return true;
    }

    protected static void objInitCopy(IRubyObject obj, IRubyObject orig) {
        if (obj == orig) {
            return;
        }
        ((RubyBasicObject)obj).checkFrozen();
        if (obj.getClass() != orig.getClass() || obj.getMetaClass().getRealClass() != orig.getMetaClass().getRealClass()) {
            throw obj.getRuntime().newTypeError("initialize_copy should take same class object");
        }
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
    }

    static RubyString inspect(ThreadContext context, IRubyObject object) {
        return RubyString.objAsString(context, Helpers.invokedynamic(context, object, MethodNames.INSPECT));
    }

    @Override
    public IRubyObject rbClone() {
        Ruby runtime = this.getRuntime();
        if (this.isImmediate()) {
            throw runtime.newTypeError("can't clone " + this.getMetaClass().getName());
        }
        RubyBasicObject clone2 = (RubyBasicObject)this.getMetaClass().getRealClass().allocate();
        clone2.setMetaClass(this.getSingletonClassClone());
        if (this.isTaint()) {
            clone2.setTaint(true);
        }
        RubyBasicObject.initCopy(runtime.getCurrentContext(), clone2, this, true);
        if (this.isFrozen()) {
            clone2.setFrozen(true);
        }
        return clone2;
    }

    protected RubyClass getSingletonClassClone() {
        RubyClass klass = this.getMetaClass();
        if (!klass.isSingleton()) {
            return klass;
        }
        MetaClass clone2 = new MetaClass(this.getRuntime(), klass.getSuperClass(), ((MetaClass)klass).getAttached());
        clone2.flags = this.flags;
        if (this instanceof RubyClass) {
            clone2.setMetaClass(clone2);
        } else {
            clone2.setMetaClass(klass.getSingletonClassClone());
        }
        if (klass.hasVariables()) {
            clone2.syncVariables(klass);
        }
        clone2.syncConstants(klass);
        klass.cloneMethods(clone2);
        ((MetaClass)clone2.getMetaClass()).setAttached(clone2);
        return clone2;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public synchronized void dataWrapStruct(Object obj) {
        if (obj == null) {
            this.removeInternalVariable("__wrap_struct__");
        } else {
            this.fastSetInternalVariable("__wrap_struct__", obj);
        }
    }

    @Override
    public synchronized Object dataGetStruct() {
        return this.getInternalVariable("__wrap_struct__");
    }

    @Override
    public synchronized Object dataGetStructChecked() {
        TypeConverter.checkData(this);
        return this.getInternalVariable("__wrap_struct__");
    }

    @Override
    @JRubyMethod(name={"__id__"})
    public IRubyObject id() {
        return this.getRuntime().newFixnum(this.getObjectId());
    }

    protected long getObjectId() {
        return this.metaClass.getRealClass().getVariableTableManager().getObjectId(this);
    }

    @Override
    public IRubyObject inspect() {
        if (!this.isImmediate() && !(this instanceof RubyModule) && this.hasVariables()) {
            return this.hashyInspect();
        }
        if (this.isNil()) {
            return RubyNil.inspect(this.getRuntime());
        }
        return this.to_s();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRubyObject hashyInspect() {
        Ruby runtime = this.getRuntime();
        String cname = this.getMetaClass().getRealClass().getName();
        StringBuilder part = new StringBuilder(2 + cname.length() + 3 + 8 + 1);
        part.append("#<").append(cname).append(":0x");
        part.append(Integer.toHexString(this.inspectHashCode()));
        if (runtime.isInspecting(this)) {
            part.append(" ...>");
            return RubyString.newString(runtime, part);
        }
        try {
            runtime.registerInspecting(this);
            RubyString rubyString = RubyString.newString(runtime, this.inspectObj(runtime, part));
            return rubyString;
        }
        finally {
            runtime.unregisterInspecting(this);
        }
    }

    public static IRubyObject rbInspect(ThreadContext context, IRubyObject obj) {
        Ruby runtime = context.runtime;
        RubyString str = RubyBasicObject.sites((ThreadContext)context).inspect.call(context, obj, obj).asString();
        Encoding enc = runtime.getDefaultInternalEncoding();
        if (enc == null) {
            enc = runtime.getDefaultExternalEncoding();
        }
        if (!enc.isAsciiCompatible()) {
            if (!str.isAsciiOnly()) {
                return RubyString.rbStrEscape(context, str);
            }
            return str;
        }
        if (str.getEncoding() != enc && !str.isAsciiOnly()) {
            return RubyString.rbStrEscape(context, str);
        }
        return str;
    }

    protected int inspectHashCode() {
        return System.identityHashCode(this);
    }

    private StringBuilder inspectObj(Ruby runtime, StringBuilder part) {
        ThreadContext context = runtime.getCurrentContext();
        String sep = "";
        for (Map.Entry<String, VariableAccessor> entry : this.metaClass.getVariableTableManager().getVariableAccessorsForRead().entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(entry.getKey())) continue;
            IRubyObject obj = (IRubyObject)value2;
            part.append(sep).append(' ').append(entry.getKey()).append('=');
            part.append(RubyBasicObject.sites((ThreadContext)context).inspect.call(context, obj, obj));
            sep = ",";
        }
        part.append('>');
        return part;
    }

    @JRubyMethod(name={"!"})
    public IRubyObject op_not(ThreadContext context) {
        return context.runtime.newBoolean(!this.isTrue());
    }

    @JRubyMethod(name={"!="}, required=1)
    public IRubyObject op_not_equal(ThreadContext context, IRubyObject other) {
        return context.runtime.newBoolean(!Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.OP_EQUAL, other).isTrue());
    }

    @Override
    public int compareTo(IRubyObject other) {
        Ruby runtime = this.getRuntime();
        IRubyObject cmp2 = Helpers.invokedynamic(runtime.getCurrentContext(), (IRubyObject)this, MethodNames.OP_CMP, other);
        if (!cmp2.isNil()) {
            return (int)cmp2.convertToInteger().getLongValue();
        }
        return 0;
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return this == obj ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @Deprecated
    public IRubyObject op_equal_19(ThreadContext context, IRubyObject obj) {
        return this.op_equal(context, obj);
    }

    @Override
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    protected static boolean equalInternal(ThreadContext context, IRubyObject that, IRubyObject other) {
        return that == other || Helpers.invokedynamic(context, that, MethodNames.OP_EQUAL, other).isTrue();
    }

    @Override
    public boolean eql(IRubyObject other) {
        return Helpers.invokedynamic(this.getRuntime().getCurrentContext(), (IRubyObject)this, MethodNames.EQL, other).isTrue();
    }

    @Override
    public void addFinalizer(IRubyObject f) {
        Finalizer finalizer = (Finalizer)this.getInternalVariable("__finalizer__");
        if (finalizer == null) {
            long id2 = this.getObjectId();
            IRubyObject fixnumId = this.id();
            this.getRuntime().getObjectSpace().registerObjectId(id2, this);
            finalizer = new Finalizer(fixnumId);
            this.fastSetInternalVariable("__finalizer__", finalizer);
            this.getRuntime().addFinalizer(finalizer);
        }
        finalizer.addFinalizer(f);
    }

    @Override
    public void removeFinalizers() {
        Finalizer finalizer = (Finalizer)this.getInternalVariable("__finalizer__");
        if (finalizer != null) {
            finalizer.removeFinalizers();
            this.removeInternalVariable("__finalizer__");
            this.getRuntime().removeFinalizer(finalizer);
        }
    }

    @Override
    public Object getVariable(int index2) {
        return VariableAccessor.getVariable(this, index2);
    }

    @Override
    public void setVariable(int index2, Object value2) {
        this.ensureInstanceVariablesSettable();
        if (index2 < 0) {
            return;
        }
        this.metaClass.getVariableTableManager().setVariableInternal(this, index2, value2);
    }

    public final Object getFFIHandle() {
        return this.metaClass.getVariableTableManager().getFFIHandle(this);
    }

    public final void setFFIHandle(Object value2) {
        this.metaClass.getVariableTableManager().setFFIHandle(this, value2);
    }

    @Override
    public boolean hasVariables() {
        return this.metaClass.getVariableTableManager().hasVariables(this);
    }

    @Override
    public List<Variable<Object>> getVariableList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<Variable<Object>> list2 = new ArrayList<Variable<Object>>();
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null) continue;
            list2.add(new VariableEntry<Object>(entry.getKey(), value2));
        }
        return list2;
    }

    @Override
    public List<String> getVariableNameList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<String> list2 = new ArrayList<String>();
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            Object value2 = entry.getValue().get(this);
            if (value2 == null) continue;
            list2.add(entry.getKey());
        }
        return list2;
    }

    protected boolean variableTableContains(String name2) {
        return this.metaClass.getVariableAccessorForRead(name2).get(this) != null;
    }

    protected Object variableTableFetch(String name2) {
        return this.metaClass.getVariableAccessorForRead(name2).get(this);
    }

    protected Object variableTableStore(String name2, Object value2) {
        this.metaClass.getVariableAccessorForWrite(name2).set(this, value2);
        return value2;
    }

    protected Object variableTableRemove(String name2) {
        return this.metaClass.getVariableTableManager().clearVariable(this, name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void variableTableSync(List<Variable<Object>> vars) {
        RubyBasicObject rubyBasicObject = this;
        synchronized (rubyBasicObject) {
            for (Variable<Object> var : vars) {
                this.variableTableStore(var.getName(), var.getValue());
            }
        }
    }

    @Override
    public InternalVariables getInternalVariables() {
        return this;
    }

    @Override
    public boolean hasInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableContains(name2);
    }

    @Override
    public Object getInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableFetch(name2);
    }

    @Override
    public void setInternalVariable(String name2, Object value2) {
        assert (!IdUtil.isRubyVariable(name2));
        this.variableTableStore(name2, value2);
    }

    @Override
    public Object removeInternalVariable(String name2) {
        assert (!IdUtil.isRubyVariable(name2));
        return this.variableTableRemove(name2);
    }

    @Override
    public void syncVariables(IRubyObject other) {
        this.metaClass.getVariableTableManager().syncVariables(this, other);
    }

    @Override
    public InstanceVariables getInstanceVariables() {
        return this;
    }

    @Override
    public boolean hasInstanceVariable(String name2) {
        return this.variableTableContains(name2);
    }

    @Override
    public IRubyObject getInstanceVariable(String name2) {
        return (IRubyObject)this.variableTableFetch(name2);
    }

    @Override
    public IRubyObject setInstanceVariable(String name2, IRubyObject value2) {
        assert (value2 != null);
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableStore(name2, value2);
    }

    @Override
    public IRubyObject removeInstanceVariable(String name2) {
        this.ensureInstanceVariablesSettable();
        return (IRubyObject)this.variableTableRemove(name2);
    }

    @Override
    public List<Variable<IRubyObject>> getInstanceVariableList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<Variable<IRubyObject>> list2 = new ArrayList<Variable<IRubyObject>>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            String key2 = entry.getKey();
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(key2)) continue;
            list2.add(new VariableEntry<IRubyObject>(key2, (IRubyObject)value2));
        }
        return list2;
    }

    @Override
    public List<String> getInstanceVariableNameList() {
        Map<String, VariableAccessor> ivarAccessors = this.metaClass.getVariableAccessorsForRead();
        ArrayList<String> list2 = new ArrayList<String>(ivarAccessors.size());
        for (Map.Entry<String, VariableAccessor> entry : ivarAccessors.entrySet()) {
            String key2 = entry.getKey();
            Object value2 = entry.getValue().get(this);
            if (!(value2 instanceof IRubyObject) || !IdUtil.isInstanceVariable(key2)) continue;
            list2.add(key2);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyInstanceVariablesInto(InstanceVariables other) {
        for (Variable<IRubyObject> var : this.getInstanceVariableList()) {
            RubyBasicObject rubyBasicObject = this;
            synchronized (rubyBasicObject) {
                other.setInstanceVariable(var.getName(), var.getValue());
            }
        }
    }

    public final void ensureInstanceVariablesSettable() {
        if (!this.isFrozen()) {
            return;
        }
        this.raiseFrozenError();
    }

    private void raiseFrozenError() throws RaiseException {
        if (this instanceof RubyModule) {
            throw this.getRuntime().newFrozenError("class/module ");
        }
        throw this.getRuntime().newFrozenError(this.getMetaClass().toString());
    }

    @Override
    @Deprecated
    public final int getNativeTypeIndex() {
        return this.getNativeClassIndex().ordinal();
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.BASICOBJECT;
    }

    public boolean isBuiltin(String methodName) {
        return this.getMetaClass().isMethodBuiltin(methodName);
    }

    @JRubyMethod(name={"singleton_method_added"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_added19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"singleton_method_removed"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_removed19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"singleton_method_undefined"}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject singleton_method_undefined19(ThreadContext context, IRubyObject recv2, IRubyObject symbolId, Block block) {
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"method_missing"}, rest=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject method_missing19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Visibility lastVis = context.getLastVisibility();
        CallType lastCallType = context.getLastCallType();
        if (args2.length == 0 || !(args2[0] instanceof RubySymbol)) {
            throw context.runtime.newArgumentError("no id given");
        }
        return RubyKernel.methodMissingDirect(context, recv2, (RubySymbol)args2[0], lastVis, lastCallType, args2);
    }

    @JRubyMethod(name={"__send__"}, omit=true)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, Block block) {
        String name2 = RubySymbol.objectToSymbolString(arg0);
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, block);
    }

    @JRubyMethod(name={"__send__"}, omit=true)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        String name2 = RubySymbol.objectToSymbolString(arg0);
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, block);
    }

    @JRubyMethod(name={"__send__"}, omit=true)
    public IRubyObject send19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        String name2 = RubySymbol.objectToSymbolString(arg0);
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, arg1, arg2, block);
    }

    @JRubyMethod(name={"__send__"}, required=1, rest=true, omit=true)
    public IRubyObject send19(ThreadContext context, IRubyObject[] args2, Block block) {
        String name2 = RubySymbol.objectToSymbolString(args2[0]);
        int length2 = args2.length - 1;
        args2 = length2 == 0 ? IRubyObject.NULL_ARRAY : ArraySupport.newCopy(args2, 1, length2);
        return this.getMetaClass().finvoke(context, (IRubyObject)this, name2, args2, block);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval19(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_eval19(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block, EvalType.INSTANCE_EVAL);
    }

    @JRubyMethod(name={"instance_exec"}, optional=3, rest=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.JUMPTARGET, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject instance_exec19(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newLocalJumpErrorNoBlock();
        }
        RubyClass klazz = this.isImmediate() ? context.runtime.getDummy() : this.getSingletonClass();
        return this.yieldUnder(context, klazz, args2, block, EvalType.INSTANCE_EVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject yieldUnder(ThreadContext context, RubyModule under, IRubyObject[] args2, Block block, EvalType evalType) {
        context.preExecuteUnder(this, under, block);
        IRubyObject savedBindingSelf = block.getBinding().getSelf();
        IRubyObject savedFrameSelf = block.getBinding().getFrame().getSelf();
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            if (args2.length == 1) {
                IRubyObject valueInYield = args2[0];
                IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldNonArray(context, valueInYield, this);
                return iRubyObject;
            }
            RubyArray valueInYield = RubyArray.newArrayMayCopy(context.runtime, args2);
            IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldArray(context, valueInYield, this);
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            block.getBinding().setSelf(savedBindingSelf);
            block.getBinding().getFrame().setSelf(savedFrameSelf);
            context.postExecuteUnder();
        }
    }

    private Block setupBlock(Block block, EvalType evalType) {
        return block.cloneBlockForEval(this, evalType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject yieldUnder(ThreadContext context, RubyModule under, Block block, EvalType evalType) {
        context.preExecuteUnder(this, under, block);
        IRubyObject savedBindingSelf = block.getBinding().getSelf();
        IRubyObject savedFrameSelf = block.getBinding().getFrame().getSelf();
        Visibility savedVisibility = block.getBinding().getVisibility();
        block.getBinding().setVisibility(Visibility.PUBLIC);
        try {
            IRubyObject iRubyObject = this.setupBlock(block, evalType).yieldNonArray(context, this, this);
            return iRubyObject;
        }
        finally {
            block.getBinding().setVisibility(savedVisibility);
            block.getBinding().setSelf(savedBindingSelf);
            block.getBinding().getFrame().setSelf(savedFrameSelf);
            context.postExecuteUnder();
        }
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, Block block, EvalType evalType) {
        if (block.isGiven()) {
            return this.yieldUnder(context, mod, block, evalType);
        }
        throw context.runtime.newArgumentError("block not supplied");
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg2, Block block, EvalType evalType) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(1, 0);
        }
        RubyString evalStr = arg2 instanceof RubyString ? (RubyString)arg2 : arg2.convertToString();
        String file2 = "(eval)";
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, Block block, EvalType evalType) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = 0;
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    public IRubyObject specificEval(ThreadContext context, RubyModule mod, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block, EvalType evalType) {
        if (block.isGiven()) {
            throw context.runtime.newArgumentError(2, 0);
        }
        RubyString evalStr = arg0 instanceof RubyString ? (RubyString)arg0 : arg0.convertToString();
        String file2 = arg1.convertToString().asJavaString();
        int line = (int)(arg2.convertToInteger().getLongValue() - 1L);
        return this.evalUnder(context, mod, evalStr, file2, line, evalType);
    }

    protected RubyModule getInstanceEvalClass() {
        if (this.isImmediate()) {
            return this.getRuntime().getDummy();
        }
        return this.getSingletonClass();
    }

    public IRubyObject evalUnder(ThreadContext context, RubyModule under, RubyString src, String file2, int line, EvalType evalType) {
        return Interpreter.evalSimple(context, under, this, src, file2, line, evalType);
    }

    @JRubyMethod(name={"equal?"}, required=1)
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        return this == other ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @Deprecated
    public IRubyObject equal_p19(ThreadContext context, IRubyObject other) {
        return this.equal_p(context, other);
    }

    public IRubyObject eql_p(IRubyObject obj) {
        return this == obj ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (this == other || Helpers.invokedynamic(context, (IRubyObject)this, MethodNames.OP_EQUAL, other).isTrue()) {
            return RubyFixnum.zero(context.runtime);
        }
        return context.nil;
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != original.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("initialize_copy should take same class object");
        }
        return this;
    }

    public void checkFrozen() {
        this.testFrozen();
    }

    public final RubyBoolean respond_to_p(IRubyObject mname) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, true));
    }

    public final RubyBoolean respond_to_p19(IRubyObject mname) {
        return this.respond_to_p19(mname, false);
    }

    public final RubyBoolean respond_to_p(IRubyObject mname, IRubyObject includePrivate) {
        String name2 = mname.asJavaString();
        return this.getRuntime().newBoolean(this.getMetaClass().isMethodBound(name2, !includePrivate.isTrue()));
    }

    public final RubyBoolean respond_to_p19(IRubyObject mname, IRubyObject includePrivate) {
        return this.respond_to_p19(mname, includePrivate.isTrue());
    }

    private RubyBoolean respond_to_p19(IRubyObject mname, boolean includePrivate) {
        Ruby runtime = this.getRuntime();
        String name2 = mname.asJavaString();
        if (this.getMetaClass().isMethodBound(name2, !includePrivate, true)) {
            return runtime.getTrue();
        }
        if (!(mname instanceof RubySymbol)) {
            mname = runtime.newSymbol(name2);
        }
        ThreadContext context = runtime.getCurrentContext();
        IRubyObject respond = RubyBasicObject.sites((ThreadContext)context).respond_to_missing.call(context, (IRubyObject)this, (IRubyObject)this, mname, (IRubyObject)runtime.newBoolean(includePrivate));
        return runtime.newBoolean(respond.isTrue());
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(super.hashCode());
    }

    public RubyClass type() {
        return this.getMetaClass().getRealClass();
    }

    public RubyClass type_deprecated() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "Object#type is deprecated; use Object#class");
        return this.type();
    }

    public IRubyObject display(ThreadContext context, IRubyObject[] args2) {
        IRubyObject port = args2.length == 0 ? context.runtime.getGlobalVariables().get("$>") : args2[0];
        port.callMethod(context, "write", this);
        return context.runtime.getNil();
    }

    public RubyBoolean tainted_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isTaint());
    }

    public IRubyObject taint(ThreadContext context) {
        this.taint(context.runtime);
        return this;
    }

    public IRubyObject untaint(ThreadContext context) {
        if (this.isTaint()) {
            this.testFrozen();
            this.setTaint(false);
        }
        return this;
    }

    public IRubyObject freeze(ThreadContext context) {
        Ruby runtime = context.runtime;
        if ((this.flags & FROZEN_F) == 0) {
            this.flags |= FROZEN_F;
        }
        return this;
    }

    public RubyBoolean frozen_p(ThreadContext context) {
        return context.runtime.newBoolean(this.isFrozen());
    }

    public RubyBoolean instance_of_p(ThreadContext context, IRubyObject type2) {
        if (this.type() == type2) {
            return context.runtime.getTrue();
        }
        if (!(type2 instanceof RubyModule)) {
            throw context.runtime.newTypeError("class or module required");
        }
        return context.runtime.getFalse();
    }

    public RubyBoolean kind_of_p(ThreadContext context, IRubyObject type2) {
        if (!(type2 instanceof RubyModule)) {
            throw context.runtime.newTypeError("class or module required");
        }
        return context.runtime.newBoolean(((RubyModule)type2).isInstance(this));
    }

    public IRubyObject methods(ThreadContext context, IRubyObject[] args2) {
        return this.methods(context, args2, false);
    }

    public IRubyObject methods19(ThreadContext context, IRubyObject[] args2) {
        return this.methods(context, args2, true);
    }

    public IRubyObject methods(ThreadContext context, IRubyObject[] args2, boolean useSymbols) {
        boolean all = args2.length == 1 ? args2[0].isTrue() : true;
        Ruby runtime = this.getRuntime();
        RubyArray methods2 = runtime.newArray();
        HashSet<String> seen = new HashSet<String>();
        if (this.getMetaClass().isSingleton()) {
            this.getMetaClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, false, true, false);
            if (all) {
                this.getMetaClass().getSuperClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, false, true, true);
            }
        } else if (all) {
            this.getMetaClass().populateInstanceMethodNames(seen, methods2, Visibility.PRIVATE, false, true, true);
        }
        return methods2;
    }

    public IRubyObject public_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PUBLIC, true, false);
    }

    public IRubyObject public_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PUBLIC, true, false);
    }

    public IRubyObject protected_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PROTECTED, true, false);
    }

    public IRubyObject protected_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PROTECTED, true, false);
    }

    public IRubyObject private_methods(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PRIVATE, true, false);
    }

    public IRubyObject private_methods19(ThreadContext context, IRubyObject[] args2) {
        return this.getMetaClass().instanceMethods(args2, Visibility.PRIVATE, true, false);
    }

    public RubyArray singleton_methods(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        boolean all = true;
        if (args2.length == 1) {
            all = args2[0].isTrue();
        }
        RubyClass klass = this.metaClass;
        RubyModule origin = klass.getMethodLocation();
        if (klass.isSingleton()) {
            HashSet<RubySymbol> names2 = new HashSet<RubySymbol>();
            for (Map.Entry<String, DynamicMethod> entry : klass.getMethods().entrySet()) {
                if (entry.getValue().getVisibility() == Visibility.PRIVATE) continue;
                names2.add(runtime.newSymbol(entry.getKey()));
            }
            if (all) {
                for (klass = klass.getSuperClass(); klass != null && (klass.isSingleton() || klass.isIncluded()); klass = klass.getSuperClass()) {
                    if (klass == origin) continue;
                    for (Map.Entry<String, DynamicMethod> entry : klass.getMethods().entrySet()) {
                        if (entry.getValue().getVisibility() == Visibility.PRIVATE) continue;
                        names2.add(runtime.newSymbol(entry.getKey()));
                    }
                }
            }
            return RubyArray.newArray(runtime, names2);
        }
        return context.runtime.newEmptyArray();
    }

    public IRubyObject method(IRubyObject name2) {
        return this.getMetaClass().newMethod(this, name2.asJavaString(), true, null);
    }

    public IRubyObject method19(IRubyObject name2) {
        RubySymbol symbol = TypeConverter.checkID(name2);
        return this.getMetaClass().newMethod(this, symbol.asJavaString(), true, null, true);
    }

    public IRubyObject to_s() {
        return this.anyToString();
    }

    public RubyArray to_a() {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "default 'to_a' will be obsolete");
        return this.getRuntime().newArray((IRubyObject)this);
    }

    public IRubyObject instance_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), block, EvalType.INSTANCE_EVAL);
    }

    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, block, EvalType.INSTANCE_EVAL);
    }

    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, block, EvalType.INSTANCE_EVAL);
    }

    public IRubyObject instance_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this.getInstanceEvalClass(), arg0, arg1, arg2, block, EvalType.INSTANCE_EVAL);
    }

    public IRubyObject instance_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("block not supplied");
        }
        RubyClass klazz = this.isImmediate() ? context.runtime.getDummy() : this.getSingletonClass();
        return this.yieldUnder(context, klazz, args2, block, EvalType.INSTANCE_EVAL);
    }

    public IRubyObject extend(IRubyObject[] args2) {
        Ruby runtime = this.getRuntime();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            if (args2[i2].isModule()) continue;
            throw runtime.newTypeError(args2[i2], runtime.getModule());
        }
        ThreadContext context = runtime.getCurrentContext();
        for (int i3 = args2.length - 1; i3 >= 0; --i3) {
            args2[i3].callMethod(context, "extend_object", this);
            args2[i3].callMethod(context, "extended", this);
        }
        return this;
    }

    public IRubyObject send(ThreadContext context, Block block) {
        throw context.runtime.newArgumentError(0, 1);
    }

    public IRubyObject send(ThreadContext context, IRubyObject arg0, Block block) {
        return this.send19(context, arg0, block);
    }

    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.send19(context, arg0, arg1, block);
    }

    public IRubyObject send(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.send19(context, arg0, arg1, arg2, block);
    }

    public IRubyObject send(ThreadContext context, IRubyObject[] args2, Block block) {
        if (args2.length == 0) {
            return this.send(context, block);
        }
        return this.send19(context, args2, block);
    }

    public IRubyObject nil_p(ThreadContext context) {
        return context.runtime.getFalse();
    }

    public IRubyObject op_match(ThreadContext context, IRubyObject arg2) {
        return context.runtime.getFalse();
    }

    public IRubyObject op_match19(ThreadContext context, IRubyObject arg2) {
        return context.runtime.getNil();
    }

    public IRubyObject op_not_match(ThreadContext context, IRubyObject arg2) {
        return context.runtime.newBoolean(!RubyBasicObject.sites((ThreadContext)context).match.call(context, (IRubyObject)this, (IRubyObject)this, arg2).isTrue());
    }

    public IRubyObject instance_variable_defined_p(ThreadContext context, IRubyObject name2) {
        if (this.variableTableContains(this.validateInstanceVariable(name2, name2.asJavaString()))) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    public IRubyObject instance_variable_get(ThreadContext context, IRubyObject name2) {
        Object value2 = this.variableTableFetch(this.validateInstanceVariable(name2, name2.asJavaString()));
        if (value2 != null) {
            return (IRubyObject)value2;
        }
        return context.runtime.getNil();
    }

    public IRubyObject instance_variable_set(IRubyObject name2, IRubyObject value2) {
        return (IRubyObject)this.variableTableStore(this.validateInstanceVariable(name2, name2.asJavaString()), value2);
    }

    public IRubyObject remove_instance_variable(ThreadContext context, IRubyObject name2, Block block) {
        this.ensureInstanceVariablesSettable();
        IRubyObject value2 = (IRubyObject)this.variableTableRemove(this.validateInstanceVariable(name2, name2.asJavaString()));
        if (value2 != null) {
            return value2;
        }
        throw context.runtime.newNameError("instance variable %1$s not defined", (IRubyObject)this, name2);
    }

    public RubyArray instance_variables(ThreadContext context) {
        Ruby runtime = context.runtime;
        List<String> nameList = this.getInstanceVariableNameList();
        int size2 = nameList.size();
        RubyArray array = runtime.newArray(nameList.size());
        for (int i2 = 0; i2 < size2; ++i2) {
            String name2 = nameList.get(i2);
            array.store(i2, runtime.newString(name2));
        }
        return array;
    }

    public RubyArray instance_variables19(ThreadContext context) {
        Ruby runtime = context.runtime;
        List<String> nameList = this.getInstanceVariableNameList();
        int size2 = nameList.size();
        RubyArray array = RubyArray.newBlankArray(runtime, nameList.size());
        for (int i2 = 0; i2 < size2; ++i2) {
            String name2 = nameList.get(i2);
            array.store(i2, runtime.newSymbol(name2));
        }
        return array;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IRubyObject) {
            Ruby runtime = this.getRuntime();
            ThreadContext context = runtime.getCurrentContext();
            JavaSites.BasicObjectSites sites = RubyBasicObject.sites(context);
            IRubyObject equals = Helpers.invokeChecked(context, (IRubyObject)this, sites.equals_checked, (IRubyObject)other);
            if (equals == null) {
                return false;
            }
            return equals.isTrue();
        }
        return false;
    }

    public int hashCode() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        IRubyObject hashValue = Helpers.invokeChecked(context, (IRubyObject)this, RubyBasicObject.sites((ThreadContext)context).hash_checked);
        if (hashValue == null) {
            return super.hashCode();
        }
        if (hashValue instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hashValue);
        }
        return RubyBasicObject.nonFixnumHashCode(hashValue);
    }

    protected static int nonFixnumHashCode(IRubyObject hashValue) {
        RubyInteger integer = hashValue.convertToInteger();
        if (integer instanceof RubyBignum) {
            return integer.getBigIntegerValue().intValue();
        }
        return (int)integer.getLongValue();
    }

    protected String validateInstanceVariable(String name2) {
        if (IdUtil.isValidInstanceVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`%1$s' is not allowable as an instance variable name", (IRubyObject)this, name2);
    }

    protected String validateInstanceVariable(IRubyObject nameObj, String name2) {
        if (IdUtil.isValidInstanceVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`%1$s' is not allowable as an instance variable name", (IRubyObject)this, nameObj);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.metaClass.isSingleton()) {
            throw new IOException("can not serialize singleton object");
        }
        oos.defaultWriteObject();
        oos.writeUTF(this.metaClass.getName());
        this.metaClass.getVariableTableManager().serializeVariables(this, oos);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Ruby ruby2 = Ruby.getThreadLocalRuntime();
        if (ruby2 == null) {
            throw new IOException("No thread-local org.jruby.Ruby available; can't deserialize Ruby object. Set with Ruby#setThreadLocalRuntime.");
        }
        ois.defaultReadObject();
        this.metaClass = (RubyClass)ruby2.getClassFromPath(ois.readUTF());
        this.metaClass.getVariableTableManager().deserializeVariables(this, ois);
    }

    private static JavaSites.BasicObjectSites sites(ThreadContext context) {
        return context.sites.BasicObject;
    }

    @Deprecated
    public IRubyObject initialize() {
        return this.getRuntime().getNil();
    }

    @Deprecated
    protected RubyBasicObject(Ruby runtime, RubyClass metaClass, boolean useObjectSpace, boolean canBeTainted) {
        this(runtime, metaClass, useObjectSpace);
    }

    @Override
    @Deprecated
    public IRubyObject callSuper(ThreadContext context, IRubyObject[] args2, Block block) {
        return Helpers.invokeSuper(context, (IRubyObject)this, args2, block);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2) {
        return Helpers.invoke(context, this, name2);
    }

    @Override
    @Deprecated
    public final IRubyObject callMethod(ThreadContext context, int methodIndex, String name2, IRubyObject arg2) {
        return Helpers.invoke(context, (IRubyObject)this, name2, arg2, Block.NULL_BLOCK);
    }

    @Override
    @Deprecated
    public RubyInteger convertToInteger(int methodIndex, String convertMethod) {
        return this.convertToInteger(convertMethod);
    }

    @Override
    @Deprecated
    public int getVariableCount() {
        return this.getMetaClass().getVariableTableSize();
    }

    @Deprecated
    protected boolean variableTableFastContains(String internedName) {
        return this.variableTableContains(internedName);
    }

    @Deprecated
    protected Object variableTableFastFetch(String internedName) {
        return this.variableTableFetch(internedName);
    }

    @Deprecated
    protected Object variableTableFastStore(String internedName, Object value2) {
        return this.variableTableStore(internedName, value2);
    }

    @Override
    @Deprecated
    public boolean fastHasInternalVariable(String internedName) {
        return this.hasInternalVariable(internedName);
    }

    @Override
    @Deprecated
    public Object fastGetInternalVariable(String internedName) {
        return this.getInternalVariable(internedName);
    }

    @Override
    @Deprecated
    public void fastSetInternalVariable(String internedName, Object value2) {
        this.setInternalVariable(internedName, value2);
    }

    @Override
    @Deprecated
    public void syncVariables(List<Variable<Object>> variables) {
        this.variableTableSync(variables);
    }

    @Override
    @Deprecated
    public boolean fastHasInstanceVariable(String internedName) {
        return this.hasInstanceVariable(internedName);
    }

    @Override
    @Deprecated
    public IRubyObject fastGetInstanceVariable(String internedName) {
        return this.getInstanceVariable(internedName);
    }

    @Override
    @Deprecated
    public IRubyObject fastSetInstanceVariable(String internedName, IRubyObject value2) {
        return this.setInstanceVariable(internedName, value2);
    }

    @Override
    @Deprecated
    public boolean isUntrusted() {
        return this.isTaint();
    }

    @Override
    @Deprecated
    public void setUntrusted(boolean untrusted) {
        this.setTaint(untrusted);
    }

    @Deprecated
    public RubyBoolean untrusted_p(ThreadContext context) {
        return this.tainted_p(context);
    }

    @Deprecated
    public IRubyObject untrust(ThreadContext context) {
        return this.taint(context);
    }

    @Deprecated
    public IRubyObject trust(ThreadContext context) {
        return this.untaint(context);
    }

    @Deprecated
    public final Object getNativeHandle() {
        return null;
    }

    @Deprecated
    public final void setNativeHandle(Object value2) {
    }

    public static class Finalizer
    implements Finalizable {
        private final IRubyObject id;
        private final AtomicBoolean finalized;
        private IRubyObject firstFinalizer;
        private List<IRubyObject> finalizers;

        public Finalizer(RubyFixnum id2) {
            this((IRubyObject)id2);
        }

        Finalizer(IRubyObject id2) {
            this.id = id2;
            this.finalized = new AtomicBoolean(false);
        }

        public void addFinalizer(IRubyObject finalizer) {
            if (this.firstFinalizer == null) {
                this.firstFinalizer = finalizer;
            } else {
                if (this.finalizers == null) {
                    this.finalizers = new ArrayList<IRubyObject>(4);
                }
                this.finalizers.add(finalizer);
            }
        }

        public void removeFinalizers() {
            this.firstFinalizer = null;
            this.finalizers = null;
        }

        @Override
        public void finalize() {
            if (this.finalized.compareAndSet(false, true)) {
                if (this.firstFinalizer != null) {
                    this.callFinalizer(this.firstFinalizer);
                }
                if (this.finalizers != null) {
                    for (int i2 = 0; i2 < this.finalizers.size(); ++i2) {
                        this.callFinalizer(this.finalizers.get(i2));
                    }
                }
            }
        }

        private void callFinalizer(IRubyObject finalizer) {
            ThreadContext context = finalizer.getRuntime().getCurrentContext();
            RubyBasicObject.sites((ThreadContext)context).call.call(context, finalizer, finalizer, this.id);
        }
    }
}

