/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.Reader;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.jruby.RubyNil;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyEngine;
import org.jruby.embed.jsr223.Utils;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyCompiledScript
extends CompiledScript {
    private ScriptingContainer container;
    private JRubyEngine engine;
    private final EmbedEvalUnit unit;

    JRubyCompiledScript(ScriptingContainer container, JRubyEngine engine, String script) {
        this.container = container;
        this.engine = engine;
        Utils.preEval(container, engine.getContext());
        this.unit = container.parse(script, new int[0]);
    }

    JRubyCompiledScript(ScriptingContainer container, JRubyEngine engine, Reader reader) {
        this.container = container;
        this.engine = engine;
        String filename2 = System.getProperty("javax.script.filename");
        Utils.preEval(container, engine.getContext());
        this.unit = container.parse(reader, filename2, Utils.getLineNumber(engine.getContext()));
    }

    @Override
    public Object eval(Bindings bindings) throws ScriptException {
        if (bindings == null) {
            throw new NullPointerException("bindings is null");
        }
        ScriptContext context = this.engine.getScriptContext(bindings);
        return this.eval(context);
    }

    @Override
    public Object eval(ScriptContext context) throws ScriptException {
        try {
            if (Utils.isClearVariablesOn(context)) {
                this.container.clear();
            }
            Utils.preEval(this.container, context);
            IRubyObject ret = this.unit.run();
            if (!(ret instanceof RubyNil)) {
                Object object = JavaEmbedUtils.rubyToJava(ret);
                return object;
            }
            Object var3_5 = null;
            return var3_5;
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
        finally {
            Utils.postEval(this.container, context);
            boolean termination = Utils.isTerminationOn(context);
            if (termination) {
                this.container.terminate();
            }
        }
    }

    private ScriptException wrapException(Exception e) throws ScriptException {
        return new ScriptException(e);
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }
}

