/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRMetaClassBody
extends CompiledIRMethod {
    private final boolean pushNewDynScope;
    private final boolean popDynScope;

    public CompiledIRMetaClassBody(MethodHandle handle, IRScope scope, RubyModule implementationClass) {
        super(handle, scope, Visibility.PUBLIC, implementationClass, scope.receivesKeywordArgs());
        boolean reuseParentDynScope = scope.getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
        this.pushNewDynScope = !scope.getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED) && !reuseParentDynScope;
        this.popDynScope = this.pushNewDynScope || reuseParentDynScope;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return new ArgumentDescriptor[0];
    }

    @Override
    protected void post(ThreadContext context) {
        context.popFrame();
        if (this.popDynScope) {
            context.popScope();
        }
    }

    @Override
    protected void pre(ThreadContext context, StaticScope staticScope, RubyModule implementationClass, IRubyObject self2, String name2, Block block) {
        context.preMethodFrameOnly(implementationClass, name2, self2, block);
        if (this.pushNewDynScope) {
            context.pushScope(DynamicScope.newDynamicScope(staticScope, context.getCurrentScope()));
        }
        context.setCurrentVisibility(this.getVisibility());
    }
}

