/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.scope;

import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.TwoVarDynamicScope;

public class ThreeVarDynamicScope
extends TwoVarDynamicScope {
    private static final int SIZE = 3;
    private static final String SIZE_ERROR = "ThreeVarDynamicScope only supports scopes with three variables";
    private static final String GROW_ERROR = "ThreeVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueTwo;

    public ThreeVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public ThreeVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        this.growIfNeeded(3, GROW_ERROR);
    }

    @Override
    public DynamicScope cloneScope() {
        return new ThreeVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero, this.variableValueOne, this.variableValueTwo};
    }

    @Override
    public IRubyObject getValue(int offset2, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset2, depth - 1);
        }
        assert (offset2 < 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        switch (offset2) {
            case 0: {
                return this.variableValueZero;
            }
            case 1: {
                return this.variableValueOne;
            }
            case 2: {
                return this.variableValueTwo;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueOrNil(int offset2, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset2, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset2, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset2, IRubyObject nil) {
        assert (offset2 < 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        switch (offset2) {
            case 0: {
                if (this.variableValueZero == null) {
                    this.variableValueZero = nil;
                    return this.variableValueZero;
                }
                return this.variableValueZero;
            }
            case 1: {
                if (this.variableValueOne == null) {
                    this.variableValueOne = nil;
                    return this.variableValueOne;
                }
                return this.variableValueOne;
            }
            case 2: {
                if (this.variableValueTwo == null) {
                    this.variableValueTwo = nil;
                    return this.variableValueTwo;
                }
                return this.variableValueTwo;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject getValueTwoDepthZeroOrNil(IRubyObject nil) {
        if (this.variableValueTwo == null) {
            this.variableValueTwo = nil;
            return this.variableValueTwo;
        }
        return this.variableValueTwo;
    }

    @Override
    public IRubyObject setValue(int offset2, IRubyObject value2, int depth) {
        if (depth > 0) {
            assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
            return this.parent.setValue(offset2, value2, depth - 1);
        }
        assert (offset2 < 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value2;
                return this.variableValueTwo;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value2, int offset2) {
        assert (offset2 < 3) : "ThreeVarDynamicScope only supports scopes with three variables";
        switch (offset2) {
            case 0: {
                this.variableValueZero = value2;
                return this.variableValueZero;
            }
            case 1: {
                this.variableValueOne = value2;
                return this.variableValueOne;
            }
            case 2: {
                this.variableValueTwo = value2;
                return this.variableValueTwo;
            }
        }
        throw new RuntimeException(SIZE_ERROR);
    }

    @Override
    public IRubyObject setValueTwoDepthZero(IRubyObject value2) {
        this.variableValueTwo = value2;
        return this.variableValueTwo;
    }
}

