/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import java.util.ArrayList;

final class TextMap {
    private final int[] nlOffsets;
    private final int textLength;
    final boolean finalNL;

    TextMap(int[] nlOffsets, int textLength, boolean finalNL) {
        this.nlOffsets = nlOffsets;
        this.textLength = textLength;
        this.finalNL = finalNL;
    }

    public static TextMap fromString(String text) {
        int nlIndex;
        int textLength = text.length();
        ArrayList<Integer> lines = new ArrayList<Integer>();
        lines.add(0);
        int offset = 0;
        while (offset < text.length() && (nlIndex = text.indexOf(10, offset)) >= 0) {
            offset = nlIndex + 1;
            lines.add(offset);
        }
        lines.add(Integer.MAX_VALUE);
        int[] nlOffsets = new int[lines.size()];
        for (int line = 0; line < lines.size(); ++line) {
            nlOffsets[line] = (Integer)lines.get(line);
        }
        boolean finalNL = textLength > 0 && textLength == nlOffsets[nlOffsets.length - 2];
        return new TextMap(nlOffsets, textLength, finalNL);
    }

    public int offsetToLine(int offset) throws IllegalArgumentException {
        if (offset < 0 || offset >= this.textLength) {
            if (offset == 0 && this.textLength == 0) {
                return 1;
            }
            throw new IllegalArgumentException("offset out of bounds");
        }
        int line = 1;
        while (offset >= this.nlOffsets[line]) {
            ++line;
        }
        return line;
    }

    public int offsetToCol(int offset) throws IllegalArgumentException {
        return 1 + offset - this.nlOffsets[this.offsetToLine(offset) - 1];
    }

    public int length() {
        return this.textLength;
    }

    public int lineCount() {
        if (this.textLength == 0) {
            return 0;
        }
        return this.finalNL ? this.nlOffsets.length - 2 : this.nlOffsets.length - 1;
    }

    public int lineStartOffset(int line) throws IllegalArgumentException {
        if (this.textLength == 0) {
            return 0;
        }
        if (this.lineOutOfRange(line)) {
            throw new IllegalArgumentException("line out of bounds");
        }
        return this.nlOffsets[line - 1];
    }

    public int lineLength(int line) throws IllegalArgumentException {
        if (this.textLength == 0) {
            return 0;
        }
        if (this.lineOutOfRange(line)) {
            throw new IllegalArgumentException("line out of bounds");
        }
        if (line == this.nlOffsets.length - 1 && !this.finalNL) {
            return this.textLength - this.nlOffsets[line - 1];
        }
        return this.nlOffsets[line] - this.nlOffsets[line - 1] - 1;
    }

    private boolean lineOutOfRange(int line) {
        return line <= 0 || line >= this.nlOffsets.length || line == this.nlOffsets.length - 1 && this.finalNL;
    }
}

