/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import java.util.ArrayList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;

@CoreClass(value="Truffle::Coverage")
public abstract class CoverageNodes {

    @CoreMethod(names={"result_array"}, onSingleton=true)
    public static abstract class CoverageResultNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject resultArray() {
            ArrayList<DynamicObject> results = new ArrayList<DynamicObject>();
            Map<Source, long[]> counts = this.getContext().getCoverageManager().getCounts();
            if (counts == null) {
                throw new RaiseException(this.coreExceptions().runtimeErrorCoverageNotEnabled(this));
            }
            for (Map.Entry<Source, long[]> source : counts.entrySet()) {
                long[] countsArray = source.getValue();
                Object[] countsStore = new Object[countsArray.length];
                for (int n = 0; n < countsArray.length; ++n) {
                    Object countObject = countsArray[n] == -1L ? this.nil() : Long.valueOf(countsArray[n]);
                    countsStore[n] = countObject;
                }
                results.add(Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{this.createString(StringOperations.encodeRope(source.getKey().getName(), (Encoding)UTF8Encoding.INSTANCE)), Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), countsStore, countsStore.length)}, 2));
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), results.toArray(), results.size());
        }
    }

    @CoreMethod(names={"disable"}, onSingleton=true)
    public static abstract class CoverageDisableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject disable() {
            this.getContext().getCoverageManager().disable();
            return this.nil();
        }
    }

    @CoreMethod(names={"enable"}, onSingleton=true)
    public static abstract class CoverageEnableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject enable() {
            this.getContext().getCoverageManager().enable();
            return this.nil();
        }
    }
}

