/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.ContextEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.array.CustomWidthArray;
import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.map.AbstractNgramMap;
import edu.berkeley.nlp.lm.map.ContextEncodedNgramMap;
import edu.berkeley.nlp.lm.map.ExplicitWordHashMap;
import edu.berkeley.nlp.lm.map.HashMap;
import edu.berkeley.nlp.lm.map.ImplicitWordHashMap;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.map.UnigramHashMap;
import edu.berkeley.nlp.lm.util.Annotations;
import edu.berkeley.nlp.lm.util.Logger;
import edu.berkeley.nlp.lm.values.ValueContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class HashNgramMap<T>
extends AbstractNgramMap<T>
implements ContextEncodedNgramMap<T> {
    private static final long serialVersionUID = 1L;
    @Annotations.PrintMemoryCount
    private ExplicitWordHashMap[] explicitMaps;
    @Annotations.PrintMemoryCount
    private final ImplicitWordHashMap[] implicitMaps;
    @Annotations.PrintMemoryCount
    private final UnigramHashMap implicitUnigramMap;
    private long[] initCapacities;
    private final double maxLoadFactor;
    private final boolean isExplicit;
    private final boolean reversed;
    private final boolean storeSuffixOffsets;

    public static <T> HashNgramMap<T> createImplicitWordHashNgramMap(ValueContainer<T> values, ConfigOptions opts, LongArray[] numNgramsForEachWord, boolean reversed) {
        return new HashNgramMap<T>(values, opts, numNgramsForEachWord, reversed);
    }

    private HashNgramMap(ValueContainer<T> values, ConfigOptions opts, LongArray[] numNgramsForEachWord, boolean reversed) {
        super(values, opts);
        this.reversed = reversed;
        this.maxLoadFactor = opts.hashTableLoadFactor;
        this.storeSuffixOffsets = values.storeSuffixoffsets();
        int maxNgramOrder = numNgramsForEachWord.length;
        this.explicitMaps = null;
        this.isExplicit = false;
        this.implicitMaps = new ImplicitWordHashMap[maxNgramOrder - 1];
        long numWords = numNgramsForEachWord[0].size();
        this.implicitUnigramMap = new UnigramHashMap(numWords, this);
        this.initCapacities = null;
        long maxSize = this.getMaximumSize(numNgramsForEachWord);
        boolean fitsInInt = maxSize < Integer.MAX_VALUE;
        int logicalNumRangeEntries = (maxNgramOrder - 1) * (int)numWords;
        long[] wordRanges = new long[fitsInInt ? logicalNumRangeEntries / 2 + logicalNumRangeEntries % 2 : logicalNumRangeEntries];
        values.setMap(this);
        values.setSizeAtLeast(numWords, 0);
        for (int ngramOrder = 1; ngramOrder < maxNgramOrder; ++ngramOrder) {
            long numNgramsForPreviousOrder = ngramOrder == 1 ? numWords : this.implicitMaps[ngramOrder - 2].getCapacity();
            this.implicitMaps[ngramOrder - 1] = new ImplicitWordHashMap(numNgramsForEachWord[ngramOrder], wordRanges, ngramOrder, maxNgramOrder - 1, numNgramsForPreviousOrder, (int)numWords, this, fitsInInt, !opts.storeRankedProbBackoffs);
            values.setSizeAtLeast(this.implicitMaps[ngramOrder - 1].getCapacity(), ngramOrder);
        }
    }

    private long getMaximumSize(LongArray[] numNgramsForEachWord) {
        long max = Long.MIN_VALUE;
        for (int ngramOrder = 0; ngramOrder < numNgramsForEachWord.length; ++ngramOrder) {
            max = Math.max(max, this.getSizeOfOrder(numNgramsForEachWord[ngramOrder]));
        }
        return max;
    }

    private long getSizeOfOrder(LongArray numNgramsForEachWord) {
        long currStart = 0L;
        int w = 0;
        while ((long)w < numNgramsForEachWord.size()) {
            currStart += this.getRangeSizeForWord(numNgramsForEachWord, w);
            ++w;
        }
        return currStart;
    }

    long getRangeSizeForWord(LongArray numNgramsForEachWord, int w) {
        long numNgrams = numNgramsForEachWord.get(w);
        long rangeSize = numNgrams <= 3L ? numNgrams : Math.round((double)numNgrams * 1.0 / this.maxLoadFactor);
        return rangeSize;
    }

    public static <T> HashNgramMap<T> createExplicitWordHashNgramMap(ValueContainer<T> values, ConfigOptions opts, int maxNgramOrder, boolean reversed) {
        return new HashNgramMap<T>(values, opts, maxNgramOrder, reversed);
    }

    private HashNgramMap(ValueContainer<T> values, ConfigOptions opts, int maxNgramOrder, boolean reversed) {
        super(values, opts);
        this.reversed = reversed;
        this.storeSuffixOffsets = values.storeSuffixoffsets();
        this.maxLoadFactor = opts.hashTableLoadFactor;
        this.implicitMaps = null;
        this.implicitUnigramMap = null;
        this.isExplicit = true;
        this.explicitMaps = new ExplicitWordHashMap[maxNgramOrder];
        this.initCapacities = new long[maxNgramOrder];
        Arrays.fill(this.initCapacities, 100L);
        values.setMap(this);
    }

    private HashNgramMap(ValueContainer<T> values, ConfigOptions opts, long[] newCapacities, boolean reversed, ExplicitWordHashMap[] partialMaps) {
        super(values, opts);
        this.reversed = reversed;
        this.storeSuffixOffsets = values.storeSuffixoffsets();
        this.maxLoadFactor = opts.hashTableLoadFactor;
        this.implicitMaps = null;
        this.implicitUnigramMap = null;
        this.isExplicit = true;
        this.explicitMaps = Arrays.copyOf(partialMaps, newCapacities.length);
        this.initCapacities = newCapacities;
        values.setMap(this);
    }

    private ExplicitWordHashMap initMap(long newCapacity, int ngramOrder) {
        ExplicitWordHashMap newMap;
        this.explicitMaps[ngramOrder] = newMap = new ExplicitWordHashMap(newCapacity);
        this.values.setSizeAtLeast(this.explicitMaps[ngramOrder].getCapacity(), ngramOrder);
        return newMap;
    }

    @Override
    public long put(int[] ngram, int startPos, int endPos, T val) {
        return this.putHelp(ngram, startPos, endPos, val, false);
    }

    private long putHelp(int[] ngram, int startPos, int endPos, T val, boolean forcedNew) {
        long key;
        int ngramOrder = endPos - startPos - 1;
        HashMap map = this.getHashMapForOrder(ngramOrder);
        if (!forcedNew && map instanceof ExplicitWordHashMap && map.getLoadFactor() >= this.maxLoadFactor) {
            this.rehash(ngramOrder, map.getCapacity() * 3L / 2L, 1);
            map = this.getHashMapForOrder(ngramOrder);
        }
        if ((key = this.getKey(ngram, startPos, endPos)) < 0L) {
            return -1L;
        }
        return this.putHelp(map, ngram, startPos, endPos, key, val, forcedNew);
    }

    private HashMap getHashMapForOrder(int ngramOrder) {
        HashMap map = this.getMap(ngramOrder);
        if (map == null) {
            long newCapacity = this.initCapacities[ngramOrder];
            assert (newCapacity >= 0L) : "Bad capacity " + newCapacity + " for order " + ngramOrder;
            map = this.initMap(newCapacity, ngramOrder);
        }
        return map;
    }

    public long putWithOffset(int[] ngram, int startPos, int endPos, long contextOffset, T val) {
        int ngramOrder = endPos - startPos - 1;
        long key = this.combineToKey(ngram[endPos - 1], contextOffset);
        HashMap map = this.getHashMapForOrder(ngramOrder);
        return this.putHelp(map, ngram, startPos, endPos, key, val, false);
    }

    public long putWithOffsetAndSuffix(int[] ngram, int startPos, int endPos, long contextOffset, long suffixOffset, T val) {
        int ngramOrder = endPos - startPos - 1;
        long key = this.combineToKey(ngram[endPos - 1], contextOffset);
        HashMap map = this.getHashMapForOrder(ngramOrder);
        return this.putHelpWithSuffixIndex(map, ngram, startPos, endPos, key, val, false, suffixOffset);
    }

    public void rehashIfNecessary(int num) {
        if (this.explicitMaps == null) {
            return;
        }
        for (int ngramOrder = 0; ngramOrder < this.explicitMaps.length; ++ngramOrder) {
            if (this.explicitMaps[ngramOrder] == null || !(this.explicitMaps[ngramOrder].getLoadFactor(num) >= this.maxLoadFactor)) continue;
            this.rehash(ngramOrder, (this.explicitMaps[ngramOrder].getCapacity() + (long)num) * 3L / 2L, num);
            return;
        }
    }

    private long putHelp(HashMap map, int[] ngram, int startPos, int endPos, long key, T val, boolean forcedNew) {
        long suffixIndex = this.storeSuffixOffsets ? this.getSuffixOffset(ngram, startPos, endPos) : -1L;
        return this.putHelpWithSuffixIndex(map, ngram, startPos, endPos, key, val, forcedNew, suffixIndex);
    }

    private long putHelpWithSuffixIndex(HashMap map, int[] ngram, int startPos, int endPos, long key, T val, boolean forcedNew, long suffixIndex) {
        int ngramOrder = endPos - startPos - 1;
        long oldSize = map.size();
        long index = map.put(key);
        boolean addWorked = this.values.add(ngram, startPos, endPos, ngramOrder, index, this.contextOffsetOf(key), this.wordOf(key), val, suffixIndex, map.size() > oldSize || forcedNew);
        if (!addWorked) {
            return -1L;
        }
        return index;
    }

    @Override
    public long getValueAndOffset(long contextOffset, int contextOrder, int word, @Annotations.OutputParameter T outputVal) {
        return this.getOffsetForContextEncoding(contextOffset, contextOrder, word, outputVal);
    }

    @Override
    public long getOffset(long contextOffset, int contextOrder, int word) {
        return this.getOffsetForContextEncoding(contextOffset, contextOrder, word, null);
    }

    @Override
    public int[] getNgramFromContextEncoding(long contextOffset, int contextOrder, int word) {
        int[] ret = new int[Math.max(1, contextOrder + 2)];
        this.getNgramFromContextEncodingHelp(contextOffset, contextOrder, word, ret);
        return ret;
    }

    private void getNgramFromContextEncodingHelp(long contextOffset, int contextOrder, int word, int[] scratch) {
        if (contextOrder < 0) {
            scratch[0] = word;
        } else {
            long contextOffset_ = contextOffset;
            int word_ = word;
            scratch[this.reversed ? 0 : scratch.length - 1] = word_;
            for (int i = 0; i <= contextOrder; ++i) {
                int ngramOrder = contextOrder - i;
                long key = this.getKey(contextOffset_, ngramOrder);
                contextOffset_ = this.contextOffsetOf(key);
                word_ = this.wordOf(key);
                scratch[this.reversed ? i + 1 : scratch.length - i - 2] = word_;
            }
        }
    }

    public int getNextWord(long offset, int ngramOrder) {
        return this.wordOf(this.getKey(offset, ngramOrder));
    }

    public long getNextContextOffset(long offset, int ngramOrder) {
        return this.contextOffsetOf(this.getKey(offset, ngramOrder));
    }

    private long getKey(long offset, int ngramOrder) {
        return this.getMap(ngramOrder).getKey(offset);
    }

    public int getFirstWordForOffset(long offset, int ngramOrder) {
        long key = this.getMap(ngramOrder).getKey(offset);
        if (ngramOrder == 0) {
            return this.wordOf(key);
        }
        return this.getFirstWordForOffset(this.contextOffsetOf(key), ngramOrder - 1);
    }

    public int getLastWordForOffset(long offset, int ngramOrder) {
        long key = this.getMap(ngramOrder).getKey(offset);
        return this.wordOf(key);
    }

    public int[] getNgramForOffset(long offset, int ngramOrder) {
        int[] ret = new int[ngramOrder + 1];
        return this.getNgramForOffset(offset, ngramOrder, ret);
    }

    public int[] getNgramForOffset(long offset, int ngramOrder, int[] ret) {
        long offset_ = offset;
        for (int i = 0; i <= ngramOrder; ++i) {
            long key = this.getMap(ngramOrder - i).getKey(offset_);
            offset_ = this.contextOffsetOf(key);
            int word_ = this.wordOf(key);
            ret[this.reversed ? i : ngramOrder - i] = word_;
        }
        return ret;
    }

    private long getOffsetForContextEncoding(long contextOffset_, int contextOrder, int word, @Annotations.OutputParameter T outputVal) {
        if (word < 0) {
            return -1L;
        }
        int ngramOrder = contextOrder + 1;
        long contextOffset = contextOffset_ >= 0L ? contextOffset_ : 0L;
        long key = this.combineToKey(word, contextOffset);
        long offset = this.getOffsetHelpFromMap(ngramOrder, key);
        if (outputVal != null && offset >= 0L) {
            this.values.getFromOffset(offset, ngramOrder, outputVal);
        }
        return offset;
    }

    private long getOffsetHelpFromMap(int ngramOrder, long key) {
        if (this.isExplicit) {
            return ngramOrder >= this.explicitMaps.length || this.explicitMaps[ngramOrder] == null ? -1L : this.explicitMaps[ngramOrder].getOffset(key);
        }
        return ngramOrder == 0 ? this.implicitUnigramMap.getOffset(key) : this.implicitMaps[ngramOrder - 1].getOffset(key);
    }

    private void rehash(int changedNgramOrder, long newCapacity, int numAdding) {
        assert (this.isExplicit);
        long[] newCapacities = new long[this.explicitMaps.length];
        Arrays.fill(newCapacities, -1L);
        assert (changedNgramOrder >= 0);
        for (int ngramOrder = 0; ngramOrder < this.explicitMaps.length && this.explicitMaps[ngramOrder] != null; ++ngramOrder) {
            if (ngramOrder < changedNgramOrder) {
                newCapacities[ngramOrder] = this.explicitMaps[ngramOrder].getCapacity();
            } else if (ngramOrder == changedNgramOrder) {
                newCapacities[ngramOrder] = newCapacity;
            } else {
                long l = newCapacities[ngramOrder] = this.explicitMaps[ngramOrder].getLoadFactor(numAdding) >= this.maxLoadFactor / 2.0 ? (this.explicitMaps[ngramOrder].getCapacity() + (long)numAdding) * 3L / 2L : this.explicitMaps[ngramOrder].getCapacity();
            }
            assert (newCapacities[ngramOrder] >= 0L) : "Bad capacity " + newCapacities[ngramOrder];
        }
        ValueContainer newValues = this.values.createFreshValues(newCapacities);
        HashNgramMap newMap = new HashNgramMap(newValues, this.opts, newCapacities, this.reversed, Arrays.copyOf(this.explicitMaps, changedNgramOrder));
        for (int ngramOrder = 0; ngramOrder < this.explicitMaps.length; ++ngramOrder) {
            ExplicitWordHashMap currHashMap = this.explicitMaps[ngramOrder];
            if (currHashMap == null) continue;
            ExplicitWordHashMap newHashMap = (ExplicitWordHashMap)super.getHashMapForOrder(ngramOrder);
            Object val = this.values.getScratchValue();
            int[] scratchArray = new int[ngramOrder + 1];
            for (long actualIndex = 0L; actualIndex < currHashMap.getCapacity(); ++actualIndex) {
                long suffixIndex;
                long key = currHashMap.getKey(actualIndex);
                if (currHashMap.isEmptyKey(key)) continue;
                this.getNgramFromContextEncodingHelp(this.contextOffsetOf(key), ngramOrder - 1, this.wordOf(key), scratchArray);
                long newKey = super.getKey(scratchArray, 0, scratchArray.length);
                assert (newKey >= 0L) : "Failure for old n-gram " + Arrays.toString(scratchArray);
                long index = newHashMap.put(newKey);
                assert (index >= 0L);
                long l = suffixIndex = this.storeSuffixOffsets ? super.getSuffixOffset(scratchArray, 0, scratchArray.length) : -1L;
                assert (!this.storeSuffixOffsets || suffixIndex >= 0L) : "Could not find suffix offset for " + Arrays.toString(scratchArray);
                this.values.getFromOffset(actualIndex, ngramOrder, val);
                boolean addWorked = newMap.values.add(scratchArray, 0, scratchArray.length, ngramOrder, index, this.contextOffsetOf(newKey), this.wordOf(newKey), val, suffixIndex, true);
                assert (addWorked);
            }
            this.values.clearStorageForOrder(ngramOrder);
        }
        System.arraycopy(newMap.explicitMaps, 0, this.explicitMaps, 0, newMap.explicitMaps.length);
        this.values.setFromOtherValues(newValues);
        this.values.setMap(this);
    }

    private long getOffsetFromRawNgram(int[] ngram, int startPos, int endPos) {
        if (HashNgramMap.containsOutOfVocab(ngram, startPos, endPos)) {
            return -1L;
        }
        int ngramOrder = endPos - startPos - 1;
        if (ngramOrder >= this.getMaxNgramOrder()) {
            return -1L;
        }
        long key = this.getKey(ngram, startPos, endPos);
        if (key < 0L) {
            return -1L;
        }
        HashMap currMap = this.getMap(ngramOrder);
        if (currMap == null) {
            return -1L;
        }
        long index = currMap.getOffset(key);
        return index;
    }

    @Override
    public ContextEncodedNgramLanguageModel.LmContextInfo getOffsetForNgram(int[] ngram, int startPos, int endPos) {
        long offset;
        ContextEncodedNgramLanguageModel.LmContextInfo lmContextInfo = new ContextEncodedNgramLanguageModel.LmContextInfo();
        for (int start = endPos - 1; start >= startPos && (offset = this.getOffsetFromRawNgram(ngram, start, endPos)) >= 0L; --start) {
            lmContextInfo.offset = offset;
            lmContextInfo.order = endPos - start - 1;
        }
        return lmContextInfo;
    }

    public long getOffsetForNgramInModel(int[] ngram, int startPos, int endPos) {
        return this.getOffsetFromRawNgram(ngram, startPos, endPos);
    }

    @Override
    public void handleNgramsFinished(int justFinishedOrder) {
    }

    @Override
    public void initWithLengths(List<Long> numNGrams) {
    }

    @Override
    public void trim() {
        HashMap currMap;
        for (int ngramOrder = 0; ngramOrder < this.getMaxNgramOrder() && (currMap = this.getMap(ngramOrder)) != null; ++ngramOrder) {
            this.values.trimAfterNgram(ngramOrder, currMap.getCapacity());
            Logger.logss("Load factor for " + (ngramOrder + 1) + ": " + currMap.getLoadFactor());
        }
        this.values.trim();
    }

    private long getSuffixOffset(int[] ngram, int startPos, int endPos) {
        if (endPos - startPos == 1) {
            return 0L;
        }
        long offset = this.getOffsetFromRawNgram(ngram, this.reversed ? startPos : startPos + 1, this.reversed ? endPos - 1 : endPos);
        return offset;
    }

    public long getPrefixOffset(long offset, int ngramOrder) {
        if (ngramOrder == 0) {
            return -1L;
        }
        return this.contextOffsetOf(this.getKey(offset, ngramOrder));
    }

    private long getKey(int[] ngram, int startPos, int endPos) {
        long contextOffset = 0L;
        for (int ngramOrder = 0; ngramOrder < endPos - startPos - 1; ++ngramOrder) {
            int currNgramPos = this.reversed ? endPos - ngramOrder - 1 : startPos + ngramOrder;
            if ((contextOffset = this.getOffsetForContextEncoding(contextOffset, ngramOrder - 1, ngram[currNgramPos], null)) != -1L) continue;
            return -1L;
        }
        return this.combineToKey(this.headWord(ngram, startPos, endPos), contextOffset);
    }

    private int headWord(int[] ngram, int startPos, int endPos) {
        return this.reversed ? ngram[startPos] : ngram[endPos - 1];
    }

    @Override
    public int getMaxNgramOrder() {
        return this.explicitMaps == null ? this.implicitMaps.length + 1 : this.explicitMaps.length;
    }

    @Override
    public long getNumNgrams(int ngramOrder) {
        return this.getMap(ngramOrder).size();
    }

    @Override
    public Iterable<NgramMap.Entry<T>> getNgramsForOrder(final int ngramOrder) {
        HashMap map = this.getMap(ngramOrder);
        if (map == null) {
            return Collections.emptyList();
        }
        return Iterators.able(new Iterators.Transform<Long, NgramMap.Entry<T>>(map.keys().iterator()){

            @Override
            protected NgramMap.Entry<T> transform(Long next) {
                long offset = next;
                Object val = HashNgramMap.this.values.getScratchValue();
                HashNgramMap.this.values.getFromOffset(offset, ngramOrder, val);
                return new NgramMap.Entry(HashNgramMap.this.getNgramForOffset(offset, ngramOrder), val);
            }
        });
    }

    public Iterable<Long> getNgramOffsetsForOrder(int ngramOrder) {
        HashMap map = this.getMap(ngramOrder);
        if (map == null) {
            return Collections.emptyList();
        }
        return map.keys();
    }

    private HashMap getMap(int ngramOrder) {
        if (this.explicitMaps == null) {
            return ngramOrder == 0 ? this.implicitUnigramMap : this.implicitMaps[ngramOrder - 1];
        }
        if (ngramOrder >= this.explicitMaps.length) {
            int oldLength = this.explicitMaps.length;
            this.explicitMaps = Arrays.copyOf(this.explicitMaps, this.explicitMaps.length * 2);
            this.initCapacities = Arrays.copyOf(this.initCapacities, this.initCapacities.length * 2);
            Arrays.fill(this.initCapacities, oldLength, this.initCapacities.length, 100L);
        }
        return this.explicitMaps[ngramOrder];
    }

    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public boolean wordHasBigrams(int word) {
        return this.getMaxNgramOrder() < 2 ? false : (this.explicitMaps == null ? this.implicitMaps[0].hasContexts(word) : this.explicitMaps[1].hasContexts(word));
    }

    @Override
    public boolean contains(int[] ngram, int startPos, int endPos) {
        return this.getOffsetFromRawNgram(ngram, startPos, endPos) >= 0L;
    }

    @Override
    public T get(int[] ngram, int startPos, int endPos) {
        long offset = this.getOffsetFromRawNgram(ngram, startPos, endPos);
        if (offset < 0L) {
            return null;
        }
        Object val = this.values.getScratchValue();
        this.values.getFromOffset(offset, endPos - startPos - 1, val);
        return (T)val;
    }

    public long getTotalSize() {
        HashMap currMap;
        long ret = 0L;
        for (int ngramOrder = 0; ngramOrder < this.getMaxNgramOrder() && (currMap = this.getMap(ngramOrder)) != null; ++ngramOrder) {
            ret += currMap.size();
        }
        return ret;
    }

    @Override
    public CustomWidthArray getValueStoringArray(int ngramOrder) {
        return ngramOrder == 0 || this.isExplicit ? null : this.implicitMaps[ngramOrder - 1].keys;
    }

    @Override
    public void clearStorage() {
        int i;
        if (this.implicitMaps != null) {
            for (i = 0; i < this.implicitMaps.length; ++i) {
                this.implicitMaps[i] = null;
            }
        }
        if (this.explicitMaps != null) {
            for (i = 0; i < this.explicitMaps.length; ++i) {
                this.explicitMaps[i] = null;
            }
        }
    }

    double getLoadFactor() {
        return this.maxLoadFactor;
    }
}

