/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

public class NextProtoNegoExtension
extends HelloExtension {
    private static final int ID = 13172;
    private final List<String> protocols = new ArrayList<String>();
    private final byte[] content;

    public NextProtoNegoExtension() throws SSLProtocolException {
        this(Collections.emptyList());
    }

    public NextProtoNegoExtension(List<String> protocols) throws SSLProtocolException {
        super(ExtensionType.get(13172));
        this.protocols.addAll(protocols);
        this.content = this.init();
    }

    public NextProtoNegoExtension(HandshakeInStream input, int length) throws IOException {
        super(ExtensionType.get(13172));
        while (length > 0) {
            byte[] protoBytes = input.getBytes8();
            this.protocols.add(new String(protoBytes, "UTF-8"));
            length -= 1 + protoBytes.length;
        }
        this.content = this.init();
    }

    private byte[] init() throws SSLProtocolException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (String protocol : this.protocols) {
            byte[] protocolBytes = protocol.getBytes(Charset.forName("UTF-8"));
            int length = protocolBytes.length;
            if (length > 127) {
                throw new SSLProtocolException("Invalid protocol " + protocol);
            }
            bytes.write(length);
            bytes.write(protocolBytes, 0, length);
        }
        return bytes.toByteArray();
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    @Override
    int length() {
        return 4 + this.content.length;
    }

    @Override
    void send(HandshakeOutStream out) throws IOException {
        out.putInt16(13172);
        out.putInt16(this.content.length);
        out.write(this.content, 0, this.content.length);
    }

    @Override
    public String toString() {
        return "Extension " + this.type + ", protocols: " + this.protocols;
    }
}

