# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from openstack.cluster import cluster_service
from openstack import resource2 as resource


class BuildInfo(resource.Resource):
    base_path = '/build-info'
    resource_key = 'build_info'
    service = cluster_service.ClusterService()

    # Capabilities
    allow_get = True

    # Properties
    #: String representation of the API build version
    api = resource.Body('api')
    #: String representation of the engine build version
    engine = resource.Body('engine')
