/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.Element;

public interface ErrorListener {
    public void error(ErrorEvent var1);

    public static class ErrorEvent {
        public static final int SEVERITY_ERROR = 5;
        public static final int SEVERITY_WARNING = 3;
        public static final int SEVERITY_NOTE = 1;
        protected String message = null;
        protected int line = 0;
        protected String filename = null;
        protected int severity = 5;
        protected Throwable exception = null;

        public ErrorEvent(String message, String filename, int line, int severity) {
            this.message = message;
            this.filename = filename;
            this.line = line;
            this.severity = severity;
        }

        public ErrorEvent(Throwable t, String filename, int line, int severity) {
            this.exception = t;
            this.message = t.getLocalizedMessage();
            this.filename = filename;
            this.line = line;
            this.severity = severity;
        }

        public ErrorEvent(String message, Element origin, int severity) {
            this.message = message;
            this.severity = severity;
        }

        public String getFileName() {
            return this.filename;
        }

        public int getLine() {
            return this.line;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(100);
            if (this.filename != null) {
                buf.append(this.filename);
                buf.append(':');
            }
            if (this.line != 0) {
                buf.append(this.line);
                buf.append(':');
            }
            buf.append(this.message);
            return buf.toString();
        }

        public int getSeverity() {
            return this.severity;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

