/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.standalone.gui;

import com.baselet.control.CanCloseProgram;
import com.baselet.control.Main;
import com.baselet.control.config.Config;
import com.baselet.control.util.Path;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.DrawPanel;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElementHandler;
import com.baselet.gui.BaseGUI;
import com.baselet.gui.pane.OwnSyntaxPane;
import com.baselet.standalone.gui.MenuBuilder;
import com.baselet.standalone.gui.StandaloneGUIBuilder;
import com.baselet.standalone.gui.TabComponent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneGUI
extends BaseGUI {
    private final Logger log = LoggerFactory.getLogger(StandaloneGUI.class);
    private JFrame mainFrame;
    private final MenuBuilder menuBuilder = new MenuBuilder();
    private final StandaloneGUIBuilder guiBuilder = new StandaloneGUIBuilder();
    private final File runningFile;

    public StandaloneGUI(CanCloseProgram main, File runningFile) {
        super(main);
        this.runningFile = runningFile;
    }

    @Override
    public void updateDiagramName(DiagramHandler diagram, String name) {
        JTabbedPane diagramtabs = this.guiBuilder.getDiagramtabs();
        int index = diagramtabs.indexOfComponent(diagram.getDrawPanel().getScrollPane());
        if (index != -1) {
            diagramtabs.setTitleAt(index, name);
            ((TabComponent)diagramtabs.getTabComponentAt(index)).updateUI();
        }
    }

    @Override
    public void setDiagramChanged(DiagramHandler diagram, boolean changed) {
        String change_string = "";
        if (changed) {
            change_string = " *";
        }
        this.updateDiagramName(diagram, diagram.getName() + change_string);
    }

    @Override
    public void setCustomElementChanged(CustomElementHandler handler, boolean changed) {
    }

    @Override
    public void closeWindow() {
        this.guiBuilder.getMailPanel().closePanel();
        if (this.askSaveForAllDirtyDiagrams()) {
            Path.safeDeleteFile(this.runningFile, true);
            this.main.closeProgram();
            System.exit(0);
        }
    }

    private boolean askSaveForAllDirtyDiagrams() {
        boolean ok = true;
        for (DiagramHandler d : Main.getInstance().getDiagrams()) {
            if (d.askSaveIfDirty()) continue;
            ok = false;
        }
        if (!this.getCurrentCustomHandler().closeEntity()) {
            ok = false;
        }
        return ok;
    }

    @Override
    protected void init() {
        this.mainFrame = this.guiBuilder.initSwingGui(this.menuBuilder);
    }

    @Override
    public void showPalette(String palette) {
        super.showPalette(palette);
        this.guiBuilder.setPaletteActive(palette);
    }

    @Override
    public String getSelectedPalette() {
        return this.guiBuilder.getPaletteList().getSelectedItem().toString();
    }

    @Override
    public void close(DiagramHandler diagram) {
        this.guiBuilder.getDiagramtabs().remove(diagram.getDrawPanel().getScrollPane());
        DrawPanel p = this.getCurrentDiagram();
        if (p != null) {
            CurrentDiagram.getInstance().setCurrentDiagramHandler(p.getHandler());
        } else {
            CurrentDiagram.getInstance().setCurrentDiagramHandler(null);
        }
    }

    @Override
    public void open(DiagramHandler diagram) {
        JTabbedPane diagramtabs = this.guiBuilder.getDiagramtabs();
        diagramtabs.add(diagram.getName(), diagram.getDrawPanel().getScrollPane());
        diagramtabs.setTabComponentAt(diagramtabs.getTabCount() - 1, new TabComponent(diagramtabs, diagram));
        this.jumpTo(diagram);
    }

    @Override
    public void jumpTo(DiagramHandler diagram) {
        this.guiBuilder.getDiagramtabs().setSelectedComponent(diagram.getDrawPanel().getScrollPane());
        diagram.getDrawPanel().getSelector().updateSelectorInformation();
        DrawPanel p = this.getCurrentDiagram();
        if (p != null) {
            CurrentDiagram.getInstance().setCurrentDiagramHandler(p.getHandler());
        } else {
            CurrentDiagram.getInstance().setCurrentDiagramHandler(null);
        }
    }

    @Override
    public DrawPanel getCurrentDiagram() {
        JScrollPane scr = (JScrollPane)this.guiBuilder.getDiagramtabs().getSelectedComponent();
        if (scr != null) {
            return (DrawPanel)scr.getViewport().getView();
        }
        return null;
    }

    @Override
    public void elementsSelected(Collection<GridElement> selectedElements) {
        super.elementsSelected(selectedElements);
        this.menuBuilder.elementsSelected(selectedElements);
    }

    @Override
    public void enablePasteMenuEntry() {
        this.menuBuilder.enablePasteMenuEntry();
    }

    @Override
    public void setCustomPanelEnabled(boolean enable) {
        this.guiBuilder.setCustomPanelEnabled(enable);
        this.menuBuilder.setNewCustomElementMenuItemsEnabled(!enable);
        this.setDrawPanelEnabled(!enable);
    }

    private void setDrawPanelEnabled(boolean enable) {
        JTabbedPane diagramtabs = this.guiBuilder.getDiagramtabs();
        this.guiBuilder.getPalettePanel().setEnabled(enable);
        for (Component c : this.guiBuilder.getPalettePanel().getComponents()) {
            c.setEnabled(enable);
        }
        diagramtabs.setEnabled(enable);
        for (Component c : diagramtabs.getComponents()) {
            c.setEnabled(enable);
        }
        for (int i = 0; i < diagramtabs.getTabCount(); ++i) {
            diagramtabs.getTabComponentAt(i).setEnabled(enable);
        }
        this.guiBuilder.getSearchField().setEnabled(enable);
    }

    @Override
    public void setMailPanelEnabled(boolean enable) {
        this.guiBuilder.setMailPanelEnabled(enable);
    }

    @Override
    public boolean isMailPanelVisible() {
        return this.guiBuilder.getMailPanel().isVisible();
    }

    @Override
    public void setCustomElementSelected(boolean selected) {
        this.menuBuilder.setEditCustomElementMenuItemEnabled(selected && !this.guiBuilder.getCustomPanel().isVisible());
    }

    @Override
    public void diagramSelected(DiagramHandler handler) {
        this.updateGrayedOutMenuItems(handler);
    }

    @Override
    public void updateGrayedOutMenuItems(DiagramHandler handler) {
        this.menuBuilder.updateGrayedOutMenuItems(handler);
    }

    @Override
    public void enableSearch(boolean enable) {
        this.guiBuilder.getSearchField().requestFocus();
    }

    @Override
    public int getMainSplitPosition() {
        return this.guiBuilder.getMainSplit().getDividerLocation();
    }

    @Override
    public int getRightSplitPosition() {
        return this.guiBuilder.getRightSplit().getDividerLocation();
    }

    @Override
    public int getMailSplitPosition() {
        return Config.getInstance().getMail_split_position();
    }

    @Override
    public Frame getMainFrame() {
        return this.mainFrame;
    }

    @Override
    public CustomElementHandler getCurrentCustomHandler() {
        return this.guiBuilder.getCustomHandler();
    }

    @Override
    public OwnSyntaxPane getPropertyPane() {
        return this.guiBuilder.getPropertyTextPane();
    }

    @Override
    public void setValueOfZoomDisplay(int i) {
        JComboBox zoomComboBox = this.guiBuilder.getZoomComboBox();
        if (zoomComboBox != null) {
            zoomComboBox.removeActionListener(this.guiBuilder.getZoomListener());
            zoomComboBox.setSelectedIndex(i - 1);
            zoomComboBox.addActionListener(this.guiBuilder.getZoomListener());
        }
    }

    @Override
    public void focusPropertyPane() {
        this.guiBuilder.getPropertyTextPane().getTextComponent().requestFocus();
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.mainFrame != null) {
            this.mainFrame.setCursor(cursor);
        }
    }

    @Override
    public void requestFocus() {
        this.mainFrame.requestFocus();
    }

    @Override
    public void setLookAndFeel(String newui, JFrame optionframe) {
        try {
            Frame topFrame = this.getMainFrame();
            UIManager.setLookAndFeel(newui);
            SwingUtilities.updateComponentTreeUI(topFrame);
            SwingUtilities.updateComponentTreeUI(optionframe);
            topFrame.pack();
            optionframe.pack();
        }
        catch (ClassNotFoundException e) {
            this.log.error("Cannot set LookAndFeel", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.error("Cannot set LookAndFeel", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.error("Cannot set LookAndFeel", (Throwable)e);
        }
        catch (UnsupportedLookAndFeelException e) {
            this.log.error("Cannot set LookAndFeel", (Throwable)e);
        }
    }

    @Override
    public boolean hasExtendedContextMenu() {
        return true;
    }

    @Override
    public boolean saveWindowSizeInConfig() {
        return true;
    }
}

