/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.Stickable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class UndoInformation {
    private final Rectangle diffRect;
    private final Map<Stickable, List<PointChange>> stickableMoves;
    private final String oldAdditionalAttributes;
    private final String newAdditionalAttributes;

    private UndoInformation(Rectangle diffRect, Map<Stickable, List<PointChange>> stickableMoves, String oldAdditionalAttributes, String newAdditionalAttributes) {
        this.diffRect = diffRect;
        this.stickableMoves = stickableMoves;
        this.oldAdditionalAttributes = oldAdditionalAttributes;
        this.newAdditionalAttributes = newAdditionalAttributes;
    }

    public UndoInformation(Rectangle newRect, Rectangle oldRect, Map<Stickable, List<PointChange>> stickableMoves, int gridSize, String oldAdditionalAttributes, String newAdditionalAttributes) {
        this(UndoInformation.toMinZoom(newRect.subtract(oldRect), gridSize), stickableMoves, oldAdditionalAttributes, newAdditionalAttributes);
    }

    private static Map<Stickable, List<PointChange>> invertStickableMoves(Map<Stickable, List<PointChange>> stickableMoves) {
        HashMap<Stickable, List<PointChange>> invertedMap = new HashMap<Stickable, List<PointChange>>();
        for (Map.Entry<Stickable, List<PointChange>> entry : stickableMoves.entrySet()) {
            ArrayList<PointChange> invList = new ArrayList<PointChange>();
            for (PointChange p : entry.getValue()) {
                invList.add(new PointChange(p.getIndex(), -p.getDiffX(), -p.getDiffY()));
            }
            invertedMap.put(entry.getKey(), invList);
        }
        return invertedMap;
    }

    public Rectangle getDiffRectangle(int gridSize, boolean undo) {
        Rectangle returnRect = undo ? this.diffRect.copyInverted() : this.diffRect;
        return UndoInformation.toCurrentZoom(returnRect, gridSize);
    }

    public Map<Stickable, List<PointChange>> getStickableMoves(boolean undo) {
        return undo ? UndoInformation.invertStickableMoves(this.stickableMoves) : this.stickableMoves;
    }

    public String getAdditionalAttributes(boolean undo) {
        if (undo) {
            return this.oldAdditionalAttributes;
        }
        return this.newAdditionalAttributes;
    }

    private static Rectangle toMinZoom(Rectangle rectangle, int gridSize) {
        int xBefore = UndoInformation.toMinZoom(rectangle.getX(), gridSize);
        int yBefore = UndoInformation.toMinZoom(rectangle.getY(), gridSize);
        int wBefore = UndoInformation.toMinZoom(rectangle.getWidth(), gridSize);
        int hBefore = UndoInformation.toMinZoom(rectangle.getHeight(), gridSize);
        return new Rectangle(xBefore, yBefore, wBefore, hBefore);
    }

    private static int toMinZoom(int val, int gridSize) {
        return val / gridSize;
    }

    private static Rectangle toCurrentZoom(Rectangle rectangle, int gridSize) {
        int xBefore = UndoInformation.toCurrentZoom(rectangle.getX(), gridSize);
        int yBefore = UndoInformation.toCurrentZoom(rectangle.getY(), gridSize);
        int wBefore = UndoInformation.toCurrentZoom(rectangle.getWidth(), gridSize);
        int hBefore = UndoInformation.toCurrentZoom(rectangle.getHeight(), gridSize);
        return new Rectangle(xBefore, yBefore, wBefore, hBefore);
    }

    private static int toCurrentZoom(int val, int gridSize) {
        return val * gridSize;
    }

    public UndoInformation merge(UndoInformation other) {
        Rectangle mergedUndoDiffRect = this.diffRect.add(other.diffRect);
        HashMap<Stickable, List<PointChange>> mergedMap = new HashMap<Stickable, List<PointChange>>();
        this.mergeStickableMoves(mergedMap, this.stickableMoves);
        this.mergeStickableMoves(mergedMap, other.stickableMoves);
        return new UndoInformation(mergedUndoDiffRect, mergedMap, other.oldAdditionalAttributes, this.newAdditionalAttributes);
    }

    private void mergeStickableMoves(Map<Stickable, List<PointChange>> targetMap, Map<Stickable, List<PointChange>> sourceMap) {
        for (Map.Entry<Stickable, List<PointChange>> sourceEntry : sourceMap.entrySet()) {
            Stickable sourceStickable = sourceEntry.getKey();
            List<PointChange> sourceChangeList = sourceEntry.getValue();
            List<PointChange> targetPointChanges = targetMap.get(sourceStickable);
            if (targetPointChanges == null) {
                targetMap.put(sourceStickable, sourceChangeList);
                continue;
            }
            this.mergeSourceToTarget(sourceChangeList, targetPointChanges);
        }
    }

    private void mergeSourceToTarget(List<PointChange> sourceChangeList, List<PointChange> targetPointChanges) {
        for (PointChange sourceChange : sourceChangeList) {
            this.mergePoint(targetPointChanges, sourceChange);
        }
    }

    private void mergePoint(List<PointChange> targetPointChanges, PointChange sourceChange) {
        ListIterator<PointChange> iter = targetPointChanges.listIterator();
        while (iter.hasNext()) {
            PointChange targetChange = iter.next();
            if (!sourceChange.getIndex().equals(targetChange.getIndex())) continue;
            iter.set(new PointChange(targetChange.getIndex(), sourceChange.getDiffX() + targetChange.getDiffX(), sourceChange.getDiffY() + targetChange.getDiffY()));
            return;
        }
        targetPointChanges.add(sourceChange);
    }

    public String toString(boolean undo) {
        return "UndoInformation [diffRect=" + this.getDiffRectangle(10, undo) + ", stickableMoves=" + SharedUtils.mapToString(this.getStickableMoves(undo)) + ", additionalAttributes=" + this.getAdditionalAttributes(undo) + "]";
    }
}

