/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.cron4j;

import it.sauronsoftware.cron4j.GUIDGenerator;
import it.sauronsoftware.cron4j.Scheduler;

class TimerThread
extends Thread {
    private String guid = GUIDGenerator.generate();
    private Scheduler scheduler;

    public TimerThread(Scheduler scheduler) {
        this.scheduler = scheduler;
        String string = "cron4j::scheduler[" + scheduler.getGuid() + "]::timer[" + this.guid + "]";
        this.setName(string);
    }

    public Object getGuid() {
        return this.guid;
    }

    private void safeSleep(long l) throws InterruptedException {
        long l2;
        long l3;
        long l4 = 0L;
        do {
            l2 = System.currentTimeMillis();
            TimerThread.sleep(l - l4);
        } while ((l4 += (l3 = System.currentTimeMillis()) - l2) < l);
    }

    public void run() {
        long l = System.currentTimeMillis();
        long l2 = (l / 60000L + 1L) * 60000L;
        while (true) {
            long l3;
            if ((l3 = l2 - System.currentTimeMillis()) > 0L) {
                try {
                    this.safeSleep(l3);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            l = System.currentTimeMillis();
            this.scheduler.spawnLauncher(l);
            l2 = (l / 60000L + 1L) * 60000L;
        }
        this.scheduler = null;
    }
}

