/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import com.carrotsearch.hppc.IntArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.search.AbstractAsyncAction;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.fetch.ShardFetchSearchRequest;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

abstract class AbstractSearchAsyncAction<FirstResult extends SearchPhaseResult>
extends AbstractAsyncAction {
    protected final ESLogger logger;
    protected final SearchServiceTransportAction searchService;
    protected final SearchPhaseController searchPhaseController;
    protected final ThreadPool threadPool;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    protected final ActionListener<SearchResponse> listener;
    protected final GroupShardsIterator shardsIts;
    protected final SearchRequest request;
    protected final ClusterState clusterState;
    protected final DiscoveryNodes nodes;
    protected final int expectedSuccessfulOps;
    private final int expectedTotalOps;
    protected final AtomicInteger successfulOps = new AtomicInteger();
    private final AtomicInteger totalOps = new AtomicInteger();
    protected final AtomicArray<FirstResult> firstResults;
    private volatile AtomicArray<ShardSearchFailure> shardFailures;
    private final Object shardFailuresMutex = new Object();
    protected volatile ScoreDoc[] sortedShardList;

    protected AbstractSearchAsyncAction(ESLogger logger, SearchServiceTransportAction searchService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, SearchPhaseController searchPhaseController, ThreadPool threadPool, SearchRequest request, ActionListener<SearchResponse> listener) {
        String[] concreteIndices;
        this.logger = logger;
        this.searchService = searchService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.searchPhaseController = searchPhaseController;
        this.threadPool = threadPool;
        this.request = request;
        this.listener = listener;
        this.clusterState = clusterService.state();
        this.nodes = this.clusterState.nodes();
        this.clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        for (String index : concreteIndices = indexNameExpressionResolver.concreteIndices(this.clusterState, request.indicesOptions(), this.startTime(), request.indices())) {
            this.clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index);
        }
        Map<String, Set<String>> routingMap = indexNameExpressionResolver.resolveSearchRouting(this.clusterState, request.routing(), request.indices());
        this.shardsIts = clusterService.operationRouting().searchShards(this.clusterState, concreteIndices, routingMap, request.preference());
        this.expectedSuccessfulOps = this.shardsIts.size();
        this.expectedTotalOps = this.shardsIts.totalSizeWith1ForEmpty();
        this.firstResults = new AtomicArray(this.shardsIts.size());
    }

    @Override
    public void start() {
        if (this.expectedSuccessfulOps == 0) {
            this.listener.onResponse(new SearchResponse(InternalSearchResponse.empty(), null, 0, 0, this.buildTookInMillis(), ShardSearchFailure.EMPTY_ARRAY));
            return;
        }
        int shardIndex = -1;
        for (ShardIterator shardIt : this.shardsIts) {
            ++shardIndex;
            ShardRouting shard = shardIt.nextOrNull();
            if (shard != null) {
                this.performFirstPhase(shardIndex, shardIt, shard);
                continue;
            }
            this.onFirstPhaseResult(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
        }
    }

    void performFirstPhase(final int shardIndex, final ShardIterator shardIt, final ShardRouting shard) {
        if (shard == null) {
            this.onFirstPhaseResult(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
        } else {
            final DiscoveryNode node = this.nodes.get(shard.currentNodeId());
            if (node == null) {
                this.onFirstPhaseResult(shardIndex, shard, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
            } else {
                String[] filteringAliases = this.indexNameExpressionResolver.filteringAliases(this.clusterState, shard.index(), this.request.indices());
                this.sendExecuteFirstPhase(node, TransportSearchHelper.internalSearchRequest(shard, this.shardsIts.size(), this.request, filteringAliases, this.startTime()), new ActionListener<FirstResult>(){

                    @Override
                    public void onResponse(FirstResult result) {
                        AbstractSearchAsyncAction.this.onFirstPhaseResult(shardIndex, shard, result, shardIt);
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        AbstractSearchAsyncAction.this.onFirstPhaseResult(shardIndex, shard, node.id(), shardIt, t);
                    }
                });
            }
        }
    }

    void onFirstPhaseResult(int shardIndex, ShardRouting shard, FirstResult result, ShardIterator shardIt) {
        result.shardTarget(new SearchShardTarget(shard.currentNodeId(), shard.index(), shard.id()));
        this.processFirstPhaseResult(shardIndex, result);
        this.successfulOps.incrementAndGet();
        int xTotalOps = this.totalOps.addAndGet(shardIt.remaining() + 1);
        if (xTotalOps == this.expectedTotalOps) {
            try {
                this.innerMoveToSecondPhase();
            }
            catch (Throwable e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(shardIt.shardId() + ": Failed to execute [" + this.request + "] while moving to second phase", e, new Object[0]);
                }
                this.raiseEarlyFailure(new ReduceSearchPhaseException(this.firstPhaseName(), "", e, this.buildShardFailures()));
            }
        } else if (xTotalOps > this.expectedTotalOps) {
            this.raiseEarlyFailure(new IllegalStateException("unexpected higher total ops [" + xTotalOps + "] compared to expected [" + this.expectedTotalOps + "]"));
        }
    }

    void onFirstPhaseResult(int shardIndex, @Nullable ShardRouting shard, @Nullable String nodeId, ShardIterator shardIt, Throwable t) {
        SearchShardTarget shardTarget = new SearchShardTarget(nodeId, shardIt.shardId().getIndex(), shardIt.shardId().getId());
        this.addShardFailure(shardIndex, shardTarget, t);
        if (this.totalOps.incrementAndGet() == this.expectedTotalOps) {
            if (this.logger.isDebugEnabled()) {
                if (t != null && !TransportActions.isShardNotAvailableException(t)) {
                    if (shard != null) {
                        this.logger.debug(shard.shortSummary() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    } else {
                        this.logger.debug(shardIt.shardId() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    }
                } else if (this.logger.isTraceEnabled()) {
                    this.logger.trace("{}: Failed to execute [{}]", t, shard, this.request);
                }
            }
            if (this.successfulOps.get() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("All shards failed for phase: [{}]", t, this.firstPhaseName());
                }
                this.raiseEarlyFailure(new SearchPhaseExecutionException(this.firstPhaseName(), "all shards failed", this.buildShardFailures()));
            } else {
                try {
                    this.innerMoveToSecondPhase();
                }
                catch (Throwable e) {
                    this.raiseEarlyFailure(new ReduceSearchPhaseException(this.firstPhaseName(), "", e, this.buildShardFailures()));
                }
            }
        } else {
            boolean lastShard;
            ShardRouting nextShard = shardIt.nextOrNull();
            boolean bl = lastShard = nextShard == null;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.executionFailureMsg(shard, shardIt, this.request, lastShard), t, new Object[0]);
            }
            if (!lastShard) {
                try {
                    this.performFirstPhase(shardIndex, shardIt, nextShard);
                }
                catch (Throwable t1) {
                    this.onFirstPhaseResult(shardIndex, shard, shard.currentNodeId(), shardIt, t1);
                }
            } else if (this.logger.isDebugEnabled() && !this.logger.isTraceEnabled() && t != null && !TransportActions.isShardNotAvailableException(t)) {
                this.logger.debug(this.executionFailureMsg(shard, shardIt, this.request, lastShard), t, new Object[0]);
            }
        }
    }

    private String executionFailureMsg(@Nullable ShardRouting shard, ShardIterator shardIt, SearchRequest request, boolean lastShard) {
        if (shard != null) {
            return shard.shortSummary() + ": Failed to execute [" + request + "] lastShard [" + lastShard + "]";
        }
        return shardIt.shardId() + ": Failed to execute [" + request + "] lastShard [" + lastShard + "]";
    }

    protected final ShardSearchFailure[] buildShardFailures() {
        AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures;
        if (shardFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        List<AtomicArray.Entry<ShardSearchFailure>> entries = shardFailures.asList();
        ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
        for (int i = 0; i < failures.length; ++i) {
            failures[i] = (ShardSearchFailure)entries.get((int)i).value;
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addShardFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Throwable t) {
        ShardSearchFailure failure;
        if (TransportActions.isShardNotAvailableException(t)) {
            return;
        }
        if (this.shardFailures == null) {
            Object object = this.shardFailuresMutex;
            synchronized (object) {
                if (this.shardFailures == null) {
                    this.shardFailures = new AtomicArray(this.shardsIts.size());
                }
            }
        }
        if ((failure = this.shardFailures.get(shardIndex)) == null) {
            this.shardFailures.set(shardIndex, new ShardSearchFailure(t, shardTarget));
        } else if (TransportActions.isReadOverrideException(t)) {
            this.shardFailures.set(shardIndex, new ShardSearchFailure(t, shardTarget));
        }
    }

    private void raiseEarlyFailure(Throwable t) {
        for (AtomicArray.Entry<FirstResult> entry : this.firstResults.asList()) {
            try {
                DiscoveryNode node = this.nodes.get(((SearchPhaseResult)entry.value).shardTarget().nodeId());
                this.sendReleaseSearchContext(((SearchPhaseResult)entry.value).id(), node);
            }
            catch (Throwable t1) {
                this.logger.trace("failed to release context", t1, new Object[0]);
            }
        }
        this.listener.onFailure(t);
    }

    protected void releaseIrrelevantSearchContexts(AtomicArray<? extends QuerySearchResultProvider> queryResults, AtomicArray<IntArrayList> docIdsToLoad) {
        if (docIdsToLoad == null) {
            return;
        }
        if (this.request.scroll() == null) {
            for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults.asList()) {
                TopDocs topDocs = ((QuerySearchResultProvider)entry.value).queryResult().queryResult().topDocs();
                if (topDocs == null || topDocs.scoreDocs.length <= 0 || docIdsToLoad.get(entry.index) != null) continue;
                try {
                    DiscoveryNode node = this.nodes.get(((QuerySearchResultProvider)entry.value).queryResult().shardTarget().nodeId());
                    this.sendReleaseSearchContext(((QuerySearchResultProvider)entry.value).queryResult().id(), node);
                }
                catch (Throwable t1) {
                    this.logger.trace("failed to release context", t1, new Object[0]);
                }
            }
        }
    }

    protected void sendReleaseSearchContext(long contextId, DiscoveryNode node) {
        if (node != null) {
            this.searchService.sendFreeContext(node, contextId, this.request);
        }
    }

    protected ShardFetchSearchRequest createFetchRequest(QuerySearchResult queryResult, AtomicArray.Entry<IntArrayList> entry, ScoreDoc[] lastEmittedDocPerShard) {
        if (lastEmittedDocPerShard != null) {
            ScoreDoc lastEmittedDoc = lastEmittedDocPerShard[entry.index];
            return new ShardFetchSearchRequest(this.request, queryResult.id(), (IntArrayList)entry.value, lastEmittedDoc);
        }
        return new ShardFetchSearchRequest(this.request, queryResult.id(), (IntArrayList)entry.value);
    }

    protected abstract void sendExecuteFirstPhase(DiscoveryNode var1, ShardSearchTransportRequest var2, ActionListener<FirstResult> var3);

    protected final void processFirstPhaseResult(int shardIndex, FirstResult result) {
        AtomicArray<ShardSearchFailure> shardFailures;
        this.firstResults.set(shardIndex, result);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("got first-phase result from {}", result != null ? result.shardTarget() : null);
        }
        if ((shardFailures = this.shardFailures) != null) {
            shardFailures.set(shardIndex, null);
        }
    }

    final void innerMoveToSecondPhase() throws Exception {
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            boolean hadOne = false;
            for (int i = 0; i < this.firstResults.length(); ++i) {
                SearchPhaseResult result = (SearchPhaseResult)this.firstResults.get(i);
                if (result == null) continue;
                if (hadOne) {
                    sb.append(",");
                } else {
                    hadOne = true;
                }
                sb.append(result.shardTarget());
            }
            this.logger.trace("Moving to second phase, based on results from: {} (cluster state version: {})", sb, this.clusterState.version());
        }
        this.moveToSecondPhase();
    }

    protected abstract void moveToSecondPhase() throws Exception;

    protected abstract String firstPhaseName();
}

