/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.bucket.nested.ReverseNestedAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class NestedAggregator
extends SingleBucketAggregator {
    private BitSetProducer parentFilter;
    private final Query childFilter;
    private DocIdSetIterator childDocs;
    private BitSet parentDocs;

    public NestedAggregator(String name, AggregatorFactories factories, ObjectMapper objectMapper, AggregationContext aggregationContext, Aggregator parentAggregator, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parentAggregator, pipelineAggregators, metaData);
        this.childFilter = objectMapper.nestedTypeFilter();
    }

    @Override
    public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        this.parentFilter = null;
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)ctx);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Weight weight = searcher.createNormalizedWeight(this.childFilter, false);
        Scorer childDocsScorer = weight.scorer(ctx);
        this.childDocs = childDocsScorer == null ? null : childDocsScorer.iterator();
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int parentDoc, long bucket) throws IOException {
                if (parentDoc == 0 || NestedAggregator.this.childDocs == null) {
                    return;
                }
                if (NestedAggregator.this.parentFilter == null) {
                    Query parentFilterNotCached = NestedAggregator.findClosestNestedPath(NestedAggregator.this.parent());
                    if (parentFilterNotCached == null) {
                        parentFilterNotCached = Queries.newNonNestedFilter();
                    }
                    NestedAggregator.this.parentFilter = NestedAggregator.this.context.searchContext().bitsetFilterCache().getBitSetProducer(parentFilterNotCached);
                    NestedAggregator.this.parentDocs = NestedAggregator.this.parentFilter.getBitSet(ctx);
                    if (NestedAggregator.this.parentDocs == null) {
                        NestedAggregator.this.childDocs = null;
                        return;
                    }
                }
                int prevParentDoc = NestedAggregator.this.parentDocs.prevSetBit(parentDoc - 1);
                int childDocId = NestedAggregator.this.childDocs.docID();
                if (childDocId <= prevParentDoc) {
                    childDocId = NestedAggregator.this.childDocs.advance(prevParentDoc + 1);
                }
                while (childDocId < parentDoc) {
                    NestedAggregator.this.collectBucket(sub, childDocId, bucket);
                    childDocId = NestedAggregator.this.childDocs.nextDoc();
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalNested(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalNested(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    private static Query findClosestNestedPath(Aggregator parent) {
        while (parent != null) {
            if (parent instanceof NestedAggregator) {
                return ((NestedAggregator)parent).childFilter;
            }
            if (parent instanceof ReverseNestedAggregator) {
                return ((ReverseNestedAggregator)parent).getParentFilter();
            }
            parent = parent.parent();
        }
        return null;
    }

    public static class Factory
    extends AggregatorFactory {
        private final String path;

        public Factory(String name, String path) {
            super(name, InternalNested.TYPE.name());
            this.path = path;
        }

        @Override
        public Aggregator createInternal(AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            if (!collectsFromSingleBucket) {
                return Factory.asMultiBucketAggregator(this, context, parent);
            }
            ObjectMapper objectMapper = context.searchContext().getObjectMapper(this.path);
            if (objectMapper == null) {
                return new Unmapped(this.name, context, parent, pipelineAggregators, metaData);
            }
            if (!objectMapper.nested().isNested()) {
                throw new AggregationExecutionException("[nested] nested path [" + this.path + "] is not nested");
            }
            return new NestedAggregator(this.name, this.factories, objectMapper, context, parent, pipelineAggregators, metaData);
        }

        private static final class Unmapped
        extends NonCollectingAggregator {
            public Unmapped(String name, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                super(name, context, parent, pipelineAggregators, metaData);
            }

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return new InternalNested(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
            }
        }
    }
}

