/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceService;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTag;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiDocTagImpl
extends CompositePsiElement
implements Constants,
PsiDocTag {
    private static final TokenSet TAG_VALUE_BIT_SET = TokenSet.create(DOC_TAG_VALUE_ELEMENT, DOC_METHOD_OR_FIELD_REF, DOC_PARAMETER_REF);
    private static final TokenSet VALUE_BIT_SET = TokenSet.orSet(TAG_VALUE_BIT_SET, TokenSet.create(DOC_TAG_VALUE_TOKEN, JAVA_CODE_REFERENCE, DOC_COMMENT_DATA, DOC_INLINE_TAG, DOC_REFERENCE_HOLDER));

    public PsiDocTagImpl() {
        super(DOC_TAG);
    }

    @Override
    public PsiDocComment getContainingComment() {
        return (PsiDocComment)this.getParent();
    }

    @Override
    public PsiElement getNameElement() {
        return this.findPsiChildByType(DOC_TAG_NAME);
    }

    @Override
    public PsiDocTagValue getValueElement() {
        return (PsiDocTagValue)this.findPsiChildByType(TAG_VALUE_BIT_SET);
    }

    @Override
    public PsiElement[] getDataElements() {
        return this.getChildrenAsPsiElements(VALUE_BIT_SET, PsiElement.ARRAY_FACTORY);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.getNameElement() == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "getName"));
            }
            return "";
        }
        String string = this.getNameElement().getText().substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameElement(), name);
        return this;
    }

    @Override
    public int getChildRole(ASTNode child) {
        assert (child.getTreeParent() == this) : child.getTreeParent();
        IElementType i = child.getElementType();
        if (i == DOC_TAG_NAME) {
            return 105;
        }
        if (i == JavaDocElementType.DOC_COMMENT || i == DOC_INLINE_TAG) {
            return 106;
        }
        if (i == DOC_COMMENT_LEADING_ASTERISKS) {
            return 107;
        }
        if (TAG_VALUE_BIT_SET.contains(i)) {
            return 242;
        }
        return 0;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/PsiDocTagImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitDocTag(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiDocTag:" + this.getNameElement().getText();
    }
}

