/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.VisitableURLClassLoader;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.tooling.internal.provider.PayloadClassLoaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonSidePayloadClassLoaderFactory
implements PayloadClassLoaderFactory {
    private final PayloadClassLoaderFactory delegate;
    private final CachedClasspathTransformer cachedClasspathTransformer;

    public DaemonSidePayloadClassLoaderFactory(PayloadClassLoaderFactory delegate, CachedClasspathTransformer cachedClasspathTransformer) {
        this.delegate = delegate;
        this.cachedClasspathTransformer = cachedClasspathTransformer;
    }

    @Override
    public ClassLoader getClassLoaderFor(ClassLoaderSpec spec, List<? extends ClassLoader> parents) {
        if (spec instanceof VisitableURLClassLoader.Spec) {
            VisitableURLClassLoader.Spec urlSpec = (VisitableURLClassLoader.Spec)spec;
            if (parents.size() != 1) {
                throw new IllegalStateException("Expected exactly one parent ClassLoader");
            }
            Collection<URL> cachedClassPathUrls = this.cachedClasspathTransformer.transform(urlSpec.getClasspath());
            return new VisitableURLClassLoader(parents.get(0), cachedClassPathUrls);
        }
        return this.delegate.getClassLoaderFor(spec, parents);
    }
}

