/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.tasks;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.internal.jacoco.AntJacocoReport;
import org.gradle.internal.jacoco.JacocoReportsContainerImpl;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.testing.jacoco.tasks.JacocoReportsContainer;

@Incubating
public class JacocoReport
extends JacocoBase
implements Reporting<JacocoReportsContainer> {
    private final JacocoReportsContainer reports = (JacocoReportsContainer)this.getInstantiator().newInstance(JacocoReportsContainerImpl.class, new Object[]{this});
    private FileCollection executionData;
    private FileCollection sourceDirectories;
    private FileCollection classDirectories;
    private FileCollection additionalClassDirs;
    private FileCollection additionalSourceDirs;

    public JacocoReport() {
        this.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task element) {
                return Iterables.all((Iterable)JacocoReport.this.getExecutionData(), (Predicate)new Predicate<File>(){

                    public boolean apply(File file) {
                        return file.exists();
                    }
                });
            }
        });
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected IsolatedAntBuilder getAntBuilder() {
        throw new UnsupportedOperationException();
    }

    @Nested
    public JacocoReportsContainer getReports() {
        return this.reports;
    }

    public JacocoReportsContainer reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public JacocoReportsContainer reports(Action<? super JacocoReportsContainer> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @InputFiles
    public FileCollection getExecutionData() {
        return this.executionData;
    }

    public void setExecutionData(FileCollection executionData) {
        this.executionData = executionData;
    }

    @InputFiles
    public FileCollection getSourceDirectories() {
        return this.sourceDirectories;
    }

    public void setSourceDirectories(FileCollection sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    @InputFiles
    public FileCollection getClassDirectories() {
        return this.classDirectories;
    }

    public void setClassDirectories(FileCollection classDirectories) {
        this.classDirectories = classDirectories;
    }

    @Optional
    @InputFiles
    public FileCollection getAdditionalClassDirs() {
        return this.additionalClassDirs;
    }

    public void setAdditionalClassDirs(FileCollection additionalClassDirs) {
        this.additionalClassDirs = additionalClassDirs;
    }

    @Optional
    @InputFiles
    public FileCollection getAdditionalSourceDirs() {
        return this.additionalSourceDirs;
    }

    public void setAdditionalSourceDirs(FileCollection additionalSourceDirs) {
        this.additionalSourceDirs = additionalSourceDirs;
    }

    @TaskAction
    public void generate() {
        Spec<File> fileExistsSpec = new Spec<File>(){

            public boolean isSatisfiedBy(File file) {
                return file.exists();
            }
        };
        new AntJacocoReport(this.getAntBuilder()).execute(this.getJacocoClasspath(), this.getProject().getName(), this.getAllClassDirs().filter((Spec)fileExistsSpec), this.getAllSourceDirs().filter((Spec)fileExistsSpec), this.getExecutionData(), this.getReports());
    }

    public void executionData(Object ... files) {
        this.executionData = this.executionData == null ? this.getProject().files(files) : this.executionData.plus((FileCollection)this.getProject().files(files));
    }

    public void executionData(Task ... tasks) {
        for (Task task : tasks) {
            final JacocoTaskExtension extension = (JacocoTaskExtension)task.getExtensions().findByType(JacocoTaskExtension.class);
            if (extension == null) continue;
            this.executionData(new Callable<File>(){

                @Override
                public File call() {
                    return extension.getDestinationFile();
                }
            });
            this.mustRunAfter(new Object[]{task});
        }
    }

    public void executionData(TaskCollection tasks) {
        tasks.all((Action)new Action<Task>(){

            public void execute(Task task) {
                JacocoReport.this.executionData(task);
            }
        });
    }

    @Internal
    public FileCollection getAllClassDirs() {
        FileCollection additionalDirs = this.getAdditionalClassDirs();
        if (additionalDirs == null) {
            return this.classDirectories;
        }
        return this.classDirectories.plus(this.getAdditionalClassDirs());
    }

    @Internal
    public FileCollection getAllSourceDirs() {
        FileCollection additionalDirs = this.getAdditionalSourceDirs();
        if (additionalDirs == null) {
            return this.sourceDirectories;
        }
        return this.sourceDirectories.plus(this.getAdditionalSourceDirs());
    }

    public void sourceSets(final SourceSet ... sourceSets) {
        this.getProject().afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                for (SourceSet sourceSet : sourceSets) {
                    if (JacocoReport.this.getSourceDirectories() == null) {
                        JacocoReport.this.setSourceDirectories((FileCollection)JacocoReport.this.getProject().files(new Object[]{sourceSet.getAllJava().getSrcDirs()}));
                    } else {
                        JacocoReport.this.setSourceDirectories(JacocoReport.this.getSourceDirectories().plus((FileCollection)JacocoReport.this.getProject().files(new Object[]{sourceSet.getAllJava().getSrcDirs()})));
                    }
                    if (JacocoReport.this.getClassDirectories() == null) {
                        JacocoReport.this.setClassDirectories((FileCollection)sourceSet.getOutput());
                        continue;
                    }
                    JacocoReport.this.setClassDirectories(JacocoReport.this.getClassDirectories().plus((FileCollection)sourceSet.getOutput()));
                }
            }
        });
    }

    public void additionalClassDirs(File ... dirs) {
        this.additionalClassDirs((FileCollection)this.getProject().files(new Object[]{Arrays.asList(dirs)}));
    }

    public void additionalClassDirs(FileCollection dirs) {
        this.additionalClassDirs = this.additionalClassDirs == null ? dirs : this.additionalClassDirs.plus(dirs);
    }

    public void additionalSourceDirs(File ... dirs) {
        this.additionalSourceDirs((FileCollection)this.getProject().files(new Object[]{Arrays.asList(dirs)}));
    }

    public void additionalSourceDirs(FileCollection dirs) {
        this.additionalSourceDirs = this.additionalSourceDirs == null ? dirs : this.additionalSourceDirs.plus(dirs);
    }
}

