/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.initialization.MixInLegacyTypesClassLoader;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.ClassLoaderFactory;
import org.gradle.internal.classloader.FilteringClassLoader;

public class DefaultClassLoaderRegistry
implements ClassLoaderRegistry {
    private final ClassLoader apiOnlyClassLoader;
    private final ClassLoader apiAndPluginsClassLoader;
    private final ClassLoader pluginsClassLoader;

    public DefaultClassLoaderRegistry(ClassPathRegistry classPathRegistry, ClassLoaderFactory classLoaderFactory) {
        ClassLoader runtimeClassLoader = this.getClass().getClassLoader();
        this.apiOnlyClassLoader = DefaultClassLoaderRegistry.restrictToGradleApi(runtimeClassLoader, classLoaderFactory);
        this.pluginsClassLoader = new MixInLegacyTypesClassLoader(runtimeClassLoader, classPathRegistry.getClassPath("GRADLE_EXTENSIONS"));
        this.apiAndPluginsClassLoader = DefaultClassLoaderRegistry.restrictToGradleApi(this.pluginsClassLoader, classLoaderFactory);
    }

    private static ClassLoader restrictToGradleApi(ClassLoader parent, ClassLoaderFactory classLoaderFactory) {
        FilteringClassLoader.Spec rootSpec = new FilteringClassLoader.Spec();
        rootSpec.allowPackage("org.gradle");
        rootSpec.allowResources("META-INF/gradle-plugins");
        rootSpec.allowPackage("org.apache.tools.ant");
        rootSpec.allowPackage("groovy");
        rootSpec.allowPackage("org.codehaus.groovy");
        rootSpec.allowPackage("groovyjarjarantlr");
        rootSpec.allowPackage("org.slf4j");
        rootSpec.allowPackage("org.apache.commons.logging");
        rootSpec.allowPackage("org.apache.log4j");
        rootSpec.allowPackage("javax.inject");
        FilteringClassLoader rootClassLoader = new FilteringClassLoader(parent, rootSpec);
        return new CachingClassLoader((ClassLoader)rootClassLoader);
    }

    public ClassLoader getRuntimeClassLoader() {
        return this.getClass().getClassLoader();
    }

    public ClassLoader getGradleApiClassLoader() {
        return this.apiAndPluginsClassLoader;
    }

    public ClassLoader getPluginsClassLoader() {
        return this.pluginsClassLoader;
    }

    public ClassLoader getGradleCoreApiClassLoader() {
        return this.apiOnlyClassLoader;
    }
}

