/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtilRt {
    public static final int MEGABYTE = 0x100000;
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, FileUtilRt.getUserFileSizeLimit());
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    public static final FileFilter ALL_FILES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return true;
        }
    };
    public static final FileFilter ALL_DIRECTORIES = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    protected static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20480];
        }
    };
    private static String ourCanonicalTempPathCache = null;

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
        }
        int index2 = fileName.lastIndexOf(46);
        if (index2 < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
            }
            return "";
        }
        String string = fileName.substring(index2 + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
        }
        return string;
    }

    @NotNull
    public static CharSequence getExtension(@NotNull CharSequence fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
        }
        int index2 = StringUtilRt.lastIndexOf(fileName, '.', 0, fileName.length());
        if (index2 < 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
            }
            return "";
        }
        CharSequence charSequence = fileName.subSequence(index2 + 1, fileName.length());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getExtension"));
        }
        return charSequence;
    }

    public static boolean extensionEquals(@NotNull String filePath, @NotNull String extension) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/util/io/FileUtilRt", "extensionEquals"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/util/io/FileUtilRt", "extensionEquals"));
        }
        int extLen = extension.length();
        if (extLen == 0) {
            int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            return filePath.indexOf(46, lastSlash + 1) == -1;
        }
        int extStart = filePath.length() - extLen;
        return extStart >= 1 && filePath.charAt(extStart - 1) == '.' && filePath.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        String string = FileUtilRt.toSystemDependentName(fileName, File.separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        return string;
    }

    @NotNull
    public static String toSystemDependentName(@NonNls @NotNull String fileName, char separatorChar) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        String string = fileName.replace('/', separatorChar).replace('\\', separatorChar);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemDependentName"));
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NonNls @NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/util/io/FileUtilRt", "toSystemIndependentName"));
        }
        String string = fileName.replace('\\', '/');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "toSystemIndependentName"));
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (!base.isDirectory() && (base = base.getParentFile()) == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath, filePath, File.separatorChar);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/util/io/FileUtilRt", "getRelativePath"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/util/io/FileUtilRt", "getRelativePath"));
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        CharComparingStrategy strategy;
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/util/io/FileUtilRt", "getRelativePath"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/util/io/FileUtilRt", "getRelativePath"));
        }
        basePath = FileUtilRt.ensureEnds(basePath, separator);
        if (caseSensitive ? basePath.equals(FileUtilRt.ensureEnds(filePath, separator)) : basePath.equalsIgnoreCase(FileUtilRt.ensureEnds(filePath, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        CharComparingStrategy charComparingStrategy = strategy = caseSensitive ? CharComparingStrategy.IDENTITY : CharComparingStrategy.CASE_INSENSITIVE;
        for (len = 0; len < filePath.length() && len < basePath.length() && strategy.charsEqual(filePath.charAt(len), basePath.charAt(len)); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    private static String ensureEnds(@NotNull String s, char endsWith) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/util/io/FileUtilRt", "ensureEnds"));
        }
        return StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/io/FileUtilRt", "getNameWithoutExtension"));
        }
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getNameWithoutExtension"));
        }
        return string;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        File file = FileUtilRt.createTempDirectory(prefix, suffix, true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        File dir = new File(FileUtilRt.getTempDirectory());
        File file = FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        File file = FileUtilRt.createTempDirectory(dir, prefix, suffix, true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        return file;
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, true);
        if (deleteOnExit) {
            FilesToDeleteHolder.ourFilesToDelete.add(file.getPath());
        }
        if (!file.isDirectory()) {
            throw new IOException("Cannot create directory: " + file);
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempDirectory"));
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File file = FileUtilRt.createTempFile(prefix, suffix, false);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File dir = new File(FileUtilRt.getTempDirectory());
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, true, deleteOnExit);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, true, true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create2) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File file = FileUtilRt.createTempFile(dir, prefix, suffix, create2, true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NonNls File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean create2, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, false);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        if (!create2 && !file.delete() && file.exists()) {
            throw new IOException("Cannot delete file: " + file);
        }
        File file2 = file;
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "createTempFile"));
        }
        return file2;
    }

    @NotNull
    private static File doCreateTempFile(@NotNull File dir, @NotNull @NonNls String prefix, @Nullable @NonNls String suffix, boolean isDirectory) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/util/io/FileUtilRt", "doCreateTempFile"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "doCreateTempFile"));
        }
        dir.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = new File(prefix).getName();
        int exceptionsCount = 0;
        int i = 0;
        while (true) {
            File file;
            try {
                boolean success;
                File f = FileUtilRt.calcName(dir, prefix, suffix, i);
                boolean bl = success = isDirectory ? f.mkdir() : f.createNewFile();
                if (!success) {
                    List<String> list2 = Arrays.asList(f.getParentFile().list());
                    throw new IOException("Unable to create temporary file " + f + "\nDirectory '" + f.getParentFile() + "' list (" + list2.size() + " children): " + list2);
                }
                file = FileUtilRt.normalizeFile(f);
            }
            catch (IOException e) {
                if (++exceptionsCount >= 100) {
                    throw e;
                }
                if (++i <= 2) continue;
                i = 2 + (int)(System.nanoTime() % 998L);
                continue;
            }
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "doCreateTempFile"));
            }
            return file;
        }
    }

    @NotNull
    private static File calcName(@NotNull File dir, @NotNull String prefix, @NotNull String suffix, int i) throws IOException {
        File f;
        String name;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/util/io/FileUtilRt", "calcName"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/openapi/util/io/FileUtilRt", "calcName"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/intellij/openapi/util/io/FileUtilRt", "calcName"));
        }
        if ((prefix = prefix + (i == 0 ? "" : Integer.valueOf(i))).endsWith(".") && suffix.startsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!(name = prefix + suffix).equals((f = new File(dir, name)).getName())) {
            throw new IOException("Unable to create temporary file " + f + " for name " + name);
        }
        File file = f;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "calcName"));
        }
        return file;
    }

    @NotNull
    private static File normalizeFile(@NotNull File temp) throws IOException {
        if (temp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "temp", "com/intellij/openapi/util/io/FileUtilRt", "normalizeFile"));
        }
        File canonical = temp.getCanonicalFile();
        File file = SystemInfoRt.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "normalizeFile"));
        }
        return file;
    }

    @NotNull
    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        String string = ourCanonicalTempPathCache;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getTempDirectory"));
        }
        return string;
    }

    @NotNull
    private static String calcCanonicalTempPath() {
        File file;
        block4: {
            String string;
            file = new File(System.getProperty("java.io.tmpdir"));
            try {
                String canonical = file.getCanonicalPath();
                if (SystemInfoRt.isWindows && canonical.contains(" ")) break block4;
                string = canonical;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "calcCanonicalTempPath"));
            }
            return string;
        }
        String string = file.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "calcCanonicalTempPath"));
        }
        return string;
    }

    public static void resetCanonicalTempPathCache(String tempPath) {
        ourCanonicalTempPathCache = tempPath;
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        File file = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        for (int i = 0; file.exists() && i < 5; ++i) {
            file = new File(FileUtilRt.getTempDirectory(), UUID.randomUUID().toString());
        }
        if (file.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        File file2 = FileUtilRt.normalizeFile(file);
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "generateRandomTemporaryPath"));
        }
        return file2;
    }

    public static void setExecutableAttribute(@NotNull String path, boolean executableFlag) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "setExecutableAttribute"));
        }
        try {
            File file = new File(path);
            if (!file.setExecutable(executableFlag) && file.canExecute() != executableFlag) {
                FileUtilRt.logger().warn("Can't set executable attribute of '" + path + "' to " + executableFlag);
            }
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        String string = FileUtilRt.loadFile(file, null, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        String string = FileUtilRt.loadFile(file, null, convertLineSeparators);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        String string = FileUtilRt.loadFile(file, encoding, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable @NonNls String encoding, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        String s = new String(FileUtilRt.loadFileText(file, encoding));
        String string = convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFile"));
        }
        return string;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
        }
        char[] cArray = FileUtilRt.loadFileText(file, (String)null);
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block4: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
            }
            FileInputStream stream2 = new FileInputStream(file);
            reader = encoding == null ? new InputStreamReader(stream2) : new InputStreamReader((InputStream)stream2, encoding);
            cArray = FileUtilRt.loadText(reader, (int)file.length());
            if (cArray != null) break block4;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @NotNull @NonNls Charset encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block5: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
            }
            if (encoding == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoding", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            cArray = FileUtilRt.loadText(reader, (int)file.length());
            if (cArray != null) break block5;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadFileText"));
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        int count;
        int n;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/FileUtilRt", "loadText"));
        }
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            if (chars == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadText"));
            }
            return chars;
        }
        char[] newChars = new char[count];
        System.arraycopy(chars, 0, newChars, 0, count);
        if (newChars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadText"));
        }
        return newChars;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        List<String> list2 = FileUtilRt.loadLines(file.getPath());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return list2;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file, @Nullable @NonNls String encoding) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        List<String> list2 = FileUtilRt.loadLines(file.getPath(), encoding);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return list2;
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        List<String> list2 = FileUtilRt.loadLines(path, null);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable @NonNls String encoding) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        FileInputStream stream2 = new FileInputStream(path);
        InputStreamReader in = encoding == null ? new InputStreamReader(stream2) : new InputStreamReader((InputStream)stream2, encoding);
        BufferedReader reader = new BufferedReader(in);
        List<String> list2 = FileUtilRt.loadLines(reader);
        reader.close();
        List<String> list3 = list2;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return list3;
        {
            catch (Throwable throwable) {
                reader.close();
                throw throwable;
            }
        }
        finally {
            ((InputStream)stream2).close();
        }
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadLines"));
        }
        return arrayList;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream2) throws IOException {
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileUtilRt.copy(stream2, buffer);
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        return byArray;
    }

    public static boolean isTooLarge(long len) {
        return len > (long)LARGE_FOR_CONTENT_LOADING;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream2, int length) throws IOException {
        int n;
        if (stream2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        if (length == 0) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream2.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "loadBytes"));
        }
        return bytes;
    }

    @Nullable
    public static File getParentFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "getParentFile"));
        }
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean delete(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "delete"));
        }
        if (NIOReflect.IS_AVAILABLE) {
            return FileUtilRt.deleteRecursivelyNIO(file);
        }
        return FileUtilRt.deleteRecursively(file);
    }

    protected static boolean deleteRecursivelyNIO(File file) {
        try {
            Object pathObject = NIOReflect.ourFileToPathMethod.invoke((Object)file, new Object[0]);
            NIOReflect.ourFilesWalkMethod.invoke(null, pathObject, NIOReflect.ourDeletionVisitor);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null || !NIOReflect.ourNoSuchFileExceptionClass.isInstance(cause)) {
                FileUtilRt.logger().info(e);
                return false;
            }
        }
        catch (Exception e) {
            FileUtilRt.logger().info(e);
            return false;
        }
        return true;
    }

    private static boolean deleteRecursively(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "deleteRecursively"));
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (FileUtilRt.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtilRt.deleteFile(file);
    }

    @Nullable
    public static <T, E extends Throwable> T doIOOperation(@NotNull RepeatableIOOperation<T, E> ioTask) throws E {
        if (ioTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioTask", "com/intellij/openapi/util/io/FileUtilRt", "doIOOperation"));
        }
        for (int i = 10; i > 0; --i) {
            T result2 = ioTask.execute(i == 1);
            if (result2 != null) {
                return result2;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean deleteFile(final @NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "deleteFile"));
        }
        Boolean result2 = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

            @Override
            public Boolean execute(boolean lastAttempt) {
                if (file.delete() || !file.exists()) {
                    return Boolean.TRUE;
                }
                if (lastAttempt) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        return Boolean.TRUE.equals(result2);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "ensureCanCreateFile"));
        }
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file)) {
            return false;
        }
        return FileUtilRt.delete(file);
    }

    public static boolean createIfNotExists(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "createIfNotExists"));
        }
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static boolean createParentDirs(@NotNull File file) {
        File parentFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/util/io/FileUtilRt", "createParentDirs"));
        }
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            return FileUtilRt.createDirectory(parentFile);
        }
        return true;
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/FileUtilRt", "createDirectory"));
        }
        return path.isDirectory() || path.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (fromFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromFile", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
        }
        if (toFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toFile", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
        }
        if (!FileUtilRt.ensureCanCreateFile(toFile)) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtilRt.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        long timeStamp = fromFile.lastModified();
        if (timeStamp < 0L) {
            FileUtilRt.logger().warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
        } else if (!toFile.setLastModified(timeStamp)) {
            FileUtilRt.logger().warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream2) throws IOException {
        block10: {
            int read;
            if (inputStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputStream", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
            }
            if (outputStream2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputStream", "com/intellij/openapi/util/io/FileUtilRt", "copy"));
            }
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream2 instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel = ((FileOutputStream)outputStream2).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                        break block10;
                    }
                    finally {
                        toChannel.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = FileUtilRt.getThreadLocalBuffer();
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream2.write(buffer, 0, read);
            }
        }
    }

    @NotNull
    public static byte[] getThreadLocalBuffer() {
        byte[] byArray = BUFFER.get();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/FileUtilRt", "getThreadLocalBuffer"));
        }
        return byArray;
    }

    public static int getUserFileSizeLimit() {
        try {
            return Integer.parseInt(System.getProperty("idea.max.intellisense.filesize")) * 1024;
        }
        catch (NumberFormatException e) {
            return 2560000;
        }
    }

    private static LoggerRt logger() {
        return LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilRt");
    }

    private static interface CharComparingStrategy {
        public static final CharComparingStrategy IDENTITY = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return ch1 == ch2;
            }
        };
        public static final CharComparingStrategy CASE_INSENSITIVE = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return StringUtilRt.charsEqualIgnoreCase(ch1, ch2);
            }
        };

        public boolean charsEqual(char var1, char var2);
    }

    public static interface RepeatableIOOperation<T, E extends Throwable> {
        @Nullable
        public T execute(boolean var1) throws E;
    }

    private static class FilesToDeleteHolder {
        private static final Queue<String> ourFilesToDelete = FilesToDeleteHolder.createFilesToDelete();

        private static Queue<String> createFilesToDelete() {
            final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>();
            Runtime.getRuntime().addShutdownHook(new Thread("FileUtil deleteOnExit"){

                @Override
                public void run() {
                    String name = (String)queue.poll();
                    while (name != null) {
                        FileUtilRt.delete(new File(name));
                        name = (String)queue.poll();
                    }
                }
            });
            return queue;
        }
    }

    protected static final class NIOReflect {
        static final boolean IS_AVAILABLE;
        private static Method ourFilesDeleteIfExistsMethod;
        private static Method ourFilesWalkMethod;
        private static Method ourFileToPathMethod;
        private static Method ourPathToFileMethod;
        private static Object ourDeletionVisitor;
        private static Class ourNoSuchFileExceptionClass;
        private static Class ourAccessDeniedExceptionClass;

        static {
            boolean initSuccess = false;
            try {
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Class<?> visitorClass = Class.forName("java.nio.file.FileVisitor");
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                ourNoSuchFileExceptionClass = Class.forName("java.nio.file.NoSuchFileException");
                ourAccessDeniedExceptionClass = Class.forName("java.nio.file.AccessDeniedException");
                ourFileToPathMethod = Class.forName("java.io.File").getMethod("toPath", new Class[0]);
                ourPathToFileMethod = pathClass.getMethod("toFile", new Class[0]);
                ourFilesWalkMethod = filesClass.getMethod("walkFileTree", pathClass, visitorClass);
                ourFilesDeleteIfExistsMethod = filesClass.getMethod("deleteIfExists", pathClass);
                final Object Result_Continue = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("CONTINUE").get(null);
                ourDeletionVisitor = Proxy.newProxyInstance(FileUtilRt.class.getClassLoader(), new Class[]{visitorClass}, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (args.length == 2) {
                            Object second = args[1];
                            if (second instanceof Throwable) {
                                throw (Throwable)second;
                            }
                            String methodName = method.getName();
                            if (("visitFile".equals(methodName) || "postVisitDirectory".equals(methodName)) && !this.performDelete(args[0])) {
                                throw new IOException("Failed to delete " + args[0]){

                                    @Override
                                    public synchronized Throwable fillInStackTrace() {
                                        return this;
                                    }
                                };
                            }
                        }
                        return Result_Continue;
                    }

                    private boolean performDelete(final @NotNull Object fileObject) {
                        if (fileObject == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/intellij/openapi/util/io/FileUtilRt$NIOReflect$1", "performDelete"));
                        }
                        Boolean result2 = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

                            @Override
                            public Boolean execute(boolean lastAttempt) {
                                block8: {
                                    try {
                                        ourFilesDeleteIfExistsMethod.invoke(null, fileObject);
                                        return Boolean.TRUE;
                                    }
                                    catch (InvocationTargetException e) {
                                        Throwable cause = e.getCause();
                                        if (!(cause instanceof IOException)) {
                                            return Boolean.FALSE;
                                        }
                                        if (!ourAccessDeniedExceptionClass.isInstance(cause)) break block8;
                                        try {
                                            File file = (File)ourPathToFileMethod.invoke(fileObject, new Object[0]);
                                            if (file == null) {
                                                return Boolean.FALSE;
                                            }
                                            if (file.delete() || !file.exists()) {
                                                return Boolean.TRUE;
                                            }
                                        }
                                        catch (Throwable ignored) {
                                            return Boolean.FALSE;
                                        }
                                    }
                                    catch (IllegalAccessException e) {
                                        return Boolean.FALSE;
                                    }
                                }
                                return lastAttempt ? Boolean.FALSE : null;
                            }
                        });
                        return Boolean.TRUE.equals(result2);
                    }
                });
                initSuccess = true;
            }
            catch (Throwable ignored) {
                FileUtilRt.logger().info("Was not able to detect NIO API");
                ourFileToPathMethod = null;
                ourFilesWalkMethod = null;
                ourFilesDeleteIfExistsMethod = null;
                ourDeletionVisitor = null;
                ourNoSuchFileExceptionClass = null;
            }
            IS_AVAILABLE = initSuccess;
        }
    }
}

