/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.filter;

import com.sun.star.beans.PropertyValue;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XServiceName;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.lib.uno.adapter.XOutputStreamToOutputStreamAdapter;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.xml.XExportFilter;
import com.sun.star.xml.sax.XAttributeList;
import com.sun.star.xml.sax.XDocumentHandler;
import com.sun.star.xml.sax.XLocator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.openoffice.da.comp.w2lcommon.filter.FilterDataParser;
import org.openoffice.da.comp.w2lcommon.filter.GraphicConverterImpl;
import org.openoffice.da.comp.w2lcommon.helper.MessageBox;
import org.w3c.dom.Document;
import writer2latex.api.Converter;
import writer2latex.api.ConverterFactory;
import writer2latex.api.OutputFile;
import writer2latex.util.Misc;
import writer2latex.util.SimpleDOMBuilder;

public abstract class ExportFilterBase
implements XExportFilter,
XServiceName,
XServiceInfo,
XDocumentHandler,
XTypeProvider {
    public static final String __serviceName = "";
    public static final String __implementationName = "";
    public String __displayName = "";
    private static XComponentContext xComponentContext = null;
    protected static XMultiServiceFactory xMSF;
    private SimpleDOMBuilder domBuilder = new SimpleDOMBuilder();
    private static XOutputStream xos;
    private static String sdMime;
    private static String sURL;
    private Object filterData;
    private XSimpleFileAccess2 sfa2;

    public ExportFilterBase(XComponentContext xComponentContext1) {
        xComponentContext = xComponentContext1;
        xMSF = null;
    }

    String getFileName(String origName) {
        String name = null;
        if (origName != null) {
            if (origName.equalsIgnoreCase("")) {
                name = "OutFile";
            } else {
                if (origName.lastIndexOf("/") >= 0) {
                    origName = origName.substring(origName.lastIndexOf("/") + 1, origName.length());
                }
                name = origName.lastIndexOf(".") >= 0 ? origName.substring(0, origName.lastIndexOf(".")) : origName;
            }
        } else {
            name = "OutFile";
        }
        return name;
    }

    public boolean exporter(PropertyValue[] aSourceData, String[] msUserData) throws RuntimeException {
        sURL = null;
        this.filterData = null;
        sdMime = msUserData[5];
        PropertyValue[] pValue = aSourceData;
        for (int i = 0; i < pValue.length; ++i) {
            try {
                if (pValue[i].Name.compareTo("OutputStream") == 0) {
                    xos = (XOutputStream)AnyConverter.toObject((Type)new Type(XOutputStream.class), (Object)pValue[i].Value);
                }
                if (pValue[i].Name.compareTo("URL") == 0) {
                    sURL = (String)AnyConverter.toObject((Type)new Type(String.class), (Object)pValue[i].Value);
                }
                if (pValue[i].Name.compareTo("FilterData") != 0) continue;
                this.filterData = pValue[i].Value;
                continue;
            }
            catch (IllegalArgumentException AnyExec) {
                System.err.println("\nIllegalArgumentException " + (Object)((Object)AnyExec));
            }
        }
        if (sURL == null) {
            sURL = "";
        }
        return true;
    }

    public void startDocument() {
    }

    public void endDocument() throws RuntimeException {
        try {
            this.convert(this.domBuilder.getDOM(), xos);
        }
        catch (IOException e) {
            MessageBox msgBox = new MessageBox(xComponentContext);
            msgBox.showMessage(this.__displayName + ": IO error in conversion", e.toString() + " at " + e.getStackTrace()[0].toString());
            throw new RuntimeException(e.getMessage());
        }
        catch (Exception e) {
            MessageBox msgBox = new MessageBox(xComponentContext);
            msgBox.showMessage(this.__displayName + ": Internal error in conversion", e.toString() + " at " + e.getStackTrace()[0].toString());
            throw new RuntimeException(this.__displayName + " Exception");
        }
    }

    public void startElement(String sTagName, XAttributeList xAttribs) {
        this.domBuilder.startElement(sTagName);
        short nLen = xAttribs.getLength();
        for (short i = 0; i < nLen; i = (short)(i + 1)) {
            this.domBuilder.setAttribute(xAttribs.getNameByIndex(i), xAttribs.getValueByIndex(i));
        }
    }

    public void endElement(String sTagName) {
        this.domBuilder.endElement();
    }

    public void characters(String sText) {
        this.domBuilder.characters(sText);
    }

    public void ignorableWhitespace(String str) {
    }

    public void processingInstruction(String aTarget, String aData) {
    }

    public void setDocumentLocator(XLocator xLocator) {
    }

    public void convert(Document dom, XOutputStream exportStream) throws RuntimeException, IOException {
        Converter converter = ConverterFactory.createConverter(sdMime);
        if (converter == null) {
            throw new RuntimeException("Failed to create converter to " + sdMime);
        }
        if (this.filterData != null) {
            FilterDataParser fdp = new FilterDataParser(xComponentContext);
            fdp.applyFilterData(this.filterData, converter);
        }
        converter.setGraphicConverter(new GraphicConverterImpl(xComponentContext));
        Iterator<OutputFile> docEnum = converter.convert(dom, Misc.makeFileName(this.getFileName(sURL)), true).iterator();
        if (docEnum.hasNext()) {
            XOutputStreamToOutputStreamAdapter newxos = new XOutputStreamToOutputStreamAdapter(exportStream);
            docEnum.next().write((OutputStream)newxos);
            newxos.flush();
            newxos.close();
            if (docEnum.hasNext() && sURL.startsWith("file:")) {
                this.sfa2 = null;
                try {
                    Object sfaObject = xComponentContext.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xComponentContext);
                    this.sfa2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)sfaObject);
                }
                catch (com.sun.star.uno.Exception e) {
                    // empty catch block
                }
                if (this.sfa2 != null) {
                    String sNewURL = null;
                    sNewURL = sURL.lastIndexOf("/") > -1 ? sURL.substring(0, sURL.lastIndexOf("/") + 1) : "";
                    while (docEnum.hasNext()) {
                        OutputFile docOut = docEnum.next();
                        String sFullFileName = Misc.makeHref(docOut.getFileName());
                        String sDirName = "";
                        String sFileName = sFullFileName;
                        int nSlash = sFileName.indexOf("/");
                        if (nSlash > -1) {
                            sDirName = sFileName.substring(0, nSlash);
                            sFileName = sFileName.substring(nSlash + 1);
                        }
                        try {
                            if (sDirName.length() > 0 && !this.sfa2.exists(sNewURL + sDirName)) {
                                this.sfa2.createFolder(sNewURL + sDirName);
                            }
                            Object xPipeObj = xMSF.createInstance("com.sun.star.io.Pipe");
                            XInputStream xInStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, (Object)xPipeObj);
                            XOutputStream xOutStream = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, (Object)xPipeObj);
                            XOutputStreamToOutputStreamAdapter outStream = new XOutputStreamToOutputStreamAdapter(xOutStream);
                            docOut.write((OutputStream)outStream);
                            outStream.flush();
                            outStream.close();
                            xOutStream.closeOutput();
                            this.sfa2.writeFile(sNewURL + sFullFileName, xInStream);
                        }
                        catch (Throwable e) {
                            MessageBox msgBox = new MessageBox(xComponentContext);
                            msgBox.showMessage(this.__displayName + ": Error writing files", e.toString() + " at " + e.getStackTrace()[0].toString());
                        }
                    }
                }
            }
        } else {
            MessageBox msgBox = new MessageBox(xComponentContext);
            msgBox.showMessage(this.__displayName + ": Conversion failed", "Internal error");
        }
    }

    public Type[] getTypes() {
        Type[] typeReturn = new Type[]{};
        try {
            typeReturn = new Type[]{new Type(XTypeProvider.class), new Type(XExportFilter.class), new Type(XServiceName.class), new Type(XServiceInfo.class)};
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeReturn;
    }

    public byte[] getImplementationId() {
        byte[] byteReturn = new byte[]{};
        byteReturn = new String("" + this.hashCode()).getBytes();
        return byteReturn;
    }

    public String getServiceName() {
        return "";
    }

    public boolean supportsService(String stringServiceName) {
        return stringServiceName.equals("");
    }

    public String getImplementationName() {
        return "";
    }

    public String[] getSupportedServiceNames() {
        String[] stringSupportedServiceNames = new String[]{""};
        return stringSupportedServiceNames;
    }

    static {
        xos = null;
        sdMime = null;
        sURL = "";
    }
}

