=begin
  keyfile.rb - Sample for GLib::KeyFile

  Copyright (C) 2006 Ruby-GNOME2 Project Team
  This program is licenced under the same licence as Ruby-GNOME2.

  $Id: keyfile.rb,v 1.2 2006/12/23 17:43:03 mutoh Exp $
=end

require 'glib2'

$KCODE = "U"

#
# Create a GLib::KeyFile
#
kf = GLib::KeyFile.new
kf.set_value("Group 1", "value", "Hello World")
kf.set_comment("Group 1", nil, "This file is generated by keyfile.rb")
kf.set_string("Group 1", "string", "Hello World\nRuby-GNOME2") 
kf.set_locale_string("Group 1", "locale_string", "ja", "こんにちわ世界")
kf.set_locale_string("Group 1", "locale_string", "en", "Hello World")
kf.set_boolean("Group 1", "boolean", true)
kf.set_integer("Group 1", "integer", 1)
kf.set_double("Group 1", "double", 1.0)
kf.set_string_list("Group 2", "string_list", ["foo", "bar"])
kf.set_locale_string_list("Group 2", "locale_string_list", "ja", ["こんにちわ", "世界"])
kf.set_locale_string_list("Group 2", "locale_string_list", "en", ["Hellow", "World"])
kf.set_boolean_list("Group 2", "boolean_list", [true, false])
kf.set_integer_list("Group 2", "integer_list", [1, 2, 3])
kf.set_double_list("Group 2", "double_list", [1.2, 1.3, 1.45])
kf.set_comment("Group 2", "string_list", "comment of string_list")

# Save as "keyfile.ini"
File.open("keyfile.ini", "w") do |out|
  out.write kf.to_data
end

#kf.remove_comment("Group 2", "string_list")
#kf.remove_key("Group 2", "string_list")
#kf.remove_group("Group 2")

#
# Load from "keyfile.ini"
#
kf2 = GLib::KeyFile.new
kf2.load_from_file("keyfile.ini")

puts "Group 1: value = #{kf2.get_value("Group 1", "value")}"
puts "Group 1: string = #{kf2.get_string("Group 1", "string")}" 
puts "Group 1: locale_string[ja] = #{kf2.get_locale_string("Group 1", "locale_string", "ja")}"
puts "Group 1: locale_string[en] = #{kf2.get_locale_string("Group 1", "locale_string", "en")}"
puts "Group 1: boolean = #{kf2.get_boolean("Group 1", "boolean")}"
puts "Group 1: integer = #{kf2.get_integer("Group 1", "integer")}"
puts "Group 1: double = #{kf2.get_double("Group 1", "double")}"
puts "Group 2: string_list = #{kf2.get_string_list("Group 2", "string_list").inspect}"
puts "Group 2: locale_string_list[ja] = #{kf2.get_locale_string_list("Group 2", "locale_string_list", "ja").inspect}"
puts "Group 2: locale_string_list[en] = #{kf2.get_locale_string_list("Group 2", "locale_string_list", "en").inspect}"
puts "Group 2: boolean_list = #{kf2.get_boolean_list("Group 2", "boolean_list").inspect}"
puts "Group 2: integer_list = #{kf2.get_integer_list("Group 2", "integer_list").inspect}"
puts "Group 2: double_list = #{kf2.get_double_list("Group 2", "double_list").inspect}"
puts "Group 2: comment = #{kf2.get_comment("Group 2", "string_list")}"
