/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.sftp.PacketType;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPPacket;

public final class Response
extends SFTPPacket<Response> {
    private final int protocolVersion;
    private final PacketType type;
    private final long reqID;

    public Response(Buffer<Response> pk, int protocolVersion) throws SFTPException {
        super(pk);
        this.protocolVersion = protocolVersion;
        this.type = this.readType();
        try {
            this.reqID = this.readUInt32();
        }
        catch (Buffer.BufferException be) {
            throw new SFTPException(be);
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getRequestID() {
        return this.reqID;
    }

    public PacketType getType() {
        return this.type;
    }

    public StatusCode readStatusCode() throws SFTPException {
        try {
            return StatusCode.fromInt(this.readUInt32AsInt());
        }
        catch (Buffer.BufferException be) {
            throw new SFTPException(be);
        }
    }

    public Response ensurePacketTypeIs(PacketType pt) throws SFTPException {
        if (this.getType() != pt) {
            if (this.getType() == PacketType.STATUS) {
                this.error(this.readStatusCode());
            } else {
                throw new SFTPException("Unexpected packet " + (Object)((Object)this.getType()));
            }
        }
        return this;
    }

    public Response ensureStatusPacketIsOK() throws SFTPException {
        return this.ensurePacketTypeIs(PacketType.STATUS).ensureStatusIs(StatusCode.OK);
    }

    public Response ensureStatusIs(StatusCode acceptable) throws SFTPException {
        StatusCode sc = this.readStatusCode();
        if (sc != acceptable) {
            this.error(sc);
        }
        return this;
    }

    protected String error(StatusCode sc) throws SFTPException {
        try {
            throw new SFTPException(sc, this.protocolVersion < 3 ? sc.toString() : this.readString());
        }
        catch (Buffer.BufferException be) {
            throw new SFTPException(be);
        }
    }

    public static enum StatusCode {
        UNKNOWN(-1),
        OK(0),
        EOF(1),
        NO_SUCH_FILE(2),
        PERMISSION_DENIED(3),
        FAILURE(4),
        BAD_MESSAGE(5),
        NO_CONNECTION(6),
        CONNECITON_LOST(7),
        OP_UNSUPPORTED(8);

        private final int code;

        public static StatusCode fromInt(int code) {
            for (StatusCode s : StatusCode.values()) {
                if (s.code != code) continue;
                return s;
            }
            return UNKNOWN;
        }

        private StatusCode(int code) {
            this.code = code;
        }
    }
}

