/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server.system;

import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class Histogram {
    private static final String LIVE_OBJECTS_OPTION = "-live";
    private static final String ALL_OBJECTS_OPTION = "-all";
    private static final String VIRTUAL_MACHINE_CLASS = "com.sun.tools.attach.VirtualMachine";
    private static final String HS_VIRTUAL_MACHINE_CLASS = "sun.tools.attach.HotSpotVirtualMachine";
    private static final String VIRTUAL_MACHINE_ATTACH_METHOD = "attach";
    private static final String VIRTUAL_MACHINE_HEAPHISTO_METHOD = "heapHisto";
    private static String selfPid;
    private static Method vmAttach;
    private static Method vmHisto;
    private static Object virtualMachine;
    private static Boolean initialized;

    public static boolean isAvailable() {
        if (initialized != null) {
            return initialized;
        }
        initialized = Histogram.initialize();
        return initialized;
    }

    public static InputStream getRawHistogram() {
        try {
            Object object;
            if (virtualMachine == null) {
                virtualMachine = vmAttach.invoke(null, selfPid);
            }
            if ((object = vmHisto.invoke(virtualMachine, new Object[]{new Object[]{ALL_OBJECTS_OPTION}})) instanceof InputStream) {
                return (InputStream)object;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return null;
    }

    private static ClassLoader getToolsJar() {
        File file = Histogram.getJavaHome();
        File file2 = new File(file, "lib/tools.jar");
        if (file2.exists() && file2.isFile()) {
            try {
                return new URLClassLoader(new URL[]{file2.toURI().toURL()});
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    private static File getJavaHome() {
        File file = new File(System.getProperty("java.home"));
        if ("jre".equals(file.getName())) {
            file = file.getParentFile();
        }
        return file;
    }

    private static boolean initialize() {
        Object object;
        try {
            ClassLoader classLoader = null;
            try {
                object = Class.forName(VIRTUAL_MACHINE_CLASS);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classLoader = Histogram.getToolsJar();
                if (classLoader == null) {
                    return false;
                }
                object = Class.forName(VIRTUAL_MACHINE_CLASS, true, classLoader);
            }
            Class<?> clazz = classLoader == null ? Class.forName(HS_VIRTUAL_MACHINE_CLASS) : Class.forName(HS_VIRTUAL_MACHINE_CLASS, true, classLoader);
            vmAttach = ((Class)object).getMethod(VIRTUAL_MACHINE_ATTACH_METHOD, String.class);
            vmHisto = clazz.getMethod(VIRTUAL_MACHINE_HEAPHISTO_METHOD, Object[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        object = ManagementFactory.getRuntimeMXBean().getName();
        selfPid = ((String)object).substring(0, ((String)object).indexOf(64));
        return true;
    }
}

