/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.tools.ico.impl;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;
import net.sourceforge.jnlp.tools.ico.impl.IcoException;
import net.sourceforge.jnlp.tools.ico.impl.IcoHeaderEntry;

public class IcoHeader {
    private final int reserved;
    private final int type;
    final int countOfIcons;
    final List<IcoHeaderEntry> entries;
    private final ByteOrder originalOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcoHeader(ImageInputStream src) throws IOException, IcoException {
        this.originalOrder = src.getByteOrder();
        try {
            src.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            this.reserved = src.readUnsignedShort();
            this.type = src.readUnsignedShort();
            this.isIco();
            this.countOfIcons = src.readUnsignedShort();
            this.entries = new ArrayList<IcoHeaderEntry>(this.countOfIcons);
            for (int x = 0; x < this.countOfIcons; ++x) {
                this.entries.add(new IcoHeaderEntry(src));
            }
        }
        finally {
            src.setByteOrder(this.originalOrder);
        }
    }

    private void isIco() throws IcoException {
        if (this.reserved != 0 || this.type != 1) {
            throw new IcoException("Invalid header. Expected 0 and 1, got " + this.reserved + " and " + this.type);
        }
    }

    public List<IcoHeaderEntry> getEntries() {
        return this.entries;
    }

    public int getCountOfIcons() {
        return this.countOfIcons;
    }
}

