/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.java2d.opengl.OGLContext;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;
import sun.misc.ThreadGroupUtils;

public class OGLRenderQueue
extends RenderQueue {
    private static OGLRenderQueue theInstance;
    private final QueueFlusher flusher = AccessController.doPrivileged(new PrivilegedAction<QueueFlusher>(){

        @Override
        public QueueFlusher run() {
            return new QueueFlusher(ThreadGroupUtils.getRootThreadGroup());
        }
    });

    private OGLRenderQueue() {
    }

    public static synchronized OGLRenderQueue getInstance() {
        if (theInstance == null) {
            theInstance = new OGLRenderQueue();
        }
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync() {
        if (theInstance != null) {
            theInstance.lock();
            try {
                theInstance.ensureCapacity(4);
                theInstance.getBuffer().putInt(76);
                theInstance.flushNow();
            }
            finally {
                theInstance.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeGraphicsConfig(long pConfigInfo) {
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.setScratchSurface(pConfigInfo);
            RenderBuffer buf = rq.getBuffer();
            rq.ensureCapacityAndAlignment(12, 4);
            buf.putInt(74);
            buf.putLong(pConfigInfo);
            rq.flushNow();
        }
        finally {
            rq.unlock();
        }
    }

    public static boolean isQueueFlusherThread() {
        return Thread.currentThread() == OGLRenderQueue.getInstance().flusher;
    }

    @Override
    public void flushNow() {
        try {
            this.flusher.flushNow();
        }
        catch (Exception e) {
            System.err.println("exception in flushNow:");
            e.printStackTrace();
        }
    }

    @Override
    public void flushAndInvokeNow(Runnable r) {
        try {
            this.flusher.flushAndInvokeNow(r);
        }
        catch (Exception e) {
            System.err.println("exception in flushAndInvokeNow:");
            e.printStackTrace();
        }
    }

    private native void flushBuffer(long var1, int var3);

    private void flushBuffer() {
        int limit = this.buf.position();
        if (limit > 0) {
            this.flushBuffer(this.buf.getAddress(), limit);
        }
        this.buf.clear();
        this.refSet.clear();
    }

    private class QueueFlusher
    extends Thread {
        private boolean needsFlush;
        private Runnable task;
        private Error error;

        public QueueFlusher(ThreadGroup threadGroup) {
            super(threadGroup, "Java2D Queue Flusher");
            this.setDaemon(true);
            this.setPriority(10);
            this.start();
        }

        public synchronized void flushNow() {
            this.needsFlush = true;
            this.notify();
            while (this.needsFlush) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.error != null) {
                throw this.error;
            }
        }

        public synchronized void flushAndInvokeNow(Runnable task) {
            this.task = task;
            this.flushNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            boolean timedOut = false;
            while (true) {
                if (!this.needsFlush) {
                    try {
                        timedOut = false;
                        this.wait(100L);
                        if (this.needsFlush || !(timedOut = OGLRenderQueue.this.tryLock())) continue;
                        if (OGLRenderQueue.this.buf.position() > 0) {
                            this.needsFlush = true;
                            continue;
                        }
                        OGLRenderQueue.this.unlock();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    this.error = null;
                    OGLRenderQueue.this.flushBuffer();
                    if (this.task == null) continue;
                    this.task.run();
                    continue;
                }
                catch (Error e) {
                    this.error = e;
                    continue;
                }
                catch (Exception x) {
                    System.err.println("exception in QueueFlusher:");
                    x.printStackTrace();
                    continue;
                }
                finally {
                    if (timedOut) {
                        OGLRenderQueue.this.unlock();
                    }
                    this.task = null;
                    this.needsFlush = false;
                    this.notify();
                    continue;
                }
                break;
            }
        }
    }
}

