/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import com.google.common.collect.Maps;
import com.google.common.hash.HashCode;
import java.util.HashMap;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassFilesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;

class DefaultJarSnapshotter {
    private final Hasher hasher;
    private final ClassDependenciesAnalyzer analyzer;

    public DefaultJarSnapshotter(Hasher hasher, ClassDependenciesAnalyzer analyzer) {
        this.hasher = hasher;
        this.analyzer = analyzer;
    }

    public JarSnapshot createSnapshot(HashCode hash, JarArchive jarArchive) {
        return this.createSnapshot(hash, jarArchive.contents, new ClassFilesAnalyzer(this.analyzer));
    }

    JarSnapshot createSnapshot(HashCode hash, FileTree classes, final ClassFilesAnalyzer analyzer) {
        final HashMap hashes = Maps.newHashMap();
        classes.visit(new FileVisitor(){

            public void visitDir(FileVisitDetails dirDetails) {
            }

            public void visitFile(FileVisitDetails fileDetails) {
                analyzer.visitFile(fileDetails);
                String className = fileDetails.getPath().replaceAll("/", ".").replaceAll("\\.class$", "");
                HashCode classHash = DefaultJarSnapshotter.this.hasher.hash(fileDetails.getFile());
                hashes.put(className, classHash);
            }
        });
        return new JarSnapshot(new JarSnapshotData(hash, hashes, analyzer.getAnalysis()));
    }
}

