/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.Serializable;
import java.util.Arrays;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.VCallNode;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.DummyDynamicScope;

public class StaticScope
implements Serializable {
    private static final long serialVersionUID = 3423852552352498148L;
    protected final StaticScope enclosingScope;
    private transient RubyModule cref = null;
    private StaticScope previousCRefScope = null;
    private String[] variableNames;
    private boolean[] namedCaptures;
    private Signature signature;
    private String file;
    private DynamicScope dummyScope;
    protected IRScopeType scopeType;
    private static final String[] NO_NAMES = new String[0];
    private Type type;
    private boolean isBlockOrEval;
    private boolean isArgumentScope;
    private long commandArgumentStack;
    private IRScope irScope;
    private RubyModule overlayModule;

    protected StaticScope(Type type2, StaticScope enclosingScope, String file2) {
        this(type2, enclosingScope, NO_NAMES);
        this.file = file2;
    }

    protected StaticScope(Type type2, StaticScope enclosingScope) {
        this(type2, enclosingScope, NO_NAMES);
    }

    protected StaticScope(Type type2, StaticScope enclosingScope, String[] names2) {
        assert (names2 != null) : "names is not null";
        assert (StaticScope.namesAreInterned(names2));
        this.enclosingScope = enclosingScope;
        this.variableNames = names2;
        this.type = type2;
        this.irScope = null;
        this.isBlockOrEval = type2 != Type.LOCAL;
        this.isArgumentScope = !this.isBlockOrEval;
    }

    public IRScope getIRScope() {
        return this.irScope;
    }

    public IRScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(IRScopeType scopeType) {
        this.scopeType = scopeType;
    }

    public void setIRScope(IRScope irScope) {
        this.irScope = irScope;
        this.scopeType = irScope.getScopeType();
    }

    private static boolean namesAreInterned(String[] names2) {
        for (String name2 : names2) {
            if (name2 == name2.intern()) continue;
            return false;
        }
        return true;
    }

    public int addVariableThisScope(String name2) {
        if (name2.equals("_$0")) {
            return -1;
        }
        int slot = this.exists(name2);
        if (slot >= 0) {
            return slot;
        }
        this.growVariableNames(name2);
        return this.variableNames.length - 1;
    }

    public int addNamedCaptureVariable(String name2) {
        int index2 = this.addVariableThisScope(name2);
        this.growNamedCaptures(index2);
        return index2;
    }

    public int addVariable(String name2) {
        int slot = this.isDefined(name2);
        if (slot >= 0) {
            return slot;
        }
        this.growVariableNames(name2);
        return this.variableNames.length - 1;
    }

    public String[] getVariables() {
        return this.variableNames;
    }

    public int getNumberOfVariables() {
        return this.variableNames.length;
    }

    public void setVariables(String[] names2) {
        assert (names2 != null) : "names is not null";
        assert (StaticScope.namesAreInterned(names2));
        this.variableNames = new String[names2.length];
        System.arraycopy(names2, 0, this.variableNames, 0, names2.length);
    }

    public IRubyObject getConstantDefined(String internedName) {
        IRubyObject result2 = this.cref.fetchConstant(internedName);
        if (result2 != null) {
            return result2;
        }
        return this.previousCRefScope == null ? null : this.previousCRefScope.getConstantDefinedNoObject(internedName);
    }

    public IRubyObject getConstantDefinedNoObject(String internedName) {
        if (this.previousCRefScope == null) {
            return null;
        }
        return this.getConstantDefined(internedName);
    }

    public IRubyObject getConstant(String internedName) {
        IRubyObject result2 = this.getConstantInner(internedName);
        return result2 == null ? this.cref.getConstantNoConstMissing(internedName) : result2;
    }

    public IRubyObject getConstantInner(String internedName) {
        IRubyObject result2 = this.cref.fetchConstant(internedName);
        if (result2 != null) {
            return result2 == RubyObject.UNDEF ? this.cref.resolveUndefConstant(internedName) : result2;
        }
        return this.previousCRefScope == null ? null : this.previousCRefScope.getConstantInnerNoObject(internedName);
    }

    private IRubyObject getConstantInnerNoObject(String internedName) {
        if (this.previousCRefScope == null) {
            return null;
        }
        return this.getConstantInner(internedName);
    }

    public StaticScope getEnclosingScope() {
        return this.enclosingScope;
    }

    public int exists(String name2) {
        return this.findVariableName(name2);
    }

    private int findVariableName(String name2) {
        for (int i2 = 0; i2 < this.variableNames.length; ++i2) {
            if (name2 != this.variableNames[i2]) continue;
            return i2;
        }
        return -1;
    }

    public int isDefined(String name2) {
        return this.isDefined(name2, 0);
    }

    public AssignableNode assign(ISourcePosition position, String name2, Node value2) {
        return this.assign(position, name2, value2, this, 0);
    }

    public String[] getAllNamesInScope() {
        String[] names2 = this.getVariables();
        if (this.isBlockOrEval) {
            String[] ourVariables = names2;
            String[] variables = this.enclosingScope.getAllNamesInScope();
            names2 = new String[variables.length + ourVariables.length];
            System.arraycopy(variables, 0, names2, 0, variables.length);
            System.arraycopy(ourVariables, 0, names2, variables.length, ourVariables.length);
        }
        return names2;
    }

    public int isDefined(String name2, int depth) {
        if (this.isBlockOrEval) {
            int slot = this.exists(name2);
            if (slot >= 0) {
                return depth << 16 | slot;
            }
            return this.enclosingScope.isDefined(name2, depth + 1);
        }
        return depth << 16 | this.exists(name2);
    }

    public AssignableNode addAssign(ISourcePosition position, String name2, Node value2) {
        int slot = this.addVariable(name2);
        return new DAsgnNode(position, name2, slot, value2);
    }

    public AssignableNode assign(ISourcePosition position, String name2, Node value2, StaticScope topScope, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            return this.isBlockOrEval ? new DAsgnNode(position, name2, depth << 16 | slot, value2) : new LocalAsgnNode(position, name2, depth << 16 | slot, value2);
        }
        if (!this.isBlockOrEval && topScope == this) {
            slot = this.addVariable(name2);
            return new LocalAsgnNode(position, name2, slot, value2);
        }
        return this.isBlockOrEval ? this.enclosingScope.assign(position, name2, value2, topScope, depth + 1) : topScope.addAssign(position, name2, value2);
    }

    public Node declare(ISourcePosition position, String name2, int depth) {
        int slot = this.exists(name2);
        if (slot >= 0) {
            return this.isBlockOrEval ? new DVarNode(position, depth << 16 | slot, name2) : new LocalVarNode(position, depth << 16 | slot, name2);
        }
        return this.isBlockOrEval ? this.enclosingScope.declare(position, name2, depth + 1) : new VCallNode(position, name2);
    }

    public Node declare(ISourcePosition position, String name2) {
        return this.declare(position, name2, 0);
    }

    public StaticScope getLocalScope() {
        return this.type != Type.BLOCK ? this : this.enclosingScope.getLocalScope();
    }

    public RubyModule getModule() {
        return this.cref;
    }

    public StaticScope getPreviousCRefScope() {
        return this.previousCRefScope;
    }

    public void setPreviousCRefScope(StaticScope crefScope) {
        this.previousCRefScope = crefScope;
    }

    public void setModule(RubyModule module) {
        this.cref = module;
        for (StaticScope scope = this.getEnclosingScope(); scope != null; scope = scope.getEnclosingScope()) {
            if (scope.cref == null) continue;
            this.previousCRefScope = scope;
            return;
        }
    }

    public RubyModule determineModule() {
        if (this.cref == null) {
            this.cref = this.getEnclosingScope().determineModule();
            assert (this.cref != null) : "CRef is always created before determine happens";
            this.previousCRefScope = this.getEnclosingScope().previousCRefScope;
        }
        return this.cref;
    }

    public boolean isBlockScope() {
        return this.isBlockOrEval;
    }

    public boolean isArgumentScope() {
        return this.isArgumentScope;
    }

    public void makeArgumentScope() {
        this.isArgumentScope = true;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public DynamicScope getDummyScope() {
        return this.dummyScope == null ? (this.dummyScope = new DummyDynamicScope(this)) : this.dummyScope;
    }

    public void setCommandArgumentStack(long commandArgumentStack) {
        this.commandArgumentStack = commandArgumentStack;
    }

    public long getCommandArgumentStack() {
        return this.commandArgumentStack;
    }

    private void growVariableNames(String name2) {
        assert (name2 == name2.intern());
        String[] newVariableNames = new String[this.variableNames.length + 1];
        System.arraycopy(this.variableNames, 0, newVariableNames, 0, this.variableNames.length);
        this.variableNames = newVariableNames;
        this.variableNames[this.variableNames.length - 1] = name2;
    }

    private void growNamedCaptures(int index2) {
        boolean[] newNamedCaptures;
        boolean[] namedCaptures = this.namedCaptures;
        if (namedCaptures != null) {
            newNamedCaptures = new boolean[Math.max(index2 + 1, namedCaptures.length)];
            System.arraycopy(namedCaptures, 0, newNamedCaptures, 0, namedCaptures.length);
        } else {
            newNamedCaptures = new boolean[index2 + 1];
        }
        newNamedCaptures[index2] = true;
        this.namedCaptures = newNamedCaptures;
    }

    public boolean isNamedCapture(int index2) {
        boolean[] namedCaptures = this.namedCaptures;
        return namedCaptures != null && index2 < namedCaptures.length && namedCaptures[index2];
    }

    public String toString() {
        return "StaticScope(" + (Object)((Object)this.type) + "):" + Arrays.toString(this.variableNames);
    }

    public Type getType() {
        return this.type;
    }

    public String getFile() {
        return this.file;
    }

    public StaticScope duplicate() {
        StaticScope dupe = new StaticScope(this.type, this.enclosingScope, this.variableNames == null ? NO_NAMES : this.variableNames);
        if (this.irScope != null) {
            dupe.setIRScope(this.irScope);
        }
        dupe.setScopeType(this.scopeType);
        dupe.setPreviousCRefScope(this.previousCRefScope);
        dupe.setModule(this.cref);
        dupe.setSignature(this.signature);
        return dupe;
    }

    public RubyModule getOverlayModuleForRead() {
        return this.overlayModule;
    }

    public RubyModule getOverlayModuleForWrite(ThreadContext context) {
        RubyModule omod = this.overlayModule;
        if (omod == null) {
            this.overlayModule = omod = RubyModule.newModule(context.runtime);
        }
        return omod;
    }

    public static enum Type {
        LOCAL,
        BLOCK,
        EVAL;


        public static Type fromOrdinal(int value2) {
            return value2 < 0 || value2 >= Type.values().length ? null : Type.values()[value2];
        }
    }
}

