/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.relation;

import com.baselet.control.basics.geom.Point;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.enums.Direction;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.CursorOwn;
import com.baselet.element.NewGridElement;
import com.baselet.element.UndoInformation;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.facet.common.LayerFacet;
import com.baselet.element.relation.facet.RelationLineTypeFacet;
import com.baselet.element.relation.facet.SettingsRelation;
import com.baselet.element.relation.helper.RelationPointHandler;
import com.baselet.element.relation.helper.RelationPointHolder;
import com.baselet.element.relation.helper.RelationPointList;
import com.baselet.element.relation.helper.RelationSelection;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.PointDoubleIndexed;
import com.baselet.element.sticking.Stickable;
import com.baselet.element.sticking.StickableMap;
import com.baselet.element.sticking.polygon.NoStickingPolygonGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Relation
extends NewGridElement
implements Stickable,
RelationPointHolder {
    private RelationPointHandler relationPoints;

    @Override
    public ElementId getId() {
        return ElementId.Relation;
    }

    @Override
    protected void drawCommonContent(PropertiesParserState state) {
        state.setStickingPolygonGenerator(NoStickingPolygonGenerator.INSTANCE);
    }

    @Override
    protected void resetAndDrawMetaDrawerContent(DrawHandler drawer) {
        drawer.clearCache();
        drawer.setBackgroundColor(ColorOwn.SELECTION_BG);
        if (SharedConfig.getInstance().isDev_mode()) {
            drawer.setForegroundColor(ColorOwn.TRANSPARENT);
            drawer.drawRectangle(0.0, 0.0, this.getRealSize().getWidth(), this.getRealSize().getHeight());
            drawer.setBackgroundColor(ColorOwn.GREEN.transparency(ColorOwn.Transparency.BACKGROUND));
            this.relationPoints.drawSelectionSpace(drawer);
        }
        drawer.setForegroundColor(ColorOwn.SELECTION_FG);
        this.relationPoints.drawCirclesAndDragBox(drawer);
    }

    @Override
    public void setAdditionalAttributes(String additionalAttributes) {
        super.setAdditionalAttributes(additionalAttributes);
        RelationPointList pointList = new RelationPointList();
        String[] split = additionalAttributes.split(";");
        int i = 0;
        while (i < split.length) {
            pointList.add(Double.valueOf(split[i]), Double.valueOf(split[i + 1]));
            i += 2;
        }
        this.relationPoints = new RelationPointHandler(this, pointList);
        if (this.getHandler().isInitialized()) {
            this.relationPoints.resizeRectAndReposPoints();
        }
    }

    @Override
    public String getAdditionalAttributes() {
        return this.relationPoints.toAdditionalAttributesString();
    }

    @Override
    public void drag(Collection<Direction> resizeDirection, int diffX, int diffY, Point mousePosBeforeDragRelative, boolean isShiftKeyDown, boolean firstDrag, StickableMap stickables, boolean undoable) {
        String oldAddAttr = this.getAdditionalAttributes();
        Rectangle oldRect = this.getRectangle();
        RelationSelection returnSelection = this.relationPoints.getSelectionAndMovePointsIfNecessary(this.pointAtDefaultZoom(mousePosBeforeDragRelative), this.toDefaultZoom(diffX), this.toDefaultZoom(diffY), firstDrag);
        if (returnSelection == RelationSelection.DRAG_BOX) {
            this.setLocationDifference(diffX, diffY);
        }
        if (returnSelection != RelationSelection.NOTHING) {
            this.updateModelFromText();
        }
        if (undoable) {
            this.undoStack.add(new UndoInformation(this.getRectangle(), oldRect, new HashMap<Stickable, List<PointChange>>(), this.getGridSize(), oldAddAttr, this.getAdditionalAttributes()));
        }
    }

    private Point pointAtDefaultZoom(Point p) {
        return new Point(this.toDefaultZoom(p.getX()), this.toDefaultZoom(p.getY()));
    }

    private int toDefaultZoom(int input) {
        return input * 10 / this.getGridSize();
    }

    @Override
    public void dragEnd() {
        boolean updateNecessary = this.relationPoints.removeRelationPointIfOnLineBetweenNeighbourPoints();
        if (updateNecessary) {
            this.updateModelFromText();
        }
    }

    @Override
    public Set<Direction> getResizeArea(int x, int y) {
        return new HashSet<Direction>();
    }

    @Override
    public boolean isSelectableOn(Point point) {
        Point relativePoint = this.toRelative(point);
        boolean isSelectableOn = this.relationPoints.getSelection(this.pointAtDefaultZoom(relativePoint)) != RelationSelection.NOTHING;
        return isSelectableOn;
    }

    @Override
    public Collection<PointDoubleIndexed> getStickablePoints() {
        return this.relationPoints.getStickablePoints();
    }

    @Override
    public List<PointDoubleIndexed> movePoints(List<PointChange> changedStickPoints) {
        List<PointDoubleIndexed> updatedChangedList = this.relationPoints.movePointAndResizeRectangle(changedStickPoints);
        this.updateModelFromText();
        return updatedChangedList;
    }

    @Override
    public Integer getLayer() {
        return this.state.getFacetResponse(LayerFacet.class, LayerFacet.DEFAULT_VALUE_RELATION);
    }

    @Override
    protected Settings createSettings() {
        return new SettingsRelation(){

            @Override
            public RelationPointHandler getRelationPoints() {
                return Relation.this.relationPoints;
            }
        };
    }

    @Override
    protected void drawError(DrawHandler drawer, String errorText) {
        super.drawError(drawer, errorText.replace(">>", "\\>>").replace("<<", "\\<<"));
        RelationLineTypeFacet.drawDefaultLineAndArrows(drawer, this.relationPoints);
    }

    protected Point toRelative(Point point) {
        return new Point(point.getX() - this.getRectangle().getX(), point.getY() - this.getRectangle().getY());
    }

    @Override
    public CursorOwn getCursor(Point point, Set<Direction> resizeDirections) {
        RelationSelection selection = this.relationPoints.getSelection(this.pointAtDefaultZoom(this.toRelative(point)));
        switch (selection) {
            case DRAG_BOX: {
                return CursorOwn.MOVE;
            }
            case LINE: {
                return CursorOwn.CROSS;
            }
            case RELATION_POINT: {
                return CursorOwn.HAND;
            }
        }
        return super.getCursor(point, resizeDirections);
    }
}

