/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarLog;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class HarDatabaseConfig {
    private String driverClassName;
    private String jdbcUrl;
    private String login;
    private String password;
    private String tablePrefix;
    private String dbAutoGeneratedId = "BIGINT PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY";
    private String stringDbType = "CLOB";
    private String longDbType = "BIGINT";
    private String timestampDbType = "TIMESTAMP";
    private String smallIntDbType = "SMALLINT";
    private List<String> createdTables = new LinkedList<String>();
    private Connection con = null;

    public HarDatabaseConfig(String driverClassName, String jdbcUrl, String login, String password, String tablePrefix, String dbAutoGeneratedId, String stringDbType, String longDbType, String timestampDbType, String smallIntDbType) throws SQLException {
        try {
            Class.forName(driverClassName).newInstance();
        }
        catch (Exception e) {
            throw new SQLException("Failed to instantiate database driver " + driverClassName + " (" + e + ")", e);
        }
        this.driverClassName = driverClassName;
        this.jdbcUrl = jdbcUrl;
        this.login = login;
        this.password = password;
        this.tablePrefix = tablePrefix;
        if (dbAutoGeneratedId != null) {
            this.dbAutoGeneratedId = dbAutoGeneratedId;
        }
        if (stringDbType != null) {
            this.stringDbType = stringDbType;
        }
        if (longDbType != null) {
            this.longDbType = longDbType;
        }
        if (timestampDbType != null) {
            this.timestampDbType = timestampDbType;
        }
        if (smallIntDbType != null) {
            this.smallIntDbType = smallIntDbType;
        }
        this.con = DriverManager.getConnection(jdbcUrl, login, password);
        this.con.setTransactionIsolation(2);
        this.initCreatedTables();
    }

    private void initCreatedTables() throws SQLException {
        Connection c = this.getConnection();
        DatabaseMetaData dmd = c.getMetaData();
        ResultSet res = dmd.getTables(null, null, null, new String[]{"TABLE"});
        while (res.next()) {
            this.addCreatedTable(res.getString("TABLE_NAME"));
        }
        res.close();
        this.closeConnection(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> getHarLogIds() throws SQLException {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery("SELECT id FROM " + this.getTablePrefix() + HarLog.TABLE_NAME);
            while (rs.next()) {
                list.add(rs.getLong(1));
            }
            ArrayList<Long> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            ArrayList<Long> arrayList = list;
            return arrayList;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception ignore) {}
            this.closeConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNbOfEntries(String tableName) throws SQLException {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery("SELECT COUNT(*) FROM " + this.getTablePrefix() + tableName);
            rs.next();
            long l = rs.getLong(1);
            return l;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception ignore) {}
            this.closeConnection(c);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public void closeConnection(Connection c) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeNameValueCommentJDBC(long logId, HarDatabaseConfig config, String tableName, String nameColumn, String nameValue, String valueColumn, String valueValue, String commentColumn, String commentValue) throws SQLException {
        long returnedId = -1L;
        Connection c = config.getConnection();
        tableName = config.getTablePrefix() + tableName;
        if (!config.isCreatedTable(tableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + tableName + " (id " + config.getDbAutoGeneratedId() + "," + nameColumn + " " + config.getStringDbType() + "," + valueColumn + " " + config.getStringDbType() + "," + commentColumn + " " + config.getStringDbType() + ", log_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(tableName);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        Statement ps = null;
        try {
            ps = c.prepareStatement("INSERT INTO " + tableName + "(" + nameColumn + "," + valueColumn + "," + commentColumn + ",log_id) VALUES (?,?,?,?)", 1);
            ps.setString(1, nameValue);
            ps.setString(2, valueValue);
            if (commentValue == null) {
                ps.setNull(3, -1);
            } else {
                ps.setString(3, commentValue);
            }
            ps.setLong(4, logId);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarEntry row");
            }
            returnedId = rs.getLong(1);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
        return returnedId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableIfEmpty(Connection c, String tableName, HarDatabaseConfig config) throws SQLException {
        Statement s = null;
        ResultSet rs = null;
        try {
            s = c.createStatement();
            rs = s.executeQuery("SELECT COUNT(*) FROM " + tableName);
            rs.next();
            if (rs.getLong(1) == 0L) {
                s.executeUpdate("DROP TABLE " + tableName);
                config.removeTable(tableName);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromTable(long logId, HarDatabaseConfig config, String tableName) throws SQLException {
        Connection c = config.getConnection();
        tableName = config.getTablePrefix() + tableName;
        Statement ps = null;
        try {
            ps = c.prepareStatement("DELETE FROM " + tableName + " WHERE log_id=?");
            ps.setLong(1, logId);
            ps.executeUpdate();
            config.dropTableIfEmpty(c, tableName, config);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void addCreatedTable(String tableName) {
        this.createdTables.add(tableName.toUpperCase());
    }

    public boolean isCreatedTable(String tableName) {
        return this.createdTables.contains(tableName.toUpperCase());
    }

    public void removeTable(String tableName) {
        this.createdTables.remove(tableName.toUpperCase());
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getDbAutoGeneratedId() {
        return this.dbAutoGeneratedId;
    }

    public void setDbAutoGeneratedId(String dbAutoGeneratedId) {
        this.dbAutoGeneratedId = dbAutoGeneratedId;
    }

    public String getStringDbType() {
        return this.stringDbType;
    }

    public void setStringDbType(String stringDbType) {
        this.stringDbType = stringDbType;
    }

    public String getSmallIntDbType() {
        return this.smallIntDbType;
    }

    public void setSmallIntDbType(String smallIntDbType) {
        this.smallIntDbType = smallIntDbType;
    }

    public String getLongDbType() {
        return this.longDbType;
    }

    public void setLongDbType(String longDbType) {
        this.longDbType = longDbType;
    }

    public String getTimestampDbType() {
        return this.timestampDbType;
    }

    public void setTimestampDbType(String timestampDbType) {
        this.timestampDbType = timestampDbType;
    }
}

