/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text.whitespace;

import org.pentaho.reporting.libraries.fonts.text.whitespace.WhiteSpaceFilter;

public class PreserveBreaksWhiteSpaceFilter
implements WhiteSpaceFilter {
    private boolean collapse;

    public void reset() {
        this.collapse = false;
    }

    public int filter(int codepoint) {
        if (this.isLinebreak(codepoint)) {
            this.collapse = true;
            return codepoint;
        }
        if (this.isWhitespace(codepoint)) {
            if (this.collapse) {
                return -1;
            }
            this.collapse = true;
            return 32;
        }
        if (codepoint == Integer.MIN_VALUE) {
            this.collapse = true;
            return -1;
        }
        if (codepoint == Integer.MAX_VALUE) {
            return -1;
        }
        this.collapse = false;
        return codepoint;
    }

    private boolean isWhitespace(int codepoint) {
        char ch = (char)(codepoint & 0xFFFF);
        return Character.isWhitespace(ch);
    }

    protected boolean isLinebreak(int codepoint) {
        return codepoint == 10 || codepoint == 13;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

