/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.jps.JpsProxy;
import org.netbeans.lib.profiler.jps.RunningVM;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.ui.panels.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;

public final class PIDSelectPanel
extends JPanel
implements ActionListener,
HelpCtx.Provider {
    private static final HelpCtx HELP_CTX = new HelpCtx("PIDSelectPanel.HelpCtx");
    private static final int MAX_WIDTH = 500;
    private JButton button;
    private JButton okButton;
    private JComboBox combo;
    private HTMLTextArea detailsArea;

    public PIDSelectPanel(JButton jButton) {
        this.okButton = jButton;
        this.combo = new JComboBox();
        this.button = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.button, (String)Bundle.PIDSelectPanel_RefreshButtonName());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.detailsArea = new HTMLTextArea();
        this.detailsArea.getAccessibleContext().setAccessibleName(Bundle.PIDSelectPanel_SelectedProcessAccessName());
        this.detailsArea.setEditable(false);
        this.detailsArea.setOpaque(true);
        this.detailsArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.detailsArea.setPreferredSize(new Dimension(1, 1));
        JScrollPane jScrollPane = new JScrollPane((Component)this.detailsArea, 20, 30);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setPreferredSize(new Dimension(250, 200));
        jPanel.add((Component)jScrollPane, "Center");
        this.combo.setRenderer(new PIDComboRenderer());
        this.combo.getAccessibleContext().setAccessibleName(Bundle.PIDSelectPanel_ComboAccessName());
        this.combo.getAccessibleContext().setAccessibleDescription(Bundle.PIDSelectPanel_ComboAccessDescr());
        this.button.getAccessibleContext().setAccessibleDescription(Bundle.PIDSelectPanel_ButtonAccessDescr());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout(0, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(5, 0));
        jPanel2.add((Component)this.combo, "Center");
        jPanel2.add((Component)this.button, "East");
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        jButton.setEnabled(false);
        this.refreshCombo();
        this.button.addActionListener(this);
        this.combo.addActionListener(this);
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPID() {
        Object object = this.combo.getSelectedItem();
        if (object != null && object instanceof RunningVM) {
            return ((RunningVM)object).getPid();
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(dimension.width, 500), dimension.height);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.button) {
            this.refreshCombo();
        } else if (actionEvent.getSource() == this.combo) {
            this.okButton.setEnabled(this.combo.getSelectedItem() instanceof RunningVM);
            this.updateInfo();
        }
    }

    public static int selectPID() {
        JButton jButton = new JButton(Bundle.PIDSelectPanel_OkButtonName());
        PIDSelectPanel pIDSelectPanel = new PIDSelectPanel(jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)pIDSelectPanel, Bundle.PIDSelectPanel_SelectProcessDialogCaption(), true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            return pIDSelectPanel.getPID();
        }
        return -1;
    }

    private void refreshCombo() {
        final Object object = this.combo.getSelectedItem();
        this.okButton.setEnabled(false);
        this.combo.setEnabled(false);
        this.combo.setModel(new DefaultComboBoxModel<Object>(new Object[]{Bundle.PIDSelectPanel_ProcessesListItemText()}));
        new SwingWorker<Object[], Object>(){

            @Override
            protected Object[] doInBackground() throws Exception {
                RunningVM[] runningVMArray = JpsProxy.getRunningVMs();
                Object[] objectArray = new Object[(runningVMArray == null ? 0 : runningVMArray.length) + 1];
                if (runningVMArray == null) {
                    objectArray[0] = Bundle.PIDSelectPanel_ErrorGettingProcessesItemText();
                } else if (runningVMArray.length == 0) {
                    objectArray[0] = Bundle.PIDSelectPanel_NoProcessesItemText();
                } else {
                    objectArray[0] = Bundle.PIDSelectPanel_SelectProcessItemText();
                    System.arraycopy(runningVMArray, 0, objectArray, 1, runningVMArray.length);
                }
                return objectArray;
            }

            @Override
            protected void done() {
                try {
                    PIDSelectPanel.this.combo.setEnabled(true);
                    PIDSelectPanel.this.combo.setModel(new DefaultComboBoxModel<Object>((Object[])this.get()));
                    if (object != null) {
                        PIDSelectPanel.this.combo.setSelectedItem(object);
                    }
                    PIDSelectPanel.this.updateInfo();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }.execute();
    }

    private void updateInfo() {
        StringBuilder stringBuilder;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        Object object = this.combo.getSelectedItem();
        if (object != null && object instanceof RunningVM) {
            stringBuilder = (RunningVM)object;
            string = "" + stringBuilder.getPid();
            string2 = stringBuilder.getMainClass();
            string3 = stringBuilder.getMainArgs();
            string4 = stringBuilder.getVMArgs();
            string5 = stringBuilder.getVMFlags();
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append("<table cellspacing=\"3\" cellpadding=\"0\">");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.PIDSelectPanel_PidLabelText());
        stringBuilder.append("</b>&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td>");
        stringBuilder.append(string);
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.PIDSelectPanel_MainClassLabelText());
        stringBuilder.append("</b>&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td>");
        stringBuilder.append(string2);
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.PIDSelectPanel_ArgumentsLabelText());
        stringBuilder.append("</b>&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td>");
        stringBuilder.append(string3);
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.PIDSelectPanel_VmArgumentsLabelText());
        stringBuilder.append("</b>&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td>");
        stringBuilder.append(string4);
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<td valign='top'><nobr><b>");
        stringBuilder.append(Bundle.PIDSelectPanel_VmFlagsLabelText());
        stringBuilder.append("</b>&nbsp;&nbsp;</nobr></td>");
        stringBuilder.append("<td>");
        stringBuilder.append(string5);
        stringBuilder.append("</td>");
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
        this.detailsArea.setText(stringBuilder.toString());
        this.detailsArea.setCaretPosition(0);
    }

    private static class PIDComboRenderer
    extends DefaultListCellRenderer {
        private PIDComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof RunningVM) {
                RunningVM runningVM = (RunningVM)object;
                String string = runningVM.getMainArgs();
                string = string == null ? "" : " " + string;
                String string2 = Bundle.PIDSelectPanel_VmComboItemText(runningVM.getMainClass(), "" + runningVM.getPid());
                return super.getListCellRendererComponent((JList<?>)jList, string2, n, bl, bl2);
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

