require 'spec_helper'

describe "Dashboard Issues Feed", feature: true  do
  describe "GET /issues" do
    let!(:user)     { create(:user) }
    let!(:project1) { create(:project) }
    let!(:project2) { create(:project) }
    let!(:issue1)   { create(:issue, author: user, assignee: user, project: project1) }
    let!(:issue2)   { create(:issue, author: user, assignee: user, project: project2) }

    before do
      project1.team << [user, :master]
      project2.team << [user, :master]
    end

    describe "atom feed" do
      it "should render atom feed via private token" do
        visit issues_dashboard_path(:atom, private_token: user.private_token)

        expect(response_headers['Content-Type']).
          to have_content('application/atom+xml')
        expect(body).to have_selector('title', text: "#{user.name} issues")
        expect(body).to have_selector('author email', text: issue1.author_email)
        expect(body).to have_selector('entry summary', text: issue1.title)
        expect(body).to have_selector('author email', text: issue2.author_email)
        expect(body).to have_selector('entry summary', text: issue2.title)
      end
    end
  end
end
