/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.AbstractVersionSelector;

public class LatestVersionSelector
extends AbstractVersionSelector {
    private final String selectorStatus;

    public LatestVersionSelector(String selector) {
        super(selector);
        this.selectorStatus = selector.substring("latest.".length());
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public boolean requiresMetadata() {
        return true;
    }

    @Override
    public boolean matchesUniqueVersion() {
        return true;
    }

    @Override
    public boolean accept(String candidate) {
        throw new UnsupportedOperationException("accept(String, String)");
    }

    @Override
    public boolean accept(ComponentMetadata candidate) {
        int selectorStatusIndex = candidate.getStatusScheme().indexOf(this.selectorStatus);
        int candidateStatusIndex = candidate.getStatusScheme().indexOf(candidate.getStatus());
        return selectorStatusIndex >= 0 && selectorStatusIndex <= candidateStatusIndex;
    }
}

