/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.util.CollectionUtils;

public class DefaultIncludeDirectives
implements IncludeDirectives,
Serializable {
    private final List<Include> allIncludes = new ArrayList<Include>();

    public void addAll(List<Include> includes) {
        this.allIncludes.addAll(includes);
    }

    public List<Include> getQuotedIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.QUOTED;
            }
        });
    }

    public List<Include> getSystemIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.SYSTEM;
            }
        });
    }

    public List<Include> getMacroIncludes() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return element.getType() == IncludeType.MACRO;
            }
        });
    }

    public List<Include> getIncludesAndImports() {
        return this.allIncludes;
    }

    public List<Include> getIncludesOnly() {
        return CollectionUtils.filter(this.allIncludes, (Spec)new Spec<Include>(){

            public boolean isSatisfiedBy(Include element) {
                return !element.isImport();
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIncludeDirectives that = (DefaultIncludeDirectives)o;
        return this.allIncludes.equals(that.allIncludes);
    }

    public int hashCode() {
        return this.allIncludes.hashCode();
    }
}

