/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.jetty;

import java.lang.reflect.Method;
import java.net.BindException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.PortInUseException;
import org.springframework.boot.context.embedded.jetty.JettyEmbeddedWebAppContext;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class JettyEmbeddedServletContainer
implements EmbeddedServletContainer {
    private static final Log logger = LogFactory.getLog(JettyEmbeddedServletContainer.class);
    private final Object monitor = new Object();
    private final Server server;
    private final boolean autoStart;
    private Connector[] connectors;

    public JettyEmbeddedServletContainer(Server server) {
        this(server, true);
    }

    public JettyEmbeddedServletContainer(Server server, boolean autoStart) {
        this.autoStart = autoStart;
        Assert.notNull((Object)server, (String)"Jetty Server must not be null");
        this.server = server;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.connectors = this.server.getConnectors();
                this.server.setConnectors(null);
                this.server.start();
                this.server.setStopAtShutdown(false);
            }
            catch (Exception ex) {
                this.stopSilently();
                throw new EmbeddedServletContainerException("Unable to start embedded Jetty servlet container", ex);
            }
        }
    }

    private void stopSilently() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void start() throws EmbeddedServletContainerException {
        this.server.setConnectors(this.connectors);
        if (!this.autoStart) {
            return;
        }
        try {
            Connector[] connectors;
            this.server.start();
            for (Handler handler : this.server.getHandlers()) {
                this.handleDeferredInitialize(handler);
            }
            for (Connector connector : connectors = this.server.getConnectors()) {
                try {
                    connector.start();
                }
                catch (BindException ex) {
                    if (connector instanceof NetworkConnector) {
                        throw new PortInUseException(((NetworkConnector)connector).getPort());
                    }
                    throw ex;
                }
            }
            logger.info((Object)("Jetty started on port(s) " + this.getActualPortsDescription()));
        }
        catch (EmbeddedServletContainerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embedded Jetty servlet container", ex);
        }
    }

    private String getActualPortsDescription() {
        StringBuilder ports = new StringBuilder();
        for (Connector connector : this.server.getConnectors()) {
            ports.append(ports.length() == 0 ? "" : ", ");
            ports.append(this.getLocalPort(connector) + this.getProtocols(connector));
        }
        return ports.toString();
    }

    private Integer getLocalPort(Connector connector) {
        try {
            return (Integer)ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(connector.getClass(), (String)"getLocalPort"), (Object)connector);
        }
        catch (Exception ex) {
            logger.info((Object)("could not determine port ( " + ex.getMessage() + ")"));
            return 0;
        }
    }

    private String getProtocols(Connector connector) {
        try {
            List protocols = connector.getProtocols();
            return " (" + StringUtils.collectionToDelimitedString((Collection)protocols, (String)", ") + ")";
        }
        catch (NoSuchMethodError ex) {
            return "";
        }
    }

    private void handleDeferredInitialize(Handler ... handlers) throws Exception {
        for (Handler handler : handlers) {
            if (handler instanceof JettyEmbeddedWebAppContext) {
                ((JettyEmbeddedWebAppContext)handler).deferredInitialize();
                continue;
            }
            if (handler instanceof HandlerWrapper) {
                this.handleDeferredInitialize(((HandlerWrapper)handler).getHandler());
                continue;
            }
            if (!(handler instanceof HandlerCollection)) continue;
            this.handleDeferredInitialize(((HandlerCollection)handler).getHandlers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.server.stop();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                throw new EmbeddedServletContainerException("Unable to stop embedded Jetty servlet container", ex);
            }
        }
    }

    @Override
    public int getPort() {
        int n = 0;
        Connector[] connectors = this.server.getConnectors();
        Connector[] connectorArray = connectors;
        int n2 = connectorArray.length;
        if (n < n2) {
            Connector connector = connectorArray[n];
            return this.getLocalPort(connector);
        }
        return 0;
    }

    public Server getServer() {
        return this.server;
    }
}

