/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public abstract class AbstractOsmDataPaster {
    protected final DataFlavor df;

    protected AbstractOsmDataPaster(DataFlavor dataFlavor) {
        this.df = dataFlavor;
    }

    public boolean supports(TransferHandler.TransferSupport transferSupport) {
        return transferSupport.isDataFlavorSupported(this.df) && AbstractOsmDataPaster.isCopy(transferSupport);
    }

    public boolean supports(Collection<DataFlavor> collection) {
        return collection.contains(this.df);
    }

    private static boolean isCopy(TransferHandler.TransferSupport transferSupport) {
        return !transferSupport.isDrop() || (1 & transferSupport.getSourceDropActions()) == 1;
    }

    public abstract boolean importData(TransferHandler.TransferSupport var1, OsmDataLayer var2, EastNorth var3) throws UnsupportedFlavorException, IOException;

    public boolean importTagsOn(TransferHandler.TransferSupport transferSupport, Collection<? extends OsmPrimitive> collection) throws UnsupportedFlavorException, IOException {
        return false;
    }
}

